/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.block.tiles.PresentBlockTile;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class ServerBoundSetPresentPacket {
    private final BlockPos pos;
    private final boolean packed;
    private final String sender;
    private final String recipient;
    private final String description;

    public ServerBoundSetPresentPacket(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.packed = buf.readBoolean();
        this.recipient = buf.func_218666_n();
        this.sender = buf.func_218666_n();
        this.description = buf.func_218666_n();
    }

    public ServerBoundSetPresentPacket(BlockPos pos, boolean packed, String recipient, String sender, String description) {
        this.pos = pos;
        this.packed = packed;
        this.recipient = recipient;
        this.sender = sender;
        this.description = description;
    }

    public static void buffer(ServerBoundSetPresentPacket message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.writeBoolean(message.packed);
        buf.func_180714_a(message.recipient);
        buf.func_180714_a(message.sender);
        buf.func_180714_a(message.description);
    }

    public static void handler(ServerBoundSetPresentPacket message, Supplier<NetworkEvent.Context> ctx) {
        ServerPlayerEntity player = Objects.requireNonNull(ctx.get().getSender());
        World world = player.field_70170_p;
        ctx.get().enqueueWork(() -> {
            BlockPos pos = message.pos;
            TileEntity te = world.func_175625_s(message.pos);
            if (te instanceof PresentBlockTile) {
                PresentBlockTile present = (PresentBlockTile)te;
                present.updateState(message.packed, message.recipient, message.sender, message.description);
                BlockState state = world.func_180495_p(pos);
                present.func_70296_d();
                world.func_184138_a(pos, state, state, 3);
                if (message.packed) {
                    player.func_71128_l();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

