/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.addons.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.darkhax.botanypots.BotanyPots;
import net.darkhax.botanypots.addons.jei.CropWrapper;
import net.darkhax.botanypots.crop.HarvestEntry;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class CategoryCrop
implements IRecipeCategory<CropWrapper> {
    public static final ResourceLocation ID = new ResourceLocation("botanypots", "soil");
    private final IDrawable icon;
    private final IDrawableStatic background;
    private final IDrawableStatic slotDrawable;

    public CategoryCrop(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)BotanyPots.instance.getContent().basicBotanyPot));
        this.background = guiHelper.createBlankDrawable(155, 57);
        this.slotDrawable = guiHelper.getSlotDrawable();
    }

    public ResourceLocation getUid() {
        return ID;
    }

    public Class<? extends CropWrapper> getRecipeClass() {
        return CropWrapper.class;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"botanypots.title", (Object[])new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CropWrapper recipe, IIngredients ingredients) {
        recipe.setIngredients(ingredients);
    }

    public void draw(CropWrapper recipe, MatrixStack matrix, double mouseX, double mouseY) {
        this.slotDrawable.draw(matrix, 0, 0);
        this.slotDrawable.draw(matrix, 0, 19);
        for (int nextSlotId = 2; nextSlotId < 14; ++nextSlotId) {
            int relativeSlotId = nextSlotId - 2;
            this.slotDrawable.draw(matrix, 80 + 19 * (relativeSlotId % 4), 19 * (relativeSlotId / 4));
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, CropWrapper recipe, IIngredients ingredients) {
        IGuiItemStackGroup stacks = recipeLayout.getItemStacks();
        stacks.init(0, true, 0, 0);
        stacks.set(0, recipe.getSeedItems());
        stacks.init(1, true, 0, 19);
        stacks.set(1, recipe.getSoilItems());
        int nextSlotId = 2;
        for (HarvestEntry entry : recipe.getDrops()) {
            int relativeSlotId = nextSlotId - 2;
            stacks.init(nextSlotId, false, 80 + 19 * (relativeSlotId % 4), 19 * (relativeSlotId / 4));
            stacks.set(nextSlotId, entry.getItem());
            ++nextSlotId;
        }
        stacks.addTooltipCallback(recipe::getTooltip);
    }
}

