/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.trapper.lib.common.block;

import growthcraft.trapper.init.GrowthcraftTrapperSoundsEvents;
import growthcraft.trapper.init.GrowthcraftTrapperTileEntities;
import growthcraft.trapper.lib.common.tileentity.TileEntityFishtrap;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.network.NetworkHooks;

public class FishtrapBlock
extends Block
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public FishtrapBlock() {
        this(FishtrapBlock.getInitProperties(Material.field_151575_d));
    }

    public FishtrapBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    private static AbstractBlock.Properties getInitProperties(Material material) {
        AbstractBlock.Properties properties = AbstractBlock.Properties.func_200945_a((Material)material);
        properties.func_200948_a(2.0f, 3.0f);
        properties.harvestTool(ToolType.AXE);
        properties.harvestLevel(1);
        properties.func_226896_b_();
        properties.func_200947_a(SoundType.field_185848_a);
        return properties;
    }

    public static Direction getFacingFromEntity(BlockPos clickedBlock, LivingEntity placer) {
        return Direction.func_176737_a((float)((float)(placer.func_226277_ct_() - (double)clickedBlock.func_177958_n())), (float)((float)(placer.func_226278_cu_() - (double)clickedBlock.func_177956_o())), (float)((float)(placer.func_226281_cx_() - (double)clickedBlock.func_177952_p())));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)GrowthcraftTrapperTileEntities.oakFishtrapTileEntity.get()).func_200968_a();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            TileEntity tile = worldIn.func_175625_s(pos);
            if (tile instanceof TileEntityFishtrap) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((TileEntityFishtrap)tile), (BlockPos)pos);
                ((TileEntityFishtrap)tile).playSound(null, (SoundEvent)GrowthcraftTrapperSoundsEvents.fishtrapOpen.get());
                return ActionResultType.SUCCESS;
            }
        } else {
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer != null) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)FishtrapBlock.getFacingFromEntity(pos, placer)), 2);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        TileEntity tile;
        if (state.func_177230_c() != newState.func_177230_c() && (tile = worldIn.func_175625_s(pos)) != null && tile instanceof TileEntityFishtrap) {
            InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, ((TileEntityFishtrap)tile).func_190576_q());
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H, WATERLOGGED});
    }
}

