/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsutility.modules.environmental.blocks.EnvironmentalControllerTileEntity;
import mcjty.rftoolsutility.modules.environmental.modules.EnvironmentModule;
import mcjty.rftoolsutility.modules.environmental.modules.PeacefulEModule;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PeacefulAreaManager {
    private static final Map<GlobalPos, PeacefulArea> areas = new HashMap<GlobalPos, PeacefulArea>();

    public static void markArea(GlobalPos coordinate, int radius, int miny, int maxy) {
        if (areas.containsKey(coordinate)) {
            areas.get(coordinate).touch().setArea(radius, miny, maxy);
        } else {
            PeacefulArea area = new PeacefulArea(radius, miny, maxy);
            areas.put(coordinate, area);
        }
    }

    public static boolean isPeaceful(GlobalPos coordinate) {
        if (areas.isEmpty()) {
            return false;
        }
        ArrayList<GlobalPos> toRemove = new ArrayList<GlobalPos>();
        boolean peaceful = false;
        long curtime = System.currentTimeMillis() - 10000L;
        for (Map.Entry<GlobalPos, PeacefulArea> entry : areas.entrySet()) {
            BlockPos c;
            ServerWorld world;
            GlobalPos entryCoordinate;
            PeacefulArea area = entry.getValue();
            if (area.in(coordinate, entryCoordinate = entry.getKey())) {
                peaceful = true;
            }
            if (area.getLastTouched() >= curtime || (world = ServerLifecycleHooks.getCurrentServer().func_71218_a(entryCoordinate.func_239646_a_())) == null || !LevelTools.isLoaded((World)world, (BlockPos)(c = entryCoordinate.func_218180_b()))) continue;
            boolean removeArea = true;
            TileEntity te = world.func_175625_s(c);
            if (te instanceof EnvironmentalControllerTileEntity) {
                EnvironmentalControllerTileEntity controllerTileEntity = (EnvironmentalControllerTileEntity)te;
                for (EnvironmentModule module : controllerTileEntity.getEnvironmentModules()) {
                    if (!(module instanceof PeacefulEModule) || !((PeacefulEModule)module).isActive()) continue;
                    removeArea = false;
                    break;
                }
            }
            if (!removeArea) continue;
            toRemove.add(entryCoordinate);
        }
        for (GlobalPos globalCoordinate : toRemove) {
            areas.remove(globalCoordinate);
        }
        return peaceful;
    }

    public static class PeacefulArea {
        private float sqradius;
        private int miny;
        private int maxy;
        private long lastTouched;

        public PeacefulArea(float radius, int miny, int maxy) {
            this.sqradius = radius * radius;
            this.miny = miny;
            this.maxy = maxy;
            this.touch();
        }

        public PeacefulArea setArea(float radius, int miny, int maxy) {
            this.sqradius = radius * radius;
            this.miny = miny;
            this.maxy = maxy;
            return this;
        }

        public String toString() {
            return "PeacefulArea{sqradius=" + this.sqradius + ", miny=" + this.miny + ", maxy=" + this.maxy + ", lastTouched=" + this.lastTouched + '}';
        }

        public long getLastTouched() {
            return this.lastTouched;
        }

        public PeacefulArea touch() {
            this.lastTouched = System.currentTimeMillis();
            return this;
        }

        public boolean in(GlobalPos coordinate, GlobalPos thisCoordinate) {
            double pz;
            if (!coordinate.func_239646_a_().equals(thisCoordinate.func_239646_a_())) {
                return false;
            }
            double py = coordinate.func_218180_b().func_177956_o();
            if (py < (double)this.miny || py > (double)this.maxy) {
                return false;
            }
            double px = coordinate.func_218180_b().func_177958_n() - thisCoordinate.func_218180_b().func_177958_n();
            double sqdist = px * px + (pz = (double)(coordinate.func_218180_b().func_177952_p() - thisCoordinate.func_218180_b().func_177952_p())) * pz;
            return sqdist < (double)this.sqradius;
        }
    }
}

