/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.blocks;

import javax.annotation.Nonnull;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.NBTTools;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterReceiverTileEntity;
import mcjty.rftoolsutility.modules.teleporter.blocks.MatterTransmitterTileEntity;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestinations;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SimpleDialerItemBlock
extends BlockItem {
    public SimpleDialerItemBlock(Block block) {
        super(block, new Item.Properties().func_200916_a(RFToolsUtility.setup.getTab()));
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        TileEntity te = world.func_175625_s(pos);
        if (!world.field_72995_K) {
            if (te instanceof MatterTransmitterTileEntity) {
                MatterTransmitterTileEntity matterTransmitterTileEntity = (MatterTransmitterTileEntity)te;
                if (!matterTransmitterTileEntity.checkAccess(player.func_145748_c_().getString())) {
                    Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "You have no access to this matter transmitter!"));
                    return ActionResultType.FAIL;
                }
                BlockPos mpos = matterTransmitterTileEntity.func_174877_v();
                NBTTools.setInfoNBT((ItemStack)stack, CompoundNBT::func_74768_a, (String)"transX", (Object)mpos.func_177958_n());
                NBTTools.setInfoNBT((ItemStack)stack, CompoundNBT::func_74768_a, (String)"transY", (Object)mpos.func_177956_o());
                NBTTools.setInfoNBT((ItemStack)stack, CompoundNBT::func_74768_a, (String)"transZ", (Object)mpos.func_177952_p());
                NBTTools.setInfoNBT((ItemStack)stack, CompoundNBT::func_74778_a, (String)"transDim", (Object)world.func_234923_W_().func_240901_a_().toString());
                if (matterTransmitterTileEntity.isDialed()) {
                    Integer id = matterTransmitterTileEntity.getTeleportId();
                    boolean access = this.checkReceiverAccess(player, world, id);
                    if (!access) {
                        Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "You have no access to the matter receiver!"));
                        return ActionResultType.FAIL;
                    }
                    NBTTools.setInfoNBT((ItemStack)stack, CompoundNBT::func_74768_a, (String)"receiver", (Object)id);
                    Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Receiver set!"));
                }
                Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Transmitter set!"));
            } else if (te instanceof MatterReceiverTileEntity) {
                MatterReceiverTileEntity matterReceiverTileEntity = (MatterReceiverTileEntity)te;
                Integer id = matterReceiverTileEntity.getOrCalculateID();
                boolean access = this.checkReceiverAccess(player, world, id);
                if (!access) {
                    Logging.message((PlayerEntity)player, (String)(TextFormatting.RED + "You have no access to this matter receiver!"));
                    return ActionResultType.FAIL;
                }
                NBTTools.setInfoNBT((ItemStack)stack, CompoundNBT::func_74768_a, (String)"receiver", (Object)id);
                Logging.message((PlayerEntity)player, (String)(TextFormatting.YELLOW + "Receiver set!"));
            } else {
                return super.func_195939_a(context);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    private boolean checkReceiverAccess(PlayerEntity player, World world, Integer id) {
        MatterReceiverTileEntity receiver;
        TileEntity recTe;
        ServerWorld worldForDimension;
        TeleportDestination destination;
        boolean access = true;
        TeleportDestinations destinations = TeleportDestinations.get(world);
        GlobalPos coordinate = destinations.getCoordinateForId(id);
        if (coordinate != null && (destination = destinations.getDestination(coordinate)) != null && (worldForDimension = LevelTools.getLevel(destination.getDimension())) != null && (recTe = worldForDimension.func_175625_s(destination.getCoordinate())) instanceof MatterReceiverTileEntity && !(destination = (receiver = (MatterReceiverTileEntity)recTe).updateDestination()).checkAccess((World)worldForDimension, player.func_110124_au())) {
            access = false;
        }
        return access;
    }
}

