/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import org.lwjgl.opengl.GL11;

public final class Render {
    private Render() {
    }

    public static void drawOutlineRect(MatrixStack ms, int x, int y, int w, int h, int color) {
        Render.drawOutlineRect(ms, x, y, w, h, color, 1.0f);
    }

    public static void drawOutlineRect(MatrixStack ms, int x, int y, int w, int h, int color, float lineWidth) {
        Render.drawOutlineRect(ms.func_227866_c_().func_227870_a_(), x, y, w, h, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, color >> 24 & 0xFF, lineWidth);
    }

    public static void drawOutlineRect(Matrix4f matrix, int x, int y, int w, int h, int red, int green, int blue, int alpha, float lineWidth) {
        if (lineWidth <= 0.0f) {
            return;
        }
        BufferBuilder vertexBuffer = Tessellator.func_178181_a().func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        GL11.glLineWidth((float)lineWidth);
        vertexBuffer.func_181668_a(2, DefaultVertexFormats.field_181706_f);
        vertexBuffer.func_227888_a_(matrix, (float)x, (float)y, 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, (float)(x + w), (float)y, 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, (float)(x + w), (float)(y + h), 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        vertexBuffer.func_227888_a_(matrix, (float)x, (float)(y + h), 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        vertexBuffer.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)vertexBuffer);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawEntity(MatrixStack matrixStack, int x, int y, double scale, float headYaw, float yaw, float pitch, Entity entity) {
        LivingEntity livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        Minecraft mc = Minecraft.func_71410_x();
        if (entity.field_70170_p == null) {
            entity.field_70170_p = mc.field_71441_e;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x, (double)y, 1050.0);
        matrixStack.func_227862_a_(1.0f, 1.0f, -1.0f);
        matrixStack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixStack.func_227862_a_((float)scale, (float)scale, (float)scale);
        Quaternion pitchRotation = Vector3f.field_229179_b_.func_229187_a_(pitch);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(pitchRotation);
        float oldYawOffset = livingEntity == null ? 0.0f : livingEntity.field_70761_aq;
        float oldPrevYawHead = livingEntity == null ? 0.0f : livingEntity.field_70758_at;
        float oldYawHead = livingEntity == null ? 0.0f : livingEntity.field_70759_as;
        float oldYaw = entity.field_70177_z;
        float oldPitch = entity.field_70125_A;
        entity.field_70177_z = 180.0f + headYaw;
        entity.field_70125_A = -pitch;
        if (livingEntity != null) {
            livingEntity.field_70761_aq = 180.0f + yaw;
            livingEntity.field_70759_as = entity.field_70177_z;
            livingEntity.field_70758_at = entity.field_70177_z;
        }
        EntityRendererManager entityrenderermanager = mc.func_175598_ae();
        pitchRotation.func_195892_e();
        entityrenderermanager.func_229089_a_(pitchRotation);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl buffers = mc.func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> entityrenderermanager.func_229084_a_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)buffers, 0xF000F0));
        buffers.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        entity.field_70177_z = oldYaw;
        entity.field_70125_A = oldPitch;
        if (livingEntity != null) {
            livingEntity.field_70761_aq = oldYawOffset;
            livingEntity.field_70758_at = oldPrevYawHead;
            livingEntity.field_70759_as = oldYawHead;
        }
        matrixStack.func_227865_b_();
    }
}

