/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneBuilders;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.controls.Tooltip;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemIcon
extends Pane {
    private static final float DEFAULT_ITEMSTACK_SIZE = 16.0f;
    private ItemStack itemStack;
    private static final Vector3f DEF_LIGHT = (Vector3f)Util.func_200696_a((Object)new Vector3f(0.55f, 0.3f, -0.8f), Vector3f::func_229194_d_);
    private static final Vector3f DIF_LIGHT = (Vector3f)Util.func_200696_a((Object)new Vector3f(-0.8f, 0.3f, 0.55f), Vector3f::func_229194_d_);

    public ItemIcon() {
    }

    public ItemIcon(PaneParams params) {
        super(params);
        Item item;
        String itemName = params.getString("item");
        if (itemName != null && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))) != null) {
            this.setItem(item.func_190903_i());
        }
    }

    public void setItem(ItemStack itemStackIn) {
        this.itemStack = itemStackIn;
        if (this.onHover instanceof Tooltip) {
            ((Tooltip)this.onHover).setTextOld(this.window.getScreen().func_231151_a_(this.itemStack));
        }
    }

    public ItemStack getItem() {
        return this.itemStack;
    }

    @Override
    public void drawSelf(MatrixStack ms, double mx, double my) {
        if (this.itemStack != null && !this.itemStack.func_190926_b()) {
            ms.func_227860_a_();
            ms.func_227861_a_((double)this.x, (double)this.y, 0.0);
            ms.func_227862_a_((float)this.getWidth() / 16.0f, (float)this.getHeight() / 16.0f, 1.0f);
            FontRenderer font = this.itemStack.func_77973_b().getFontRenderer(this.itemStack);
            if (font == null) {
                font = this.mc.field_71466_p;
            }
            this.renderItemModelIntoGUI(this.itemStack, ms, this.mc.func_175599_af().func_184393_a(this.itemStack, null, (LivingEntity)this.mc.field_71439_g));
            this.renderGuiItemDecorations(ms, font, this.itemStack);
            ms.func_227865_b_();
        }
    }

    private void renderGuiItemDecorations(MatrixStack matrixstack, FontRenderer fontRenderer, ItemStack stack) {
        float f3;
        if (stack.func_190916_E() != 1) {
            String s = String.valueOf(stack.func_190916_E());
            matrixstack.func_227860_a_();
            matrixstack.func_227861_a_(0.0, 0.0, 100.0);
            IRenderTypeBuffer.Impl irendertypebuffer$impl = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
            fontRenderer.func_228079_a_(s, (float)(17 - fontRenderer.func_78256_a(s)), 9.0f, 0xFFFFFF, true, matrixstack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)irendertypebuffer$impl, false, 0, 0xF000F0);
            irendertypebuffer$impl.func_228461_a_();
            matrixstack.func_227865_b_();
        }
        if (stack.func_77973_b().showDurabilityBar(stack)) {
            RenderSystem.disableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.disableAlphaTest();
            RenderSystem.disableBlend();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            double health = stack.func_77973_b().getDurabilityForDisplay(stack);
            int i = Math.round(13.0f - (float)health * 13.0f);
            int j = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
            this.fillRect(matrixstack, bufferbuilder, 2, 13, 13, 2, 0, 0, 0, 255);
            this.fillRect(matrixstack, bufferbuilder, 2, 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
            RenderSystem.enableBlend();
            RenderSystem.enableAlphaTest();
            RenderSystem.enableTexture();
            RenderSystem.enableDepthTest();
        }
        float f = f3 = this.mc.field_71439_g == null ? 0.0f : this.mc.field_71439_g.func_184811_cZ().func_185143_a(stack.func_77973_b(), this.mc.func_184121_ak());
        if (f3 > 0.0f) {
            RenderSystem.disableDepthTest();
            RenderSystem.disableTexture();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Tessellator tessellator1 = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder1 = tessellator1.func_178180_c();
            this.fillRect(matrixstack, bufferbuilder1, 0, MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 16, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
            RenderSystem.enableTexture();
            RenderSystem.enableDepthTest();
        }
    }

    private void fillRect(MatrixStack matrixstack, BufferBuilder p_181565_1_, int p_181565_2_, int p_181565_3_, int p_181565_4_, int p_181565_5_, int p_181565_6_, int p_181565_7_, int p_181565_8_, int p_181565_9_) {
        p_181565_1_.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Matrix4f pose = matrixstack.func_227866_c_().func_227870_a_();
        p_181565_1_.func_227888_a_(pose, (float)(p_181565_2_ + 0), (float)(p_181565_3_ + 0), 0.0f).func_225586_a_(p_181565_6_, p_181565_7_, p_181565_8_, p_181565_9_).func_181675_d();
        p_181565_1_.func_227888_a_(pose, (float)(p_181565_2_ + 0), (float)(p_181565_3_ + p_181565_5_), 0.0f).func_225586_a_(p_181565_6_, p_181565_7_, p_181565_8_, p_181565_9_).func_181675_d();
        p_181565_1_.func_227888_a_(pose, (float)(p_181565_2_ + p_181565_4_), (float)(p_181565_3_ + p_181565_5_), 0.0f).func_225586_a_(p_181565_6_, p_181565_7_, p_181565_8_, p_181565_9_).func_181675_d();
        p_181565_1_.func_227888_a_(pose, (float)(p_181565_2_ + p_181565_4_), (float)(p_181565_3_ + 0), 0.0f).func_225586_a_(p_181565_6_, p_181565_7_, p_181565_8_, p_181565_9_).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    private void renderItemModelIntoGUI(ItemStack stack, MatrixStack matrixStack, IBakedModel bakedmodel) {
        matrixStack.func_227860_a_();
        this.mc.func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        this.mc.func_110434_K().func_229267_b_(AtlasTexture.field_110575_b).setBlurMipmap(false, false);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableAlphaTest();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227861_a_(8.0, 8.0, 0.0);
        matrixStack.func_227862_a_(1.0f, -1.0f, 1.0f);
        matrixStack.func_227862_a_(16.0f, 16.0f, 16.0f);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = this.mc.func_228019_au_().func_228487_b_();
        if (!bakedmodel.func_230044_c_()) {
            RenderSystem.setupGuiFlatDiffuseLighting((Vector3f)DEF_LIGHT, (Vector3f)DIF_LIGHT);
        } else {
            RenderSystem.setupGui3DDiffuseLighting((Vector3f)DEF_LIGHT, (Vector3f)DIF_LIGHT);
        }
        this.mc.func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrixStack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, bakedmodel);
        irendertypebuffer$impl.func_228461_a_();
        RenderSystem.enableDepthTest();
        RenderHelper.func_227784_d_();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableRescaleNormal();
        matrixStack.func_227865_b_();
    }

    @Override
    public void onUpdate() {
        if (this.onHover == null && this.itemStack != null && !this.itemStack.func_190926_b()) {
            PaneBuilders.tooltipBuilder().hoverPane(this).build().setTextOld(this.window.getScreen().func_231151_a_(this.itemStack));
        }
    }
}

