/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.items.ItemScanTool;
import com.ldtteam.structurize.network.messages.IMessage;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScanOnServerMessage
implements IMessage {
    private final BlockPos from;
    private final BlockPos to;
    private final Optional<BlockPos> anchorPos;
    private final String name;
    private final boolean saveEntities;

    public ScanOnServerMessage(PacketBuffer buf) {
        this.name = buf.func_150789_c(Short.MAX_VALUE);
        this.from = buf.func_179259_c();
        this.to = buf.func_179259_c();
        this.saveEntities = buf.readBoolean();
        this.anchorPos = buf.readBoolean() ? Optional.of(buf.func_179259_c()) : Optional.empty();
    }

    public ScanOnServerMessage(@NotNull BlockPos from, @NotNull BlockPos to, @NotNull String name, boolean saveEntities, Optional<BlockPos> anchorPos) {
        this.from = from;
        this.to = to;
        this.name = name;
        this.saveEntities = saveEntities;
        this.anchorPos = anchorPos;
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.func_180714_a(this.name);
        buf.func_179255_a(this.from);
        buf.func_179255_a(this.to);
        buf.writeBoolean(this.saveEntities);
        buf.writeBoolean(this.anchorPos.isPresent());
        this.anchorPos.ifPresent(arg_0 -> ((PacketBuffer)buf).func_179255_a(arg_0));
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ItemScanTool.saveStructure(ctxIn.getSender().func_130014_f_(), this.from, this.to, (PlayerEntity)ctxIn.getSender(), this.name, this.saveEntities, this.anchorPos);
    }
}

