/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.gui.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Supplier;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.item.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class WaystoneInventoryButton
extends Button {
    private static final ResourceLocation INVENTORY_BUTTON_TEXTURE = new ResourceLocation("waystones", "textures/gui/inventory_button.png");
    private final ContainerScreen<?> parentScreen;
    private final ItemStack iconItem;
    private final ItemStack iconItemHovered;
    private final Supplier<Boolean> visiblePredicate;
    private final Supplier<Integer> xPosition;
    private final Supplier<Integer> yPosition;

    public WaystoneInventoryButton(ContainerScreen<?> parentScreen, Button.IPressable pressable, Supplier<Boolean> visiblePredicate, Supplier<Integer> xPosition, Supplier<Integer> yPosition) {
        super(0, 0, 16, 16, (ITextComponent)new StringTextComponent(""), pressable);
        this.parentScreen = parentScreen;
        this.visiblePredicate = visiblePredicate;
        this.xPosition = xPosition;
        this.yPosition = yPosition;
        this.iconItem = new ItemStack((IItemProvider)ModItems.boundScroll);
        this.iconItemHovered = new ItemStack((IItemProvider)ModItems.warpScroll);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.field_230694_p_ = this.visiblePredicate.get();
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void func_230431_b_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            this.field_230690_l_ = this.parentScreen.getGuiLeft() + this.xPosition.get();
            this.field_230691_m_ = this.parentScreen.getGuiTop() + this.yPosition.get();
            this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (PlayerWaystoneManager.canUseInventoryButton((PlayerEntity)Objects.requireNonNull(player))) {
                ItemStack icon = this.field_230692_n_ ? this.iconItemHovered : this.iconItem;
                ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
                itemRenderer.func_180450_b(icon, this.field_230690_l_, this.field_230691_m_);
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(INVENTORY_BUTTON_TEXTURE);
                RenderSystem.enableBlend();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                WaystoneInventoryButton.func_238463_a_((MatrixStack)matrixStack, (int)this.field_230690_l_, (int)this.field_230691_m_, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
            }
        }
    }
}

