/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.gui;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.recycler.gui.SlotRecycler;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.recipe.RecyclingRecipe;
import ovh.corail.recycler.registry.ModMenuTypes;

public class RecyclingBookMenu
extends Container {
    public static final ITextComponent NAME = new TranslationTextComponent("corail_recycler.message.recycling_book");
    private final IIntArray recyclingBookData = new IntArray(6);
    private final ItemStackHandler BOOK_INVENTORY = new ItemStackHandler(40);
    private String searchText = "";

    public RecyclingBookMenu(int windowId, PlayerInventory playerInventory) {
        super(ModMenuTypes.RECYCLING_BOOK, windowId);
        this.initSlots();
        if (!playerInventory.field_70458_d.field_70170_p.func_201670_d()) {
            this.initPage(0);
        }
        this.func_216961_a(this.recyclingBookData);
    }

    public RecyclingBookMenu(int windowId, PlayerInventory playerInventory, PacketBuffer data) {
        this(windowId, playerInventory);
    }

    public void initPage(int pageNum) {
        List<RecyclingRecipe> recipes = RecyclingManager.INSTANCE.getRecipesForSearch(this.searchText);
        this.setPageMax(Math.max(MathHelper.func_76123_f((float)((float)recipes.size() / 4.0f)) - 1, 0));
        this.setPageNum(MathHelper.func_76125_a((int)pageNum, (int)0, (int)this.getPageMax()));
        int skipped = this.getPageNum() * 4;
        int slotId = 0;
        int recipeIdMax = Math.min(skipped + 4, recipes.size());
        for (int recipeId = skipped; recipeId < recipeIdMax; ++recipeId) {
            RecyclingRecipe recipe = recipes.get(recipeId);
            this.recyclingBookData.func_221477_a(recipeId - skipped, recipe.isUserDefined() ? 1 : 0);
            this.BOOK_INVENTORY.setStackInSlot(slotId++, recipe.getIngredient().asItemStack());
            for (int i = 0; i < 9; ++i) {
                this.BOOK_INVENTORY.setStackInSlot(slotId++, i < recipe.getCount() ? recipe.getResult(i).asItemStack() : ItemStack.field_190927_a);
            }
        }
        while (slotId < 40) {
            this.BOOK_INVENTORY.setStackInSlot(slotId++, ItemStack.field_190927_a);
        }
    }

    public void updateSearchText(String searchText) {
        this.searchText = searchText;
        this.initPage(0);
    }

    public int getPageNum() {
        return this.recyclingBookData.func_221476_a(4);
    }

    public void setPageNum(int num) {
        this.recyclingBookData.func_221477_a(4, num);
    }

    public int getPageMax() {
        return this.recyclingBookData.func_221476_a(5);
    }

    public void setPageMax(int num) {
        this.recyclingBookData.func_221477_a(5, num);
    }

    public boolean isUserDefinedRecipe(int recipeSquareNum) {
        return this.recyclingBookData.func_221476_a(recipeSquareNum) != 0;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    private void initSlots() {
        int slotId = 0;
        for (int j = 0; j < 2; ++j) {
            int startX = 30;
            int startY = 20 + j * 16 * 3 + 8 * j;
            if (j == 1) {
                startY += 10;
            }
            for (int i = 0; i < 2; ++i) {
                this.func_75146_a((Slot)new SlotRecycler((IItemHandler)this.BOOK_INVENTORY, slotId++, startX, startY + 16, p -> false, false));
                startX += 21;
                for (int caseY = 0; caseY < 3; ++caseY) {
                    for (int caseX = 0; caseX < 3; ++caseX) {
                        this.func_75146_a((Slot)new SlotRecycler((IItemHandler)this.BOOK_INVENTORY, slotId++, startX + caseX * 16, startY + caseY * 16, p -> false, false));
                    }
                }
                startX = 150;
            }
        }
    }
}

