/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.network;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import ovh.corail.recycler.block.BlockRecycler;
import ovh.corail.recycler.config.ConfigRecycler;
import ovh.corail.recycler.helper.Helper;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.registry.ModTriggers;
import ovh.corail.recycler.tileentity.BlockEntityRecycler;

public class ServerRecyclerMessage {
    private final RecyclerAction action;
    private final BlockPos pos;

    public ServerRecyclerMessage(RecyclerAction action, BlockPos pos) {
        this.action = action;
        this.pos = pos;
    }

    static ServerRecyclerMessage fromBytes(PacketBuffer buf) {
        return new ServerRecyclerMessage(RecyclerAction.values()[buf.readShort()], buf.func_179259_c());
    }

    static void toBytes(ServerRecyclerMessage msg, PacketBuffer buf) {
        buf.writeShort(msg.action.ordinal());
        buf.func_179255_a(msg.pos);
    }

    static class Handler {
        Handler() {
        }

        static void handle(ServerRecyclerMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(() -> {
                    BlockEntityRecycler recycler;
                    ServerPlayerEntity player = ctx.getSender();
                    if (player != null && (recycler = BlockRecycler.getTileEntity(player.field_70170_p, message.pos)) != null) {
                        switch (message.action) {
                            case RECYCLE: {
                                if (!recycler.recycle()) break;
                                ModTriggers.FIRST_RECYCLE.trigger(player);
                                recycler.updateRecipe();
                                break;
                            }
                            case SWITCH_AUTO: {
                                recycler.switchWorking();
                                break;
                            }
                            case TAKE_ALL: {
                                player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(p -> {
                                    ItemStackHandler inventOutput = recycler.getInventoryOutput();
                                    IntStream.range(0, inventOutput.getSlots()).filter(slot -> !inventOutput.getStackInSlot(slot).func_190926_b()).forEach(slot -> inventOutput.setStackInSlot(slot, ItemHandlerHelper.insertItemStacked((IItemHandler)p, (ItemStack)inventOutput.getStackInSlot(slot), (boolean)false)));
                                });
                                break;
                            }
                            case DISCOVER_RECIPE: {
                                ItemStack stack = recycler.getInventoryWorking().getStackInSlot(0);
                                if (stack.func_190926_b() || !((Boolean)ConfigRecycler.shared_general.permanentDiscoverButton.get()).booleanValue() && !player.func_211513_k(2) || !RecyclingManager.INSTANCE.discoverRecipe(player.func_71121_q(), stack)) break;
                                recycler.updateRecipe();
                                break;
                            }
                            case REMOVE_RECIPE: {
                                ItemStack stack = recycler.getInventoryWorking().getStackInSlot(0);
                                if (stack.func_190926_b() || !((Boolean)ConfigRecycler.shared_general.permanentDiscoverButton.get()).booleanValue() && !player.func_211513_k(2) || !RecyclingManager.INSTANCE.removeRecipe(stack)) break;
                                recycler.resetRecipe();
                            }
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }

    public static enum RecyclerAction {
        RECYCLE,
        SWITCH_AUTO,
        TAKE_ALL,
        DISCOVER_RECIPE,
        REMOVE_RECIPE;

    }
}

