/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.recycler.recipe;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import ovh.corail.recycler.helper.Helper;
import ovh.corail.recycler.recipe.JsonRecyclingRecipe;
import ovh.corail.recycler.recipe.RecyclingManager;
import ovh.corail.recycler.recipe.SimpleStack;

public class RecyclingRecipe
implements Comparable<RecyclingRecipe> {
    protected final SimpleStack ingredient;
    protected final NonNullList<SimpleStack> results = NonNullList.func_191196_a();
    protected Boolean isValid = null;
    protected Boolean isDenied = null;
    protected boolean isUserDefined = false;

    public RecyclingRecipe(SimpleStack stackIn, NonNullList<SimpleStack> stacksOut) {
        this.ingredient = stackIn;
        this.results.addAll(stacksOut);
    }

    public RecyclingRecipe(ItemStack stackIn, NonNullList<SimpleStack> stacksOut) {
        this.ingredient = new SimpleStack(stackIn);
        this.results.addAll(stacksOut);
    }

    public RecyclingRecipe(SimpleStack stackIn, SimpleStack[] stacksOut) {
        this.ingredient = stackIn;
        Collections.addAll(this.results, stacksOut);
    }

    public RecyclingRecipe(JsonRecyclingRecipe jsonRecipe) {
        this(SimpleStack.fromJson(jsonRecipe.inputItem), (SimpleStack[])Arrays.stream(jsonRecipe.outputItems).map(SimpleStack::fromJson).filter(outputItem -> !outputItem.isEmpty()).toArray(SimpleStack[]::new));
    }

    public RecyclingRecipe(IRecipe<?> recipe) {
        this(recipe.func_77571_b(), Helper.mergetoSimpleStack(recipe.func_192400_c().stream().filter(ing -> ing.func_193365_a().length > 0).map(ing -> ing.func_193365_a()[0]).collect(Collectors.toList())));
    }

    public SimpleStack getIngredient() {
        return this.ingredient;
    }

    public boolean isIngredient(SimpleStack stack) {
        return this.ingredient.is(stack);
    }

    public boolean isIngredient(ItemStack stack) {
        return this.ingredient.is(stack);
    }

    public boolean isIngredient(Item item) {
        return this.ingredient.is(item);
    }

    public boolean isValid() {
        if (this.isValid == null) {
            this.isValid = !this.results.isEmpty() && this.results.stream().allMatch(i -> !i.isEmpty() && i.getCount() > 0) && !this.ingredient.isEmpty() && this.ingredient.getCount() > 0;
        }
        return this.isValid;
    }

    public boolean isDenied() {
        if (this.isDenied == null) {
            this.isDenied = RecyclingManager.INSTANCE.isDeniedRecipe(this);
        }
        return this.isDenied;
    }

    public RecyclingRecipe setUserDefined(boolean state) {
        this.isUserDefined = state;
        return this;
    }

    public boolean isUserDefined() {
        return this.isUserDefined;
    }

    public int getCount() {
        return this.results.size();
    }

    public SimpleStack getResult(int index) {
        return (SimpleStack)this.results.get(index);
    }

    public NonNullList<SimpleStack> getResults() {
        return this.results;
    }

    @Override
    public int compareTo(RecyclingRecipe otherRecipe) {
        return this.getIngredient().compareTo(otherRecipe.getIngredient());
    }

    public boolean equals(Object o) {
        return this == o || o instanceof RecyclingRecipe && ((RecyclingRecipe)o).isIngredient(this.getIngredient());
    }

    public int hashCode() {
        return this.getIngredient().hashCode();
    }
}

