/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import java.util.Locale;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;
import net.silentchaos512.gems.block.OreBlockSG;
import net.silentchaos512.gems.chaos.Chaos;
import net.silentchaos512.gems.init.GemsBlocks;
import net.silentchaos512.gems.init.Registration;
import net.silentchaos512.gems.item.CraftingItems;
import net.silentchaos512.lib.block.IBlockProvider;
import net.silentchaos512.lib.registry.BlockRegistryObject;

public enum MiscOres implements IBlockProvider
{
    CHAOS(() -> new MiscOreBlock(CraftingItems.CHAOS_CRYSTAL, 3, AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200944_c().func_200948_a(4.0f, 20.0f)){

        @Override
        public int getExpRandom() {
            return MathHelper.func_76136_a((Random)this.RANDOM, (int)2, (int)7);
        }
    }),
    ENDER(() -> new MiscOreBlock(CraftingItems.ENDER_CRYSTAL, ModList.get().isLoaded("silentgear") ? 4 : 3, AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200944_c().func_200948_a(4.0f, 20.0f)){

        @Override
        public int getExpRandom() {
            return MathHelper.func_76136_a((Random)this.RANDOM, (int)4, (int)8);
        }
    }),
    SILVER(() -> new OreBlockSG(null, 2, AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(3.0f, 12.0f)){

        @Override
        public int getExpRandom() {
            return 0;
        }
    });

    private final Supplier<OreBlockSG> blockSupplier;
    private BlockRegistryObject<OreBlockSG> block;

    private MiscOres(Supplier<OreBlockSG> blockSupplier) {
        this.blockSupplier = blockSupplier;
    }

    public static void registerBlocks() {
        for (MiscOres ore : MiscOres.values()) {
            ore.block = new BlockRegistryObject(Registration.BLOCKS.register(ore.getName(), ore.blockSupplier));
            Registration.ITEMS.register(ore.getName(), GemsBlocks.defaultItem(ore.block));
        }
    }

    public OreBlockSG getBlock() {
        return (OreBlockSG)this.block.get();
    }

    public Block asBlock() {
        return this.getBlock();
    }

    public Item func_199767_j() {
        return this.asBlock().func_199767_j();
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT) + "_ore";
    }

    public static abstract class MiscOreBlock
    extends OreBlockSG {
        private static final int CHAOS_ORE_CHAOS_GENERATED = 500;
        static final BooleanProperty LIT = BlockStateProperties.field_208190_q;

        MiscOreBlock(IItemProvider droppedItem, int harvestLevel, AbstractBlock.Properties builder) {
            super(droppedItem, harvestLevel, builder.harvestTool(ToolType.PICKAXE));
            this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
        }

        public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
            return (Boolean)state.func_177229_b((Property)LIT) != false ? 9 : 0;
        }

        public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
            MiscOreBlock.activate(state, worldIn, pos);
            super.func_196270_a(state, worldIn, pos, player);
        }

        public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
            MiscOreBlock.activate(worldIn.func_180495_p(pos), worldIn, pos);
            super.func_176199_a(worldIn, pos, entityIn);
        }

        public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
            MiscOreBlock.activate(state, worldIn, pos);
            return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
        }

        private static void activate(BlockState state, World world, BlockPos pos) {
            MiscOreBlock.spawnParticles(world, pos);
            if (!((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true)));
                if (state.func_177230_c() == CHAOS.asBlock()) {
                    Chaos.generate((ICapabilityProvider)world, 500, pos);
                }
            }
        }

        public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
            if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            }
        }

        public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
            if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
                MiscOreBlock.spawnParticles(worldIn, pos);
            }
        }

        private static void spawnParticles(World world, BlockPos pos) {
            Random random = world.field_73012_v;
            for (Direction direction : Direction.values()) {
                BlockPos blockpos = pos.func_177972_a(direction);
                if (world.func_180495_p(blockpos).func_200015_d((IBlockReader)world, blockpos)) continue;
                Direction.Axis axis = direction.func_176740_k();
                double d1 = axis == Direction.Axis.X ? 0.5 + 0.5625 * (double)direction.func_82601_c() : (double)random.nextFloat();
                double d2 = axis == Direction.Axis.Y ? 0.5 + 0.5625 * (double)direction.func_96559_d() : (double)random.nextFloat();
                double d3 = axis == Direction.Axis.Z ? 0.5 + 0.5625 * (double)direction.func_82599_e() : (double)random.nextFloat();
                world.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)pos.func_177958_n() + d1, (double)pos.func_177956_o() + d2, (double)pos.func_177952_p() + d3, 0.0, 0.0, 0.0);
            }
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            builder.func_206894_a(new Property[]{LIT});
        }
    }
}

