/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.OreBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.silentchaos512.gems.util.TextUtil;

public abstract class OreBlockSG
extends OreBlock {
    @Nullable
    private final IItemProvider droppedItem;
    private final int harvestLevel;

    public OreBlockSG(@Nullable IItemProvider droppedItem, int harvestLevel, AbstractBlock.Properties builder) {
        super(builder);
        this.droppedItem = droppedItem;
        this.harvestLevel = harvestLevel;
    }

    public IItemProvider getDroppedItem() {
        return this.droppedItem != null ? this.droppedItem : this;
    }

    public abstract int getExpRandom();

    public int getExpDrop(BlockState state, IWorldReader reader, BlockPos pos, int fortune, int silkTouch) {
        return silkTouch == 0 ? this.getExpRandom() : 0;
    }

    public int getHarvestLevel(BlockState state) {
        return this.harvestLevel;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ITextComponent itemName = this.getDroppedItem().func_199767_j().func_200296_o();
        tooltip.add((ITextComponent)new TranslationTextComponent("misc.silentgems.dropFromOre", new Object[]{itemName}).func_240699_a_(TextFormatting.GRAY));
        ITextComponent harvestLevelName = TextUtil.translate("misc", "harvestLevel." + this.harvestLevel, new Object[0]);
        tooltip.add(TextUtil.translate("misc", "harvestLevel", this.harvestLevel, harvestLevelName));
    }
}

