/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.chaos;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.api.chaos.ChaosEvent;
import net.silentchaos512.gems.block.CorruptedBlocks;
import net.silentchaos512.gems.chaos.ChaosSourceCapability;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.entity.ChaosLightningBoltEntity;
import net.silentchaos512.gems.init.GemsEffects;
import net.silentchaos512.gems.world.spawner.CorruptedSlimeSpawner;
import net.silentchaos512.gems.world.spawner.WispSpawner;
import net.silentchaos512.lib.util.TimeUtils;
import net.silentchaos512.utils.MathUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod.EventBusSubscriber(modid="silentgems")
public final class ChaosEvents {
    private static final Map<ResourceLocation, ChaosEvent> EVENTS = new HashMap<ResourceLocation, ChaosEvent>();
    private static final Map<ResourceLocation, ForgeConfigSpec.BooleanValue> EVENT_CONFIGS = new HashMap<ResourceLocation, ForgeConfigSpec.BooleanValue>();
    private static final Map<UUID, Map<ResourceLocation, Integer>> COOLDOWN_TIMERS = new HashMap<UUID, Map<ResourceLocation, Integer>>();
    private static final Queue<Supplier<LightningBoltEntity>> LIGHTNING_QUEUE = new ArrayDeque<Supplier<LightningBoltEntity>>();
    private static final int LIGHTNING_TICK_FREQUENCY = 10;
    private static int tickTimer = 0;
    private static final Marker MARKER = MarkerManager.getMarker((String)"ChaosEvents");
    private static final int MAX_CHAOS = 5000000;

    private ChaosEvents() {
        throw new IllegalAccessError("Utility class");
    }

    public static void addChaosEvent(ResourceLocation id, ChaosEvent event) {
        if (EVENTS.containsKey(id)) {
            throw new IllegalStateException("Duplicate chaos event ID: " + id);
        }
        EVENTS.put(id, event);
    }

    static void tryChaosEvents(PlayerEntity player, World world, int chaos) {
        if (player == null || !player.func_70089_S() || ((Boolean)GemsConfig.Common.chaosNoEventsUntilHasBed.get()).booleanValue() && !ChaosEvents.hasBed(player)) {
            return;
        }
        Map cooldownTimers = COOLDOWN_TIMERS.computeIfAbsent(player.func_110124_au(), uuid -> new HashMap());
        EVENTS.forEach((id, event) -> {
            int cooldown = ChaosEvents.getAndDecrementTimer(id, cooldownTimers);
            if (cooldown <= 0 && ChaosEvents.checkConfig(id) && event.tryActivate(player, chaos)) {
                SilentGems.LOGGER.info(MARKER, "Activate {} @ {}", id, (Object)player.func_195047_I_());
                cooldownTimers.put(id, event.getCooldownTime());
            }
        });
    }

    private static int getAndDecrementTimer(ResourceLocation id, Map<ResourceLocation, Integer> timers) {
        if (!timers.containsKey(id)) {
            return 0;
        }
        int time = timers.get(id) - 1;
        if (time <= 0) {
            timers.remove(id);
        } else {
            timers.put(id, time);
        }
        return time;
    }

    private static boolean hasBed(PlayerEntity player) {
        return player.func_213374_dv().isPresent();
    }

    public static Collection<ResourceLocation> getEventIds() {
        return EVENTS.keySet();
    }

    public static void triggerEvent(ResourceLocation eventId, PlayerEntity player) {
        SilentGems.LOGGER.debug("Triggering event {}", (Object)eventId);
        player.getCapability(ChaosSourceCapability.INSTANCE).ifPresent(source -> {
            ChaosEvent event = EVENTS.get(eventId);
            if (event != null) {
                event.activate(player, source.getChaos());
            }
        });
    }

    public static boolean checkConfig(ResourceLocation eventId) {
        if (EVENT_CONFIGS.containsKey(eventId)) {
            return (Boolean)EVENT_CONFIGS.get(eventId).get();
        }
        return true;
    }

    public static void loadConfigs(ForgeConfigSpec.Builder builder) {
        builder.comment(new String[]{"chaos.events", "Allows individual events to be disabled.", "Note that disabling events will likely increase the frequency of other events."});
        EVENTS.forEach((id, event) -> EVENT_CONFIGS.put((ResourceLocation)id, builder.comment(event.getConfigComment()).define("chaos.events." + id, true)));
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!LIGHTNING_QUEUE.isEmpty() && ++tickTimer % 10 == 0) {
            LightningBoltEntity bolt = LIGHTNING_QUEUE.remove().get();
            bolt.field_70170_p.func_217376_c((Entity)bolt);
        }
    }

    private static boolean spawnLightningBolt(Entity entity, World world) {
        if (world instanceof ServerWorld && ChaosEvents.canSpawnLightningIn((RegistryKey<World>)world.func_234923_W_())) {
            double posX = entity.func_226277_ct_() + (double)MathUtils.nextIntInclusive((int)-64, (int)64);
            double posZ = entity.func_226281_cx_() + (double)MathUtils.nextIntInclusive((int)-64, (int)64);
            int height = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, (int)posX, (int)posZ);
            LightningBoltEntity bolt = new LightningBoltEntity(EntityType.field_200728_aG, world);
            bolt.func_233576_c_(new Vector3d(posX, (double)height, posZ));
            world.func_217376_c((Entity)bolt);
            return true;
        }
        return false;
    }

    private static boolean spawnChaosLightningBolts(Entity entity, World world, int count) {
        if (world instanceof ServerWorld && ChaosEvents.canSpawnLightningIn((RegistryKey<World>)world.func_234923_W_())) {
            for (int i = 0; i < count; ++i) {
                double posX = entity.func_226277_ct_() + (double)MathUtils.nextIntInclusive((int)-64, (int)64);
                double posZ = entity.func_226281_cx_() + (double)MathUtils.nextIntInclusive((int)-64, (int)64);
                int height = world.func_201676_a(Heightmap.Type.MOTION_BLOCKING, (int)posX, (int)posZ);
                LIGHTNING_QUEUE.add(() -> new ChaosLightningBoltEntity(world, posX, height, posZ));
            }
            return true;
        }
        return false;
    }

    private static boolean canSpawnLightningIn(RegistryKey<World> dimension) {
        return dimension != World.field_234919_h_ && dimension != World.field_234920_i_;
    }

    private static boolean corruptBlocks(Entity entity, World world) {
        int posX = (int)entity.func_226277_ct_() + MathUtils.nextIntInclusive((int)-128, (int)128);
        int posZ = (int)entity.func_226281_cx_() + MathUtils.nextIntInclusive((int)-128, (int)128);
        int posY = 64 + MathUtils.nextIntInclusive((int)-32, (int)64);
        BlockPos pos = new BlockPos(posX, posY, posZ);
        boolean done = false;
        while (pos.func_177956_o() > 1 && !done) {
            BlockState state = world.func_180495_p(pos);
            for (CorruptedBlocks corruptedBlocks : CorruptedBlocks.values()) {
                if (!corruptedBlocks.canReplace(state.func_177230_c())) continue;
                ChaosEvents.makeCorruptedBlockCluster(world, pos, corruptedBlocks);
                done = true;
            }
            pos = pos.func_177977_b();
        }
        return done;
    }

    private static void makeCorruptedBlockCluster(World world, BlockPos pos, CorruptedBlocks corruptedBlock) {
        SilentGems.LOGGER.debug(MARKER, "corrupted cluster @ {}", (Object)pos);
        BlockState newState = corruptedBlock.asBlockState();
        world.func_180501_a(pos, newState, 3);
        for (int i = 0; i < 40; ++i) {
            BlockPos pos1 = new BlockPos(pos.func_177958_n() + (int)(1.5 * SilentGems.random.nextGaussian()), pos.func_177956_o() + (int)(1.5 * SilentGems.random.nextGaussian()), pos.func_177952_p() + (int)(1.5 * SilentGems.random.nextGaussian()));
            BlockState target = world.func_180495_p(pos1);
            if (!corruptedBlock.canReplace(target.func_177230_c())) continue;
            world.func_180501_a(pos1, newState, 3);
        }
    }

    private static boolean setThunderstorm(World world, int time) {
        if (!world.func_82736_K().func_223586_b(GameRules.field_223617_t) || world.func_72912_H().func_76061_m() || !(world instanceof ServerWorld)) {
            return false;
        }
        IServerWorldInfo info = ((ServerWorld)world).func_73046_m().func_240793_aU_().func_230407_G_();
        info.func_76080_g(time);
        info.func_76090_f(time);
        info.func_76084_b(true);
        info.func_76069_a(true);
        return true;
    }

    private static boolean applyChaosSickness(PlayerEntity player, Integer chaos) {
        player.func_195064_c(new EffectInstance((Effect)GemsEffects.CHAOS_SICKNESS.get(), TimeUtils.ticksFromMinutes((float)10.0f)));
        player.func_195064_c(new EffectInstance(Effects.field_76419_f, TimeUtils.ticksFromMinutes((float)5.0f)));
        if (chaos > 2000000) {
            player.func_195064_c(new EffectInstance(Effects.field_76438_s, TimeUtils.ticksFromMinutes((float)5.0f)));
        }
        if (chaos > 4000000) {
            player.func_195064_c(new EffectInstance(Effects.field_76437_t, TimeUtils.ticksFromMinutes((float)5.0f)));
        }
        return true;
    }

    public static List<String> getCooldownTimersDebugText(PlayerEntity player) {
        if (player == null || !COOLDOWN_TIMERS.containsKey(player.func_110124_au())) {
            return ImmutableList.of();
        }
        return COOLDOWN_TIMERS.get(player.func_110124_au()).entrySet().stream().map(entry -> entry.getKey() + ": " + entry.getValue()).collect(Collectors.toList());
    }

    static {
        ChaosEvents.addChaosEvent(SilentGems.getId("lightning"), new ChaosEvent(0.1f, 120, 500000, 5000000, 50000, "Spawn a regular lightning bolt (can cause fire)", (player, chaos) -> ChaosEvents.spawnLightningBolt((Entity)player, player.field_70170_p)));
        ChaosEvents.addChaosEvent(SilentGems.getId("chaos_lightning"), new ChaosEvent(0.3f, 60, 300000, 5000000, 30000, "Spawn several lightning bolts that do not cause fire", (player, chaos) -> {
            int boltCount = 5 + SilentGems.random.nextInt(6);
            return ChaosEvents.spawnChaosLightningBolts((Entity)player, player.field_70170_p, boltCount);
        }));
        ChaosEvents.addChaosEvent(SilentGems.getId("corrupt_blocks"), new ChaosEvent(0.2f, 300, 750000, 5000000, 100000, "Create a patch of corrupted blocks", (player, chaos) -> ChaosEvents.corruptBlocks((Entity)player, player.field_70170_p)));
        ChaosEvents.addChaosEvent(SilentGems.getId("corrupted_slimes"), new ChaosEvent(0.1f, 1200, 180000, 1666666, 15000, "Spawn a group of corrupted slimes", CorruptedSlimeSpawner::spawnSlimes));
        ChaosEvents.addChaosEvent(SilentGems.getId("spawn_wisps"), new ChaosEvent(0.1f, 1800, 220000, 1250000, 25000, "Spawn a group of wisps (random element)", WispSpawner::spawnWisps));
        ChaosEvents.addChaosEvent(SilentGems.getId("thunderstorm"), new ChaosEvent(0.05f, 2400, 1000000, 5000000, 200000, "Changes the weather to a thunderstorm", (player, chaos) -> {
            int time = TimeUtils.ticksFromMinutes((float)MathUtils.nextIntInclusive((int)7, (int)15));
            return ChaosEvents.setThunderstorm(player.field_70170_p, time);
        }));
        ChaosEvents.addChaosEvent(SilentGems.getId("chaos_sickness"), new ChaosEvent(0.15f, 1200, 900000, 5000000, 200000, "Applies negative potion effects to the player", ChaosEvents::applyChaosSickness));
    }
}

