/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gems.item.SoulGemItem;
import net.silentchaos512.gems.lib.soul.GearSoul;
import net.silentchaos512.gems.lib.soul.Soul;
import net.silentchaos512.gems.util.SoulManager;

public final class SoulCommand {
    private static final SuggestionProvider<CommandSource> SOUL_ID_SUGGESTIONS = (context, builder) -> ISuggestionProvider.func_212476_a(Soul.getValues().stream().map(Soul::getId), (SuggestionsBuilder)builder);

    private SoulCommand() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"sg_soul").requires(source -> source.func_197034_c(2));
        builder.then(Commands.func_197057_a((String)"add_level").executes(SoulCommand::runAddLevel));
        builder.then(Commands.func_197057_a((String)"give_gem").then(Commands.func_197056_a((String)"players", (ArgumentType)EntityArgument.func_197094_d()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"soulID", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(SOUL_ID_SUGGESTIONS).executes(context -> SoulCommand.giveSoulGem((CommandContext<CommandSource>)context, EntityArgument.func_197090_e((CommandContext)context, (String)"players"), ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"soulID"), 1))).then(Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(context -> SoulCommand.giveSoulGem((CommandContext<CommandSource>)context, EntityArgument.func_197090_e((CommandContext)context, (String)"players"), ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"soulID"), IntegerArgumentType.getInteger((CommandContext)context, (String)"amount")))))));
        builder.then(Commands.func_197057_a((String)"list").executes(context -> {
            String line = Soul.getValues().stream().map(soul -> soul.getId().toString()).collect(Collectors.joining(", "));
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(line), true);
            return 1;
        }));
        dispatcher.register(builder);
    }

    private static int giveSoulGem(CommandContext<CommandSource> context, Collection<ServerPlayerEntity> players, ResourceLocation soulId, int count) {
        Soul soul = Soul.from(soulId);
        if (soul == null) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("command.silentgems.soul.invalid"));
            return 0;
        }
        for (ServerPlayerEntity player : players) {
            int amountLeft = count;
            while (amountLeft > 0) {
                ItemEntity itemEntity;
                int stackSize = Math.min(64, amountLeft);
                amountLeft -= stackSize;
                ItemStack stack = SoulGemItem.getStack(soul, stackSize);
                boolean itemAdded = player.field_71071_by.func_70441_a(stack);
                if (itemAdded && stack.func_190926_b()) {
                    stack.func_190920_e(1);
                    itemEntity = player.func_71019_a(stack, false);
                    if (itemEntity != null) {
                        itemEntity.func_174870_v();
                    }
                    player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((player.func_70681_au().nextFloat() - player.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    player.field_71069_bz.func_75142_b();
                    continue;
                }
                itemEntity = player.func_71019_a(stack, false);
                if (itemEntity == null) continue;
                itemEntity.func_174868_q();
                itemEntity.func_200217_b(player.func_110124_au());
            }
        }
        return count;
    }

    private static int runAddLevel(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ItemStack stack = player.func_184614_ca();
        GearSoul soul = SoulManager.getSoul(stack);
        if (soul != null) {
            int amount = soul.getXpToNextLevel() - soul.getXp();
            soul.addXp(amount, (PlayerEntity)player);
            GearData.recalculateStats((ItemStack)stack, (PlayerEntity)player);
        }
        return 1;
    }
}

