/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.entity;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.eventbus.api.Event;

public class EnderSlimeEntity
extends SlimeEntity {
    public EnderSlimeEntity(EntityType<? extends EnderSlimeEntity> typeIn, World worldIn) {
        super(typeIn, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233814_a_(Attributes.field_233823_f_).func_233815_a_(Attributes.field_233821_d_, 0.2);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        EntitySize size = super.func_213305_a(poseIn);
        return size.func_220312_a(1.1f * size.field_220316_b / size.field_220315_a, 1.1f);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return worldIn.func_175659_aa() != Difficulty.PEACEFUL;
    }

    public static boolean canSpawnAt(EntityType<EnderSlimeEntity> type, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_175659_aa() != Difficulty.PEACEFUL && pos.func_177956_o() < 65 && MonsterEntity.func_223323_a((IServerWorld)world, (BlockPos)pos, (Random)random);
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this) && !worldIn.func_72953_d(this.func_174813_aQ());
    }

    protected void func_70799_a(int size, boolean resetHealth) {
        super.func_70799_a(size, resetHealth);
        this.func_110148_a(Attributes.field_233826_i_).func_111128_a((double)(size * 3));
    }

    public float func_70013_c() {
        return 1.0f;
    }

    @Nonnull
    protected IParticleData func_195404_m() {
        return ParticleTypes.field_197616_i;
    }

    protected int func_70806_k() {
        return super.func_70806_k() * 4;
    }

    protected void func_70808_l() {
        this.field_70813_a *= 0.9f;
    }

    protected void func_70664_aZ() {
        Vector3d vec3d = this.func_213322_ci();
        this.func_213293_j(vec3d.field_72450_a, 0.42f + (float)this.func_70809_q() * 0.1f, vec3d.field_72449_c);
        this.field_70160_al = true;
        ForgeHooks.onLivingJump((LivingEntity)this);
    }

    protected void func_180466_bG(ITag<Fluid> tag) {
        if (tag == FluidTags.field_206960_b) {
            Vector3d vec3d = this.func_213322_ci();
            this.func_213293_j(vec3d.field_72450_a, 0.22f + (float)this.func_70809_q() * 0.05f, vec3d.field_72449_c);
            this.field_70160_al = true;
        } else {
            super.func_180466_bG(tag);
        }
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected boolean func_70800_m() {
        return this.func_70613_aW();
    }

    protected float func_225512_er_() {
        return super.func_225512_er_() + 2.0f;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.func_189101_db() ? SoundEvents.field_187892_fv : SoundEvents.field_187760_dh;
    }

    protected SoundEvent func_184615_bR() {
        return this.func_189101_db() ? SoundEvents.field_187890_fu : SoundEvents.field_187758_dg;
    }

    @Nonnull
    protected SoundEvent func_184709_cY() {
        return this.func_189101_db() ? SoundEvents.field_187894_fw : SoundEvents.field_187764_dj;
    }

    @Nonnull
    protected SoundEvent func_184710_cZ() {
        return SoundEvents.field_187762_di;
    }

    protected boolean teleportRandomly() {
        double d0 = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        double d1 = this.func_226278_cu_() + (double)(this.field_70146_Z.nextInt(64) - 32);
        double d2 = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() - 0.5) * 64.0;
        return this.teleportTo(d0, d1, d2);
    }

    private boolean teleportTo(double x, double y, double z) {
        BlockPos.Mutable blockPos = new BlockPos.Mutable(x, y, z);
        while (blockPos.func_177956_o() > 0 && !this.field_70170_p.func_180495_p((BlockPos)blockPos).func_185904_a().func_76230_c()) {
            blockPos.func_189536_c(Direction.DOWN);
        }
        if (!this.field_70170_p.func_180495_p((BlockPos)blockPos).func_185904_a().func_76230_c()) {
            return false;
        }
        EnderTeleportEvent event = new EnderTeleportEvent((LivingEntity)this, x, y, z, 0.0f);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return false;
        }
        boolean flag = this.func_213373_a(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
        if (flag) {
            this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
            this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        }
        return flag;
    }

    protected void func_70619_bc() {
        if (this.func_203008_ap()) {
            this.func_70097_a(DamageSource.field_76369_e, 1.0f);
        }
        super.func_70619_bc();
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source instanceof IndirectEntityDamageSource) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleportRandomly()) continue;
                return true;
            }
            return false;
        }
        boolean flag = super.func_70097_a(source, amount);
        if (source.func_76363_c() && this.field_70146_Z.nextInt(10) != 0) {
            this.teleportRandomly();
        }
        return flag;
    }
}

