/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.entity.projectile;

import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.entity.projectile.AbstractWispShotEntity;
import net.silentchaos512.gems.lib.WispTypes;
import net.silentchaos512.gems.util.ModDamageSource;
import net.silentchaos512.utils.MathUtils;

public class FireWispShotEntity
extends AbstractWispShotEntity {
    public FireWispShotEntity(World worldIn) {
        this(WispTypes.FIRE.getShotType(), worldIn);
    }

    public FireWispShotEntity(EntityType<? extends AbstractWispShotEntity> typeIn, World worldIn) {
        super(typeIn, worldIn);
    }

    public FireWispShotEntity(EntityType<? extends AbstractWispShotEntity> typeIn, double posXIn, double posYIn, double posZIn, double accelX, double accelY, double accelZ, World worldIn) {
        super(typeIn, posXIn, posYIn, posZIn, accelX, accelY, accelZ, worldIn);
    }

    public FireWispShotEntity(EntityType<? extends AbstractWispShotEntity> typeIn, LivingEntity shooterIn, double accelX, double accelY, double accelZ, World worldIn) {
        super(typeIn, shooterIn, accelX, accelY, accelZ, worldIn);
    }

    @Override
    public WispTypes getWispType() {
        return WispTypes.FIRE;
    }

    @Override
    protected void onEntityImpact(Entity entityIn) {
        if (entityIn instanceof LivingEntity && !((LivingEntity)entityIn).func_230270_dK_()) {
            int i = entityIn.func_223314_ad();
            entityIn.func_70015_d(5);
            Entity shooter = this.func_234616_v_();
            boolean flag = entityIn.func_70097_a(ModDamageSource.causeWispShotDamage(this, shooter), 4.0f);
            if (flag && shooter != null) {
                this.func_174815_a((LivingEntity)shooter, entityIn);
            } else {
                entityIn.func_70015_d(i);
            }
        }
    }

    @Override
    protected void onBlockImpact(BlockPos pos, Direction side) {
        BlockPos blockPos;
        if (((Boolean)GemsConfig.Common.wispsCauseFire.get()).booleanValue() && MathUtils.tryPercentage((double)0.25) && this.field_70170_p.func_175623_d(blockPos = pos.func_177972_a(side))) {
            this.field_70170_p.func_175656_a(blockPos, Blocks.field_150480_ab.func_176223_P());
        }
    }
}

