/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.event;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gems.enchantment.EnchantmentGravity;
import net.silentchaos512.gems.enchantment.EnchantmentIceAspect;
import net.silentchaos512.gems.enchantment.EnchantmentLifeSteal;
import net.silentchaos512.gems.enchantment.EnchantmentLightningAspect;
import net.silentchaos512.gems.init.GemsEnchantments;

@Mod.EventBusSubscriber(modid="silentgems")
public final class EnchantmentEvents {
    private EnchantmentEvents() {
    }

    @SubscribeEvent
    public static void onGetBreakSpeed(PlayerEvent.BreakSpeed event) {
        int gravityLevel;
        PlayerEntity player = event.getPlayer();
        ItemStack mainHand = player.func_184586_b(Hand.MAIN_HAND);
        if (!mainHand.func_190926_b() && (gravityLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)GemsEnchantments.GRAVITY.get()), (ItemStack)mainHand)) > 0) {
            ((EnchantmentGravity)GemsEnchantments.GRAVITY.get()).onGetBreakSpeed(event, mainHand, gravityLevel);
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            ItemStack mainHand = player.func_184614_ca();
            ItemStack offHand = player.func_184592_cb();
            int lifeStealLevel = 0;
            int iceAspectLevel = 0;
            int lightningAspectLevel = 0;
            if (!mainHand.func_190926_b()) {
                lifeStealLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)GemsEnchantments.LIFE_STEAL.get()), (ItemStack)mainHand);
                iceAspectLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)GemsEnchantments.ICE_ASPECT.get()), (ItemStack)mainHand);
                lightningAspectLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)GemsEnchantments.LIGHTNING_ASPECT.get()), (ItemStack)mainHand);
            }
            if (lifeStealLevel < 1 && !offHand.func_190926_b()) {
                lifeStealLevel = EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)GemsEnchantments.LIFE_STEAL.get()), (ItemStack)offHand);
            }
            if (lifeStealLevel > 0) {
                float amount = Math.min(event.getAmount(), event.getEntityLiving().func_110143_aJ());
                float healAmount = EnchantmentLifeSteal.getAmountHealed(lifeStealLevel, amount);
                player.func_70691_i(healAmount);
            }
            if (iceAspectLevel > 0) {
                EnchantmentIceAspect.applyTo(event.getEntityLiving(), iceAspectLevel);
            }
            if (lightningAspectLevel > 0) {
                EnchantmentLightningAspect.applyTo(event.getEntityLiving(), lightningAspectLevel);
            }
        }
    }
}

