/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class DrawingCompass
extends Item {
    public DrawingCompass() {
        super(new Item.Properties().func_200917_a(1));
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
    }

    private State getState(ItemStack stack) {
        if (DrawingCompass.getBlock2(stack).func_177956_o() > 0) {
            return State.BLOCK2;
        }
        if (DrawingCompass.getBlock1(stack).func_177956_o() > 0) {
            return State.BLOCK1;
        }
        return State.EMPTY;
    }

    @Deprecated
    public ItemStack setState(ItemStack stack, State state) {
        return stack;
    }

    private static BlockPos getBlock1(ItemStack stack) {
        return DrawingCompass.getBlock(stack, 1);
    }

    private static BlockPos getBlock2(ItemStack stack) {
        return DrawingCompass.getBlock(stack, 2);
    }

    private static BlockPos getBlock(ItemStack stack, int index) {
        CompoundNBT tags = stack.func_190925_c("Block" + index);
        return new BlockPos(tags.func_74762_e("X"), tags.func_74762_e("Y"), tags.func_74762_e("Z"));
    }

    private static void setBlock1(ItemStack stack, BlockPos pos) {
        DrawingCompass.setBlock(stack, pos, 1);
    }

    private static void setBlock2(ItemStack stack, BlockPos pos) {
        DrawingCompass.setBlock(stack, pos, 2);
    }

    private static void setBlock(ItemStack stack, BlockPos pos, int index) {
        CompoundNBT tags = stack.func_190925_c("Block" + index);
        tags.func_74768_a("X", pos.func_177958_n());
        tags.func_74768_a("Y", pos.func_177956_o());
        tags.func_74768_a("Z", pos.func_177952_p());
    }

    private static void clearBlocks(ItemStack stack) {
        DrawingCompass.setBlock1(stack, BlockPos.field_177992_a);
        DrawingCompass.setBlock2(stack, BlockPos.field_177992_a);
    }

    private static int getColor(ItemStack stack) {
        CompoundNBT tags = stack.func_196082_o();
        if (tags.func_74764_b("CompassColor")) {
            return tags.func_74762_e("CompassColor");
        }
        return 0xFFFFFF;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_195991_k().field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        ItemStack stack = context.func_195996_i();
        State state = this.getState(stack);
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        PlayerEntity player = context.func_195999_j();
        if (state == State.BLOCK1) {
            DrawingCompass.setBlock2(stack, pos.func_177972_a(facing));
            int radius = (int)Math.sqrt(DrawingCompass.getBlock1(stack).func_177951_i((Vector3i)DrawingCompass.getBlock2(stack)));
            if (player != null) {
                player.func_145747_a((ITextComponent)new StringTextComponent("radius = " + radius), Util.field_240973_b_);
            }
        } else if (state == State.EMPTY) {
            DrawingCompass.setBlock1(stack, pos.func_177972_a(facing));
        } else if (player != null) {
            player.func_145747_a((ITextComponent)new StringTextComponent("howToReset"), Util.field_240973_b_);
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (hand == Hand.MAIN_HAND && playerIn.func_213453_ef() && !worldIn.field_72995_K) {
            DrawingCompass.clearBlocks(stack);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public boolean spawnParticles(ItemStack stack, PlayerEntity player, World world) {
        Vector3d vec;
        float start;
        BlockPos pos1 = DrawingCompass.getBlock1(stack);
        BlockPos pos2 = DrawingCompass.getBlock2(stack);
        if (pos1.func_177956_o() <= 0 || pos2.func_177956_o() <= 0 || pos1.equals((Object)pos2)) {
            return false;
        }
        int color = DrawingCompass.getColor(stack);
        BlockPos center = new BlockPos(pos1.func_177958_n(), pos2.func_177956_o(), pos1.func_177952_p());
        float radius = (float)Math.sqrt(center.func_177951_i((Vector3i)pos2));
        int count = (int)(5.0f * radius);
        float increment = (float)(Math.PI * 2 / (double)count);
        float angle = start = increment * (float)(world.func_82737_E() % 30L) / 30.0f;
        while ((double)angle < Math.PI * 2 + (double)start) {
            vec = new Vector3d((double)radius, 0.0, 0.0).func_178785_b(angle);
            this.particle(player, world, color, (double)center.func_177958_n() + 0.5 + vec.field_72450_a, (double)center.func_177956_o() + 0.5 + vec.field_72448_b, (double)center.func_177952_p() + 0.5 + vec.field_72449_c);
            angle += increment;
        }
        double distance = Math.sqrt(pos1.func_177951_i((Vector3i)pos2));
        count = (int)(2.0 * distance);
        double dx = (double)(pos2.func_177958_n() - pos1.func_177958_n()) / (double)count;
        double dy = (double)(pos2.func_177956_o() - pos1.func_177956_o()) / (double)count;
        double dz = (double)(pos2.func_177952_p() - pos1.func_177952_p()) / (double)count;
        for (int i = 0; i < count; ++i) {
            vec = new Vector3d((double)pos1.func_177958_n() + 0.5 + (double)i * dx, (double)pos1.func_177956_o() + 0.5 + (double)i * dy, (double)pos1.func_177952_p() + 0.5 + (double)i * dz);
            this.particle(player, world, color, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
        }
        return true;
    }

    private void particle(PlayerEntity player, World world, int color, double x, double y, double z) {
    }

    public static enum State {
        EMPTY,
        BLOCK1,
        BLOCK2;

    }
}

