/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.item;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.client.key.KeyTracker;
import net.silentchaos512.gems.init.GemsItemGroups;
import net.silentchaos512.gems.init.GemsItems;
import net.silentchaos512.lib.event.ClientTicks;

public final class EnchantmentTokenItem
extends Item {
    public static final ResourceLocation MODEL_INDEX = SilentGems.getId("model_index");
    private static final String NBT_ENCHANTMENTS = "TokenEnchantments";
    private static final Map<Enchantment, Integer> OUTLINE_COLOR_MAP = new HashMap<Enchantment, Integer>();
    private static final Map<String, Icon> MODELS_BY_TYPE = new HashMap<String, Icon>();
    private static final float OUTLINE_PULSATE_SPEED = 0.10610329f;

    public EnchantmentTokenItem() {
        super(new Item.Properties().func_200916_a(GemsItemGroups.UTILITY));
    }

    public static ItemStack construct(EnchantmentData data) {
        ItemStack stack = new ItemStack(GemsItems.ENCHANTMENT_TOKEN);
        EnchantmentTokenItem.addEnchantment(stack, data);
        return stack;
    }

    public static void addEnchantment(ItemStack stack, Enchantment enchantment, int level) {
        EnchantmentTokenItem.addEnchantment(stack, new EnchantmentData(enchantment, level));
    }

    public static void addEnchantment(ItemStack stack, EnchantmentData data) {
        ListNBT tagList = EnchantmentTokenItem.getEnchantments(stack);
        boolean needToAddEnchantment = true;
        ResourceLocation id = ForgeRegistries.ENCHANTMENTS.getKey((IForgeRegistryEntry)data.field_76302_b);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tags = tagList.func_150305_b(i);
            ResourceLocation existingId = ResourceLocation.func_208304_a((String)tags.func_74779_i("id"));
            if (existingId == null || !existingId.equals((Object)id)) continue;
            if (tags.func_74762_e("lvl") < data.field_76303_c) {
                tags.func_74777_a("lvl", (short)data.field_76303_c);
            }
            needToAddEnchantment = false;
            break;
        }
        if (needToAddEnchantment) {
            CompoundNBT tags = new CompoundNBT();
            tags.func_74778_a("id", String.valueOf(id));
            tags.func_74777_a("lvl", (short)data.field_76303_c);
            tagList.add((Object)tags);
        }
        stack.func_196082_o().func_218657_a(NBT_ENCHANTMENTS, (INBT)tagList);
    }

    public static ListNBT getEnchantments(ItemStack stack) {
        CompoundNBT tags = stack.func_77978_p();
        return tags != null ? tags.func_150295_c(NBT_ENCHANTMENTS, 10) : new ListNBT();
    }

    private static Map<Enchantment, Integer> getEnchantmentMap(ItemStack stack) {
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        ListNBT tagList = EnchantmentTokenItem.getEnchantments(stack);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tag = tagList.func_150305_b(i);
            ResourceLocation id = ResourceLocation.func_208304_a((String)tag.func_74779_i("id"));
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(id);
            if (enchantment == null) continue;
            map.put(enchantment, tag.func_74762_e("lvl"));
        }
        return map;
    }

    public static boolean applyTokenToTool(ItemStack token, ItemStack tool) {
        if (token.func_190926_b() || tool.func_190926_b()) {
            return false;
        }
        Map<Enchantment, Integer> enchantmentsOnToken = EnchantmentTokenItem.getEnchantmentMap(token);
        if (enchantmentsOnToken.isEmpty()) {
            return false;
        }
        Map enchantmentsOnTool = EnchantmentHelper.func_82781_a((ItemStack)tool);
        for (Map.Entry<Enchantment, Integer> entry : enchantmentsOnToken.entrySet()) {
            Enchantment ench = entry.getKey();
            if (!ench.func_92089_a(tool)) {
                return false;
            }
            for (Enchantment enchTool : enchantmentsOnTool.keySet()) {
                if (ench.equals(enchTool) || ench.func_191560_c(enchTool)) continue;
                return false;
            }
        }
        if (!EnchantmentTokenItem.mergeEnchantmentLists(enchantmentsOnToken, enchantmentsOnTool)) {
            return false;
        }
        EnchantmentHelper.func_82782_a(enchantmentsOnToken, (ItemStack)tool);
        return true;
    }

    private static boolean mergeEnchantmentLists(Map<Enchantment, Integer> ench1, Map<Enchantment, Integer> ench2) {
        for (Enchantment enchantment : ench2.keySet()) {
            int newLevel;
            int level = newLevel = ench2.get(enchantment).intValue();
            if (ench1.containsKey(enchantment) && (newLevel = ench1.get(enchantment) + level) > enchantment.func_77325_b()) {
                return false;
            }
            ench1.put(enchantment, newLevel);
        }
        return true;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        Map<Enchantment, Integer> enchants = EnchantmentTokenItem.getEnchantmentMap(stack);
        if (enchants.size() == 1) {
            Enchantment ench = enchants.keySet().iterator().next();
            list.add(this.subText("maxLevel", ench.func_77325_b()));
            if (KeyTracker.isAltDown()) {
                ResourceLocation registryName = Objects.requireNonNull(ench.getRegistryName());
                list.add((ITextComponent)new StringTextComponent(registryName.toString()).func_240699_a_(TextFormatting.DARK_GRAY));
            }
        }
        for (Map.Entry<Enchantment, Integer> entry : enchants.entrySet()) {
            Enchantment enchantment = entry.getKey();
            ITextComponent enchName = enchantment.func_200305_d(entry.getValue().intValue());
            ResourceLocation registryName = Objects.requireNonNull(enchantment.getRegistryName());
            String modName = "Unknown";
            for (ModInfo info : ModList.get().getMods()) {
                if (!info.getModId().equals(registryName.func_110624_b())) continue;
                modName = info.getDisplayName();
                break;
            }
            list.add(this.subText("enchNameWithMod", enchName, modName));
            String descKey = enchantment.func_77320_a() + ".desc";
            if (!I18n.func_188566_a((String)descKey)) continue;
            list.add((ITextComponent)new TranslationTextComponent(descKey).func_240699_a_(TextFormatting.ITALIC));
        }
    }

    private ITextComponent subText(String key, Object ... formatArgs) {
        ResourceLocation id = Objects.requireNonNull(this.getRegistryName());
        String fullKey = String.format("item.%s.%s.%s", id.func_110624_b(), id.func_110623_a(), key);
        return new TranslationTextComponent(fullKey, formatArgs);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        NonNullList tokens = NonNullList.func_191196_a();
        for (Enchantment enchantment : ForgeRegistries.ENCHANTMENTS) {
            tokens.add(EnchantmentTokenItem.construct(new EnchantmentData(enchantment, 1)));
        }
        tokens.sort(EnchantmentTokenItem::compareEnchantmentNames);
        items.addAll((Collection)tokens);
    }

    private static int compareEnchantmentNames(ItemStack o1, ItemStack o2) {
        int k = -EnchantmentTokenItem.getModelIcon(o1).getName().compareTo(EnchantmentTokenItem.getModelIcon(o2).getName());
        if (k == 0) {
            Enchantment ench1 = EnchantmentTokenItem.getSingleEnchantment(o1);
            Enchantment ench2 = EnchantmentTokenItem.getSingleEnchantment(o2);
            if (ench1 != null && ench2 != null) {
                ITextComponent name1 = ench1.func_200305_d(1);
                ITextComponent name2 = ench2.func_200305_d(1);
                return name1.getString().compareTo(name2.getString());
            }
        }
        return k;
    }

    @Nullable
    public static Enchantment getSingleEnchantment(ItemStack token) {
        Map<Enchantment, Integer> map = EnchantmentTokenItem.getEnchantmentMap(token);
        if (map.size() != 1) {
            return null;
        }
        return map.keySet().iterator().next();
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public static int getItemColor(ItemStack stack, int tintIndex) {
        if (tintIndex != 1) {
            return 0xFFFFFF;
        }
        Enchantment ench = EnchantmentTokenItem.getSingleEnchantment(stack);
        if (ench != null && OUTLINE_COLOR_MAP.containsKey(ench)) {
            int k = OUTLINE_COLOR_MAP.get(ench);
            int r = k >> 16 & 0xFF;
            int g = k >> 8 & 0xFF;
            int b = k & 0xFF;
            int j = (int)(160.0f * MathHelper.func_76126_a((float)((float)ClientTicks.ticksInGame() * 0.10610329f)));
            j = MathHelper.func_76125_a((int)j, (int)0, (int)255);
            r = MathHelper.func_76125_a((int)(r + j), (int)0, (int)255);
            g = MathHelper.func_76125_a((int)(g + j), (int)0, (int)255);
            b = MathHelper.func_76125_a((int)(b + j), (int)0, (int)255);
            return r << 16 | g << 8 | b;
        }
        return 8405196;
    }

    public static void setOutlineColor(Enchantment enchantment, int color) {
        OUTLINE_COLOR_MAP.put(enchantment, color);
    }

    public static float getModel(ItemStack stack, World world, LivingEntity entity) {
        return EnchantmentTokenItem.getModelIcon(stack).ordinal();
    }

    private static Icon getModelIcon(ItemStack stack) {
        Map<Enchantment, Integer> map = EnchantmentTokenItem.getEnchantmentMap(stack);
        if (map.isEmpty()) {
            return Icon.EMPTY;
        }
        EnchantmentType type = map.keySet().iterator().next().field_77351_y;
        if (type == null) {
            return Icon.UNKNOWN;
        }
        return MODELS_BY_TYPE.getOrDefault(type.toString(), Icon.UNKNOWN);
    }

    private String getEnchantmentDebugInfo(Enchantment ench) {
        String str = ench.toString();
        str = str + "\n    Name: " + ench.func_77320_a();
        str = str + "\n    Registry Name: " + ench.getRegistryName();
        str = str + "\n    Name: " + ench.func_77320_a();
        str = str + "\n    Max Level: " + ench.func_77325_b();
        str = str + "\n    Type: " + ench.field_77351_y;
        str = str + "\n    Allowed On Books: " + ench.isAllowedOnBooks();
        str = str + "\n    Curse: " + ench.func_190936_d();
        str = str + "\n    Treasure: " + ench.func_185261_e();
        return str;
    }

    static {
        MODELS_BY_TYPE.put(EnchantmentType.VANISHABLE.toString(), Icon.ANY);
        MODELS_BY_TYPE.put(EnchantmentType.BREAKABLE.toString(), Icon.ANY);
        MODELS_BY_TYPE.put(EnchantmentType.ARMOR.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentType.ARMOR_CHEST.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentType.ARMOR_FEET.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentType.ARMOR_HEAD.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentType.ARMOR_LEGS.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentType.WEARABLE.toString(), Icon.ARMOR);
        MODELS_BY_TYPE.put(EnchantmentType.BOW.toString(), Icon.BOW);
        MODELS_BY_TYPE.put(EnchantmentType.DIGGER.toString(), Icon.TOOL);
        MODELS_BY_TYPE.put(EnchantmentType.FISHING_ROD.toString(), Icon.FISHING_ROD);
        MODELS_BY_TYPE.put(EnchantmentType.TRIDENT.toString(), Icon.TRIDENT);
        MODELS_BY_TYPE.put(EnchantmentType.WEAPON.toString(), Icon.SWORD);
    }

    public static enum Icon {
        ANY,
        ARMOR,
        BOW,
        EMPTY,
        FISHING_ROD,
        SWORD,
        TOOL,
        TRIDENT,
        UNKNOWN;


        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

