/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.soul;

import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.IPartSerializer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.gear.part.AbstractGearPart;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartSerializers;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.lib.soul.GearSoul;
import net.silentchaos512.gems.util.SoulManager;
import net.silentchaos512.utils.MathUtils;

public class GearSoulPart
extends AbstractGearPart {
    private static final ResourceLocation TYPE_ID = SilentGems.getId("gear_soul");
    public static final IPartSerializer<GearSoulPart> SERIALIZER = new AbstractGearPart.Serializer(TYPE_ID, GearSoulPart::new);
    public static final PartType TYPE = PartType.create((PartType.Builder)PartType.Builder.builder((ResourceLocation)TYPE_ID).isRemovable(true).isUpgrade(true));

    public GearSoulPart(ResourceLocation id) {
        super(id);
    }

    public PartType getType() {
        return TYPE;
    }

    public IPartSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public Collection<StatInstance> getStatModifiers(IPartData part, PartType partType, StatGearKey key, ItemStack gear) {
        float amount;
        Collection mods = super.getStatModifiers(part, partType, key, gear);
        GearSoul soul = GearSoulPart.getSoul(gear, part);
        if (soul != null && !MathUtils.doublesEqual((double)(amount = GearSoulPart.getSoulStatModifier(soul, key.getStat())), (double)0.0)) {
            mods.add(GearSoulPart.getSoulBoostedModifier(key, amount));
        }
        return mods;
    }

    private static float getSoulStatModifier(GearSoul soul, IItemStat stat) {
        return soul.getStatModifier(stat);
    }

    private static StatInstance getSoulBoostedModifier(StatGearKey key, float value) {
        return StatInstance.of((float)value, (StatInstance.Operation)StatInstance.Operation.MUL1, (StatGearKey)key);
    }

    public Collection<TraitInstance> getTraits(IPartData part, PartGearKey partKey, ItemStack gear) {
        ArrayList<TraitInstance> traits = new ArrayList<TraitInstance>(super.getTraits(part, partKey, gear));
        GearSoul soul = GearSoulPart.getSoul(gear, part);
        if (soul != null) {
            soul.getSkills().forEach((skill, level) -> {
                if (skill.getTrait() != null) {
                    traits.add(TraitInstance.of((ITrait)skill.getTrait(), (int)level, (ITraitCondition[])new ITraitCondition[0]));
                }
            });
        }
        return traits;
    }

    @Nullable
    private static GearSoul getSoul(ItemStack gear, IPartData part) {
        GearSoul soul = SoulManager.getSoul(gear);
        return soul != null ? soul : SoulManager.getSoul(part.getItem());
    }

    public void onAddToGear(ItemStack gear, PartData part) {
        GearSoul soul = SoulManager.getSoul(part.getItem());
        if (soul == null) {
            SilentGems.LOGGER.warn("Gear soul is missing soul data: {}", (Object)part.getItem());
            return;
        }
        SoulManager.setSoul(gear, soul);
    }

    public int getColor(PartData part, ItemStack gear, int layer, int animationFrame) {
        return 0xFFFFFF;
    }

    public boolean canAddToGear(ItemStack gear, PartData part) {
        return true;
    }

    static {
        PartSerializers.register(SERIALIZER);
    }
}

