/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.lib.urn;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.urn.SoulUrnTileEntity;
import net.silentchaos512.gems.item.SoulUrnUpgrades;

public class UrnUpgrade {
    private static final Map<ResourceLocation, Serializer<? extends UrnUpgrade>> SERIALIZERS = new HashMap<ResourceLocation, Serializer<? extends UrnUpgrade>>();
    ResourceLocation id;

    public void tickTile(SoulUrnTileEntity.SoulUrnState state, World world, BlockPos pos) {
    }

    public void tickItem(ItemStack urn, World world, PlayerEntity player, int itemSlot, boolean isSelected) {
    }

    @Deprecated
    public String getTranslationKey() {
        return "urn_upgrade." + this.id;
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent("urn_upgrade." + this.id);
    }

    public static final class ListHelper {
        private ListHelper() {
        }

        public static NonNullList<UrnUpgrade> load(ItemStack urn) {
            return ListHelper.load(urn.func_190925_c("BlockEntityTag"));
        }

        public static NonNullList<UrnUpgrade> load(CompoundNBT tagCompound) {
            NonNullList result = NonNullList.func_191196_a();
            ListNBT tagList = tagCompound.func_150295_c("Upgrades", 10);
            for (INBT nbt : tagList) {
                if (!(nbt instanceof CompoundNBT)) continue;
                CompoundNBT tags = (CompoundNBT)nbt;
                ResourceLocation id = new ResourceLocation(tags.func_74779_i("ID"));
                Serializer serializer = (Serializer)SERIALIZERS.get(id);
                if (serializer != null) {
                    result.add(serializer.deserialize(tags));
                    continue;
                }
                SilentGems.LOGGER.error("Serializer for urn upgrade {} not found! Data will be lost.", (Object)id);
            }
            return result;
        }

        public static void save(List<UrnUpgrade> upgrades, CompoundNBT tagCompound) {
            ListNBT tagList = new ListNBT();
            for (UrnUpgrade upgrade : upgrades) {
                Serializer serializer = (Serializer)SERIALIZERS.get(upgrade.id);
                if (serializer != null) {
                    CompoundNBT tags = serializer.serialize();
                    tags.func_74778_a("ID", upgrade.id.toString());
                    tagList.add((Object)tags);
                    continue;
                }
                SilentGems.LOGGER.error("Serializer for urn upgrade {} not found! Data will be lost.", (Object)upgrade.id);
            }
            tagCompound.func_218657_a("Upgrades", (INBT)tagList);
        }

        public static boolean contains(List<UrnUpgrade> upgrades, Serializer<? extends UrnUpgrade> serializer) {
            for (UrnUpgrade upgrade : upgrades) {
                if (!upgrade.id.equals((Object)((Serializer)serializer).id)) continue;
                return true;
            }
            return false;
        }

        public static boolean contains(List<UrnUpgrade> upgrades, SoulUrnUpgrades upgrade) {
            return ListHelper.contains(upgrades, upgrade.getSerializer());
        }
    }

    public static class Serializer<T extends UrnUpgrade> {
        private final ResourceLocation id;
        private final Supplier<T> constructor;

        public Serializer(ResourceLocation id, Supplier<T> constructor) {
            this.id = id;
            this.constructor = constructor;
            SERIALIZERS.put(id, this);
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public CompoundNBT serialize() {
            return new CompoundNBT();
        }

        public T deserialize(CompoundNBT nbt) {
            UrnUpgrade result = (UrnUpgrade)this.constructor.get();
            result.id = this.id;
            return (T)result;
        }
    }
}

