/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.silentchaos512.gems.chaos.Chaos;
import net.silentchaos512.gems.chaos.ChaosSourceCapability;
import net.silentchaos512.gems.client.ClientPlayerInfo;

public class GeneralSyncPacket {
    private int playerChaos;
    private int worldChaos;
    private int equilibrium;

    public GeneralSyncPacket() {
    }

    public GeneralSyncPacket(int playerChaos, int worldChaos, int equilibrium) {
        this.playerChaos = playerChaos;
        this.worldChaos = worldChaos;
        this.equilibrium = equilibrium;
    }

    public GeneralSyncPacket(PlayerEntity player) {
        player.getCapability(ChaosSourceCapability.INSTANCE).ifPresent(source -> {
            this.playerChaos = source.getChaos();
        });
        player.field_70170_p.getCapability(ChaosSourceCapability.INSTANCE).ifPresent(source -> {
            this.worldChaos = source.getChaos();
        });
        this.equilibrium = Chaos.getEquilibriumPoint(player.field_70170_p);
    }

    public static GeneralSyncPacket fromBytes(PacketBuffer buf) {
        GeneralSyncPacket packet = new GeneralSyncPacket();
        packet.playerChaos = buf.func_150792_a();
        packet.worldChaos = buf.func_150792_a();
        packet.equilibrium = buf.func_150792_a();
        return packet;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_150787_b(this.playerChaos);
        buf.func_150787_b(this.worldChaos);
        buf.func_150787_b(this.equilibrium);
    }

    public static void handle(GeneralSyncPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ClientPlayerInfo.playerChaos = packet.playerChaos;
            ClientPlayerInfo.worldChaos = packet.worldChaos;
            ClientPlayerInfo.equilibriumChaos = packet.equilibrium;
        });
        context.get().setPacketHandled(true);
    }
}

