/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gems.world;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpreadConfig;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gems.SilentGems;
import net.silentchaos512.gems.block.MiscOres;
import net.silentchaos512.gems.block.WildFluffyPuffPlant;
import net.silentchaos512.gems.config.GemsConfig;
import net.silentchaos512.gems.init.GemsBlocks;
import net.silentchaos512.gems.init.GemsEntities;
import net.silentchaos512.gems.lib.Gems;
import net.silentchaos512.gems.world.feature.GemGeodeFeature;
import net.silentchaos512.gems.world.feature.GemGeodeFeatureConfig;
import net.silentchaos512.gems.world.feature.RegionalGemsFeature;
import net.silentchaos512.gems.world.feature.RegionalGemsFeatureConfig;
import net.silentchaos512.gems.world.feature.RegionalGlowrosesFeature;
import net.silentchaos512.gems.world.feature.RegionalGlowrosesFeatureConfig;
import net.silentchaos512.gems.world.feature.SGOreFeature;
import net.silentchaos512.lib.world.placement.DimensionFilterConfig;
import net.silentchaos512.lib.world.placement.LibPlacements;
import net.silentchaos512.utils.Lazy;

@Mod.EventBusSubscriber(modid="silentgems")
public final class GemsWorldFeatures {
    public static final Feature<RegionalGlowrosesFeatureConfig> REGIONAL_GLOWROSES = new RegionalGlowrosesFeature(RegionalGlowrosesFeatureConfig.CODEC);
    private static boolean configuredFeaturesRegistered = false;
    private static final Map<ResourceLocation, Lazy<ConfiguredFeature<?, ?>>> CONFIGURED_FEATURES = new LinkedHashMap();
    private static final Lazy<RegionalGemsFeatureConfig> OVERWORLD_REGIONAL_GEMS_CONFIG = Lazy.of(() -> new RegionalGemsFeatureConfig(Gems.Set.CLASSIC, 8, (Integer)GemsConfig.Common.regionSizeOverworld.get()));
    private static final Lazy<RegionalGemsFeatureConfig> NETHER_REGIONAL_GEMS_CONFIG = Lazy.of(() -> new RegionalGemsFeatureConfig(Gems.Set.DARK, 8, (Integer)GemsConfig.Common.regionSizeNether.get()));
    private static final Lazy<RegionalGemsFeatureConfig> END_REGIONAL_GEMS_CONFIG = Lazy.of(() -> new RegionalGemsFeatureConfig(Gems.Set.LIGHT, 8, (Integer)GemsConfig.Common.regionSizeEnd.get()));
    private static final Lazy<RegionalGemsFeatureConfig> MOD_DIM_REGIONAL_GEMS_CONFIG = Lazy.of(() -> new RegionalGemsFeatureConfig(Gems.Set.CLASSIC, 8, (Integer)GemsConfig.Common.regionSizeOthers.get()));
    private static final Lazy<ConfiguredFeature<?, ?>> OVERWORLD_GEMS = GemsWorldFeatures.configuredFeature("overworld_gems", () -> (ConfiguredFeature)((ConfiguredFeature)RegionalGemsFeature.INSTANCE.func_225566_b_((IFeatureConfig)OVERWORLD_REGIONAL_GEMS_CONFIG.get()).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(8, 0, 48))).func_227228_a_(LibPlacements.DIMENSION_FILTER.func_227446_a_((IPlacementConfig)DimensionFilterConfig.whitelist((RegistryKey[])new RegistryKey[]{World.field_234918_g_}))).func_242728_a()).func_242731_b(((Integer)GemsConfig.Common.gemCountOverworld.get()).intValue()));
    private static final Lazy<ConfiguredFeature<?, ?>> NETHER_GEMS = GemsWorldFeatures.configuredFeature("nether_gems", () -> (ConfiguredFeature)((ConfiguredFeature)RegionalGemsFeature.INSTANCE.func_225566_b_((IFeatureConfig)NETHER_REGIONAL_GEMS_CONFIG.get()).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(25, 0, 95))).func_227228_a_(LibPlacements.DIMENSION_FILTER.func_227446_a_((IPlacementConfig)DimensionFilterConfig.whitelist((RegistryKey[])new RegistryKey[]{World.field_234919_h_}))).func_242728_a()).func_242731_b(((Integer)GemsConfig.Common.gemCountNether.get()).intValue()));
    private static final Lazy<ConfiguredFeature<?, ?>> END_GEMS = GemsWorldFeatures.configuredFeature("end_gems", () -> (ConfiguredFeature)((ConfiguredFeature)RegionalGemsFeature.INSTANCE.func_225566_b_((IFeatureConfig)END_REGIONAL_GEMS_CONFIG.get()).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(16, 0, 72))).func_227228_a_(LibPlacements.DIMENSION_FILTER.func_227446_a_((IPlacementConfig)DimensionFilterConfig.whitelist((RegistryKey[])new RegistryKey[]{World.field_234920_i_}))).func_242728_a()).func_242731_b(((Integer)GemsConfig.Common.gemCountEnd.get()).intValue()));
    private static final Lazy<ConfiguredFeature<?, ?>> MOD_DIM_GEMS = GemsWorldFeatures.configuredFeature("mod_dim_gems", () -> (ConfiguredFeature)((ConfiguredFeature)RegionalGemsFeature.INSTANCE.func_225566_b_((IFeatureConfig)MOD_DIM_REGIONAL_GEMS_CONFIG.get()).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(8, 0, 48))).func_227228_a_(LibPlacements.DIMENSION_FILTER.func_227446_a_((IPlacementConfig)DimensionFilterConfig.blacklist((RegistryKey[])new RegistryKey[]{World.field_234918_g_, World.field_234919_h_, World.field_234920_i_}))).func_242728_a()).func_242731_b(((Integer)GemsConfig.Common.gemCountOthers.get()).intValue()));
    private static final Lazy<DimensionFilterConfig> GLOWROSE_DIMENSION_BLACKLIST_CONFIG = Lazy.of(() -> DimensionFilterConfig.blacklist((RegistryKey[])((RegistryKey[])((List)GemsConfig.Common.glowroseDimensionBlacklist.get()).stream().map(s -> RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(s))).toArray(RegistryKey[]::new))));
    private static final Lazy<ConfiguredFeature<?, ?>> OVERWORLD_GLOWROSES = GemsWorldFeatures.configuredFeature("overworld_glowroses", () -> (ConfiguredFeature)((ConfiguredFeature)REGIONAL_GLOWROSES.func_225566_b_((IFeatureConfig)new RegionalGlowrosesFeatureConfig(Gems.Set.CLASSIC, (Integer)GemsConfig.Common.regionSizeOverworld.get())).func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(((Integer)GemsConfig.Common.glowrosePlacementCount.get()).intValue()))).func_227228_a_(LibPlacements.DIMENSION_FILTER.func_227446_a_((IPlacementConfig)DimensionFilterConfig.whitelist((RegistryKey[])new RegistryKey[]{World.field_234918_g_}))).func_227228_a_(LibPlacements.DIMENSION_FILTER.func_227446_a_((IPlacementConfig)GLOWROSE_DIMENSION_BLACKLIST_CONFIG.get())).func_242733_d(128)).func_242729_a(16));
    private static final Lazy<ConfiguredFeature<?, ?>> NETHER_GLOWROSES = GemsWorldFeatures.configuredFeature("nether_glowroses", () -> (ConfiguredFeature)((ConfiguredFeature)REGIONAL_GLOWROSES.func_225566_b_((IFeatureConfig)new RegionalGlowrosesFeatureConfig(Gems.Set.DARK, (Integer)GemsConfig.Common.regionSizeNether.get(), 48)).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(((Integer)GemsConfig.Common.glowrosePlacementCount.get()).intValue()))).func_227228_a_(LibPlacements.DIMENSION_FILTER.func_227446_a_((IPlacementConfig)DimensionFilterConfig.whitelist((RegistryKey[])new RegistryKey[]{World.field_234919_h_}))).func_227228_a_(LibPlacements.DIMENSION_FILTER.func_227446_a_((IPlacementConfig)GLOWROSE_DIMENSION_BLACKLIST_CONFIG.get())).func_242733_d(128)).func_242729_a(4));
    private static final Lazy<ConfiguredFeature<?, ?>> END_GLOWROSES = GemsWorldFeatures.configuredFeature("end_glowroses", () -> (ConfiguredFeature)((ConfiguredFeature)REGIONAL_GLOWROSES.func_225566_b_((IFeatureConfig)new RegionalGlowrosesFeatureConfig(Gems.Set.LIGHT, (Integer)GemsConfig.Common.regionSizeEnd.get())).func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(((Integer)GemsConfig.Common.glowrosePlacementCount.get()).intValue()))).func_227228_a_(LibPlacements.DIMENSION_FILTER.func_227446_a_((IPlacementConfig)DimensionFilterConfig.whitelist((RegistryKey[])new RegistryKey[]{World.field_234920_i_}))).func_227228_a_(LibPlacements.DIMENSION_FILTER.func_227446_a_((IPlacementConfig)GLOWROSE_DIMENSION_BLACKLIST_CONFIG.get())).func_242733_d(128)).func_242729_a(8));
    private static final Lazy<ConfiguredFeature<?, ?>> MOD_DIM_GLOWROSES = GemsWorldFeatures.configuredFeature("mod_dim_glowroses", () -> (ConfiguredFeature)((ConfiguredFeature)REGIONAL_GLOWROSES.func_225566_b_((IFeatureConfig)new RegionalGlowrosesFeatureConfig(Gems.Set.CLASSIC, (Integer)GemsConfig.Common.regionSizeOthers.get(), 24)).func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(((Integer)GemsConfig.Common.glowrosePlacementCount.get()).intValue()))).func_227228_a_(LibPlacements.DIMENSION_FILTER.func_227446_a_((IPlacementConfig)DimensionFilterConfig.blacklist((RegistryKey[])new RegistryKey[]{World.field_234918_g_, World.field_234919_h_, World.field_234920_i_}))).func_227228_a_(LibPlacements.DIMENSION_FILTER.func_227446_a_((IPlacementConfig)GLOWROSE_DIMENSION_BLACKLIST_CONFIG.get())).func_242733_d(128)).func_242729_a(8));
    private static final Lazy<ConfiguredFeature<?, ?>> CHAOS_ORE = GemsWorldFeatures.configuredFeature("chaos_ore", () -> GemsWorldFeatures.createOre(MiscOres.CHAOS.asBlock(), 9, (Integer)GemsConfig.Common.worldGenChaosOreVeinCount.get(), 0, 20, (ITag<Block>)Tags.Blocks.STONE));
    private static final Lazy<ConfiguredFeature<?, ?>> SILVER_ORE = GemsWorldFeatures.configuredFeature("silver_ore", () -> GemsWorldFeatures.createOre(MiscOres.SILVER.asBlock(), 6, (Integer)GemsConfig.Common.worldGenSilverVeinCount.get(), 6, 28, (ITag<Block>)Tags.Blocks.STONE));
    private static final Lazy<ConfiguredFeature<?, ?>> ENDER_ORE = GemsWorldFeatures.configuredFeature("ender_ore", () -> GemsWorldFeatures.createOre(MiscOres.ENDER.asBlock(), 16, (Integer)GemsConfig.Common.worldGenEnderOreCount.get(), 10, 70, (ITag<Block>)Tags.Blocks.END_STONES));
    private static final Lazy<ConfiguredFeature<?, ?>> OVERWORLD_CLASSIC_GEODE = GemsWorldFeatures.configuredFeature("overworld_classic_geode", () -> GemsWorldFeatures.createGeodeFeature(Gems.Set.CLASSIC, 1.0f, (ITag.INamedTag<Block>)BlockTags.field_242172_aH, DimensionFilterConfig.whitelist((RegistryKey[])new RegistryKey[]{World.field_234918_g_})));
    private static final Lazy<ConfiguredFeature<?, ?>> OVERWORLD_DARK_GEODE = GemsWorldFeatures.configuredFeature("overworld_dark_geode", () -> GemsWorldFeatures.createGeodeFeature(Gems.Set.DARK, 2.0f, (ITag.INamedTag<Block>)BlockTags.field_242172_aH, DimensionFilterConfig.whitelist((RegistryKey[])new RegistryKey[]{World.field_234918_g_})));
    private static final Lazy<ConfiguredFeature<?, ?>> OVERWORLD_LIGHT_GEODE = GemsWorldFeatures.configuredFeature("overworld_light_geode", () -> GemsWorldFeatures.createGeodeFeature(Gems.Set.LIGHT, 3.0f, (ITag.INamedTag<Block>)BlockTags.field_242172_aH, DimensionFilterConfig.whitelist((RegistryKey[])new RegistryKey[]{World.field_234918_g_})));
    private static final Lazy<ConfiguredFeature<?, ?>> NETHER_DARK_GEODE = GemsWorldFeatures.configuredFeature("nether_dark_geode", () -> GemsWorldFeatures.createGeodeFeature(Gems.Set.DARK, 1.0f, (ITag.INamedTag<Block>)BlockTags.field_242173_aI, DimensionFilterConfig.whitelist((RegistryKey[])new RegistryKey[]{World.field_234919_h_})));
    private static final Lazy<ConfiguredFeature<?, ?>> END_LIGHT_GEODE = GemsWorldFeatures.configuredFeature("end_light_geode", () -> GemsWorldFeatures.createGeodeFeature(Gems.Set.LIGHT, 1.0f, (ITag.INamedTag<Block>)Tags.Blocks.END_STONES, DimensionFilterConfig.whitelist((RegistryKey[])new RegistryKey[]{World.field_234920_i_})));
    private static final Lazy<ConfiguredFeature<?, ?>> MOD_DIM_CLASSIC_GEODE = GemsWorldFeatures.configuredFeature("mod_dim_classic_geode", () -> GemsWorldFeatures.createGeodeFeature(Gems.Set.CLASSIC, 1.0f, (ITag.INamedTag<Block>)BlockTags.field_242172_aH, DimensionFilterConfig.blacklist((RegistryKey[])new RegistryKey[]{World.field_234918_g_, World.field_234919_h_, World.field_234920_i_})));
    private static final Lazy<ConfiguredFeature<?, ?>> MOD_DIM_DARK_GEODE = GemsWorldFeatures.configuredFeature("mod_dim_dark_geode", () -> GemsWorldFeatures.createGeodeFeature(Gems.Set.DARK, 2.0f, (ITag.INamedTag<Block>)BlockTags.field_242172_aH, DimensionFilterConfig.blacklist((RegistryKey[])new RegistryKey[]{World.field_234918_g_, World.field_234919_h_, World.field_234920_i_})));
    private static final Lazy<ConfiguredFeature<?, ?>> MOD_DIM_LIGHT_GEODE = GemsWorldFeatures.configuredFeature("mod_dim_light_geode", () -> GemsWorldFeatures.createGeodeFeature(Gems.Set.LIGHT, 3.0f, (ITag.INamedTag<Block>)BlockTags.field_242172_aH, DimensionFilterConfig.blacklist((RegistryKey[])new RegistryKey[]{World.field_234918_g_, World.field_234919_h_, World.field_234920_i_})));
    private static final Lazy<ConfiguredFeature<?, ?>> WILD_FLUFFY_PUFFS = GemsWorldFeatures.configuredFeature("wild_fluffy_puffs", () -> (ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(((WildFluffyPuffPlant)GemsBlocks.WILD_FLUFFY_PUFF_PLANT.get()).func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(12).func_227322_d_()).func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(1))).func_242729_a(4));

    private GemsWorldFeatures() {
    }

    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        GemsWorldFeatures.registerFeature(event, GemGeodeFeature.INSTANCE, "geode");
        GemsWorldFeatures.registerFeature(event, RegionalGemsFeature.INSTANCE, "regional_gems");
        GemsWorldFeatures.registerFeature(event, REGIONAL_GLOWROSES, "regional_glowroses");
        GemsWorldFeatures.registerFeature(event, SGOreFeature.INSTANCE, "ore");
    }

    public static void registerPlacements(RegistryEvent.Register<Placement<?>> event) {
    }

    private static void registerFeature(RegistryEvent.Register<Feature<?>> event, Feature<?> feature, String name) {
        event.getRegistry().register(feature.setRegistryName(SilentGems.getId(name)));
    }

    private static void registerPlacement(RegistryEvent.Register<Placement<?>> event, Placement<?> placement, String name) {
        event.getRegistry().register(placement.setRegistryName(SilentGems.getId(name)));
    }

    private static void registerConfiguredFeatures() {
        if (configuredFeaturesRegistered) {
            return;
        }
        configuredFeaturesRegistered = true;
        CONFIGURED_FEATURES.forEach((name, lazy) -> GemsWorldFeatures.registerConfiguredFeature(name, (ConfiguredFeature)lazy.get()));
    }

    private static Lazy<ConfiguredFeature<?, ?>> configuredFeature(String name, Supplier<ConfiguredFeature<?, ?>> configuredFeature) {
        Lazy lazy = Lazy.of(configuredFeature);
        CONFIGURED_FEATURES.put(SilentGems.getId(name), lazy);
        return lazy;
    }

    private static void registerConfiguredFeature(ResourceLocation name, ConfiguredFeature<?, ?> configuredFeature) {
        SilentGems.LOGGER.debug("Register configured feature '{}'", (Object)name);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)name, configuredFeature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent biome) {
        GemsWorldFeatures.registerConfiguredFeatures();
        if (biome.getCategory() == Biome.Category.NETHER) {
            GemsWorldFeatures.addNetherFeatures(biome);
        } else if (biome.getCategory() == Biome.Category.THEEND) {
            GemsWorldFeatures.addTheEndFeatures(biome);
        } else {
            biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)OVERWORLD_GEMS.get());
            biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)MOD_DIM_GEMS.get());
            biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)CHAOS_ORE.get());
            biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)SILVER_ORE.get());
            biome.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)OVERWORLD_GLOWROSES.get());
            biome.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)MOD_DIM_GLOWROSES.get());
            biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)OVERWORLD_CLASSIC_GEODE.get());
            biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)OVERWORLD_DARK_GEODE.get());
            biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)OVERWORLD_LIGHT_GEODE.get());
            biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)MOD_DIM_CLASSIC_GEODE.get());
            biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)MOD_DIM_DARK_GEODE.get());
            biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)MOD_DIM_LIGHT_GEODE.get());
            if (biome.getClimate().field_242463_e > 0.4f && ((Boolean)GemsConfig.Common.worldGenWildFluffyPuffs.get()).booleanValue()) {
                biome.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)WILD_FLUFFY_PUFFS.get());
            }
        }
    }

    private static void addNetherFeatures(BiomeLoadingEvent biome) {
        biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)NETHER_GEMS.get());
        biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)NETHER_DARK_GEODE.get());
        biome.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)NETHER_GLOWROSES.get());
        biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)NETHER_DARK_GEODE.get());
    }

    private static void addTheEndFeatures(BiomeLoadingEvent biome) {
        biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)END_GEMS.get());
        biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)END_LIGHT_GEODE.get());
        biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)ENDER_ORE.get());
        biome.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)END_GLOWROSES.get());
        biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)END_LIGHT_GEODE.get());
        GemsWorldFeatures.addEnderSlimeSpawns(biome);
    }

    public static ITag<Block> getOreGenTargetBlock(Gems.Set gemSet) {
        if (gemSet == Gems.Set.DARK) {
            return Tags.Blocks.NETHERRACK;
        }
        if (gemSet == Gems.Set.LIGHT) {
            return Tags.Blocks.END_STONES;
        }
        return Tags.Blocks.STONE;
    }

    private static ConfiguredFeature<?, ?> createOre(Block block, int size, int count, int minHeight, int maxHeight, ITag<Block> blockToReplace) {
        return (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig((RuleTest)new TagMatchRuleTest(blockToReplace), block.func_176223_P(), size)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(minHeight, 0, maxHeight))).func_242728_a()).func_242731_b(count);
    }

    private static ConfiguredFeature<?, ?> createGeodeFeature(Gems.Set gemSet, float baseChance, ITag.INamedTag<Block> target, DimensionFilterConfig dimensionFilter) {
        return GemGeodeFeature.INSTANCE.func_225566_b_(new GemGeodeFeatureConfig(gemSet, gemSet.getGeodeShell().asBlockState(), (ITag<Block>)target)).func_227228_a_(Placement.field_242908_m.func_227446_a_((IPlacementConfig)new TopSolidRangeConfig(20, 0, 40))).func_227228_a_(Placement.field_242898_b.func_227446_a_((IPlacementConfig)new ChanceConfig((int)((double)baseChance / (Double)GemsConfig.Common.worldGenGeodeBaseChance.get())))).func_227228_a_(LibPlacements.DIMENSION_FILTER.func_227446_a_((IPlacementConfig)dimensionFilter));
    }

    private static void addEnderSlimeSpawns(BiomeLoadingEvent biome) {
        int spawnWeight = (Integer)GemsConfig.Common.enderSlimeSpawnWeight.get();
        if (spawnWeight > 0) {
            biome.getSpawns().getSpawner(EntityClassification.MONSTER).add(new MobSpawnInfo.Spawners((EntityType)GemsEntities.ENDER_SLIME.get(), spawnWeight, ((Integer)GemsConfig.Common.enderSlimeGroupSizeMin.get()).intValue(), ((Integer)GemsConfig.Common.enderSlimeGroupSizeMax.get()).intValue()));
        }
    }
}

