/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.research.effects.registry;

import com.minecolonies.api.research.effects.IResearchEffect;
import java.util.function.Function;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.Validate;

public class ResearchEffectEntry
extends ForgeRegistryEntry<ResearchEffectEntry> {
    private final Function<CompoundNBT, IResearchEffect<?>> readFromNBT;

    public IResearchEffect<?> readFromNBT(CompoundNBT nbt) {
        return this.readFromNBT.apply(nbt);
    }

    private ResearchEffectEntry(Function<CompoundNBT, IResearchEffect<?>> readFromNBT) {
        this.readFromNBT = readFromNBT;
    }

    public static final class Builder {
        private Function<CompoundNBT, IResearchEffect<?>> readFromNBT;
        private ResourceLocation registryName;

        public Builder setReadFromNBT(Function<CompoundNBT, IResearchEffect<?>> readFromNBT) {
            this.readFromNBT = readFromNBT;
            return this;
        }

        public Builder setRegistryName(ResourceLocation registryName) {
            this.registryName = registryName;
            return this;
        }

        public ResearchEffectEntry createResearchEffectEntry() {
            Validate.notNull(this.readFromNBT);
            Validate.notNull((Object)this.registryName);
            return (ResearchEffectEntry)new ResearchEffectEntry(this.readFromNBT).setRegistryName(this.registryName);
        }
    }
}

