/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.coremod.client.gui.ColorPalette;
import com.minecolonies.coremod.client.gui.townhall.AbstractWindowTownHall;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.BannerTileEntityRenderer;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.tileentity.BannerTileEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class WindowBannerPicker
extends Screen {
    private static final int GUI_Y = 30;
    private static final int SIDE = 20;
    private static final int PATTERN_HEIGHT = 30;
    private static final int PATTERN_WIDTH = 15;
    private static final int PATTERN_MARGIN = 3;
    private static final int PATTERN_COLUMNS = 8;
    private static final int PATTERN_ROWS = 4;
    private static final BannerPattern[][] EXCLUSION = new BannerPattern[][]{{BannerPattern.GRADIENT, BannerPattern.GRADIENT_UP}, {BannerPattern.BRICKS, BannerPattern.FLOWER}, {BannerPattern.SKULL, BannerPattern.CREEPER}, {BannerPattern.GLOBE, BannerPattern.PIGLIN}, {BannerPattern.MOJANG}, {BannerPattern.BASE}};
    private final List<BannerPattern> patterns;
    private final List<Pair<BannerPattern, DyeColor>> layers;
    private final IColonyView colony;
    private final AbstractWindowTownHall window;
    private final ModelRenderer modelRender;
    private ColorPalette colors;
    private int activeLayer = 0;
    private boolean scrolling = false;
    private int scrollRow = 0;

    public WindowBannerPicker(IColonyView colony, AbstractWindowTownHall hallWindow) {
        super((ITextComponent)new StringTextComponent("Flag"));
        this.colony = colony;
        this.window = hallWindow;
        this.modelRender = BannerTileEntityRenderer.func_228836_a_();
        ArrayList<BannerPattern> exclusion = new ArrayList<BannerPattern>();
        for (int i = ((ITownHallView)hallWindow.building).getBuildingLevel(); i <= ((ITownHallView)hallWindow.building).getBuildingMaxLevel(); ++i) {
            exclusion.addAll(Arrays.asList(EXCLUSION[i]));
        }
        this.patterns = new LinkedList<BannerPattern>(Arrays.asList(BannerPattern.values()));
        this.patterns.removeAll(exclusion);
        this.layers = BannerTileEntity.func_230138_a_((DyeColor)DyeColor.WHITE, (ListNBT)colony.getColonyFlag());
        if (this.layers.size() > 1) {
            this.layers.remove(0);
        }
    }

    protected void func_231160_c_() {
        int paletteX = WindowBannerPicker.center(this.field_230708_k_, 8, 15, 0, 0) - 70;
        this.colors = new ColorPalette(paletteX, this.field_230709_l_ / 2, 2, x$0 -> {
            Button cfr_ignored_0 = (Button)this.func_230480_a_((Widget)x$0);
        });
        this.colors.onchange = color -> this.setLayer(null, color);
        this.createLayerButtons();
        this.createPatternButtons();
        this.createCloseButtons();
    }

    protected void createLayerButtons() {
        for (int layer = 0; layer <= 6; ++layer) {
            int posX = (this.field_230708_k_ - 120) / 2 + layer * 20;
            this.func_230480_a_((Widget)new LayerButton(posX, 30, 20, 20, layer));
        }
        this.func_230480_a_((Widget)new Button(WindowBannerPicker.center(this.field_230708_k_, 6, 20, 7, 0), 30, 20, 20, (ITextComponent)new StringTextComponent(TextFormatting.RED + "X"), pressed -> this.layers.remove(this.activeLayer)){

            public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
                this.field_230693_o_ = WindowBannerPicker.this.activeLayer < WindowBannerPicker.this.layers.size() && WindowBannerPicker.this.activeLayer != 0;
                super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
            }
        });
    }

    protected void createPatternButtons() {
        for (int i = 0; i < this.patterns.size(); ++i) {
            int posX = WindowBannerPicker.center(this.field_230708_k_, 8, 15, i % 8, 3);
            int posY = WindowBannerPicker.center(this.field_230709_l_ + 30, 4, 30, Math.floorDiv(i, 8), 3);
            this.func_230480_a_((Widget)new PatternButton(posX, posY, 30, this.patterns.get(i)));
        }
    }

    protected void createCloseButtons() {
        this.func_230480_a_((Widget)new Button(WindowBannerPicker.center(this.field_230708_k_, 2, 80, 1, 10), this.field_230709_l_ - 40, 80, 20, (ITextComponent)new TranslationTextComponent("gui.done"), pressed -> {
            BannerPattern.Builder builder = new BannerPattern.Builder();
            for (Pair<BannerPattern, DyeColor> pair : this.layers) {
                builder.func_222477_a((BannerPattern)pair.getFirst(), (DyeColor)pair.getSecond());
            }
            this.colony.setColonyFlag(builder.func_222476_a());
            this.window.open();
        }));
        this.func_230480_a_((Widget)new Button(WindowBannerPicker.center(this.field_230708_k_, 2, 80, 0, 10), this.field_230709_l_ - 40, 80, 20, (ITextComponent)new TranslationTextComponent("gui.cancel"), pressed -> this.window.open()));
    }

    public static int center(int length, int count, int side, int n, int margin) {
        return (length - count * (side + margin)) / 2 + n * (side + margin) + margin / 2;
    }

    public void setLayer(@Nullable BannerPattern pattern, DyeColor color) {
        if (pattern == null) {
            if (this.activeLayer == this.layers.size()) {
                return;
            }
            pattern = this.activeLayer == 0 ? BannerPattern.BASE : (BannerPattern)this.layers.get(this.activeLayer).getFirst();
        }
        if (this.activeLayer == this.layers.size()) {
            this.layers.add((Pair<BannerPattern, DyeColor>)new Pair((Object)pattern, (Object)color));
        } else {
            this.layers.set(this.activeLayer, (Pair<BannerPattern, DyeColor>)new Pair((Object)pattern, (Object)color));
        }
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.drawFlag();
        int scrollRows = (int)(Math.ceil((float)this.patterns.size() / 8.0f) - 4.0);
        if (scrollRows > 0 && this.activeLayer > 0) {
            int trackHeight = 132;
            double barHeight = (float)trackHeight * (4.0f / (float)(scrollRows + 4));
            int trackX = WindowBannerPicker.center(this.field_230708_k_, 8, 15, 8, 3);
            int trackY = (int)((float)WindowBannerPicker.center(this.field_230709_l_, 4, 30, 0, 3) + (float)this.scrollRow * ((float)trackHeight / (float)(scrollRows + 4)));
            WindowBannerPicker.func_238467_a_((MatrixStack)stack, (int)(trackX + 2), (int)trackY, (int)(trackX + 6), (int)(trackY + (int)barHeight), (int)-1140850689);
        }
        WindowBannerPicker.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)new TranslationTextComponent("com.minecolonies.coremod.gui.flag.choose").getString(), (int)(this.field_230708_k_ / 2), (int)16, (int)0xFFFFFF);
    }

    private void drawFlag() {
        RenderHelper.func_227783_c_();
        double posX = ((double)this.field_230708_k_ + 120.0) / 2.0 + 40.0;
        double posY = (double)this.field_230709_l_ / 2.0;
        MatrixStack transform = new MatrixStack();
        transform.func_227861_a_(posX, posY + 40.0, 0.0);
        transform.func_227862_a_(40.0f, -40.0f, 1.0f);
        transform.func_227861_a_(0.5, 0.5, 0.5);
        transform.func_227862_a_(1.0f, -1.0f, -1.0f);
        this.renderBanner(transform, this.layers);
    }

    private void drawBannerPattern(BannerPattern pattern, int x, int y) {
        RenderHelper.func_227783_c_();
        ArrayList<Pair<BannerPattern, DyeColor>> list = new ArrayList<Pair<BannerPattern, DyeColor>>();
        list.add(new Pair((Object)BannerPattern.BASE, (Object)DyeColor.GRAY));
        list.add(new Pair((Object)pattern, (Object)DyeColor.WHITE));
        MatrixStack transform = new MatrixStack();
        transform.func_227860_a_();
        transform.func_227861_a_((double)x + 2.5, (double)(y + 29), 0.0);
        transform.func_227862_a_(10.0f, -11.0f, 1.0f);
        transform.func_227861_a_(0.5, 0.5, 0.5);
        transform.func_227862_a_(1.0f, -1.0f, -1.0f);
        this.renderBanner(transform, list);
    }

    public void renderBanner(MatrixStack transform, List<Pair<BannerPattern, DyeColor>> layers) {
        this.modelRender.field_78795_f = 0.0f;
        this.modelRender.field_78797_d = -32.0f;
        IRenderTypeBuffer.Impl source = this.field_230706_i_.func_228019_au_().func_228487_b_();
        BannerTileEntityRenderer.func_230180_a_((MatrixStack)transform, (IRenderTypeBuffer)source, (int)0xF000F0, (int)OverlayTexture.field_229196_a_, (ModelRenderer)this.modelRender, (RenderMaterial)ModelBakery.field_229315_f_, (boolean)true, layers);
        transform.func_227865_b_();
        source.func_228461_a_();
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double scroll) {
        if (this.activeLayer > 0) {
            this.scrollRow = (int)MathHelper.func_151237_a((double)((double)this.scrollRow - scroll), (double)0.0, (double)(Math.ceil(this.patterns.size() / 8) - 4.0 + 1.0));
        }
        return true;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int p_231044_5_) {
        this.scrolling = false;
        int trackX = WindowBannerPicker.center(this.field_230708_k_, 8, 15, 8, 3);
        int trackY = WindowBannerPicker.center(this.field_230709_l_, 4, 30, 0, 3);
        int trackEnd = trackY + 132;
        if (mouseX > (double)(trackX + 2) && mouseX < (double)(trackX + 8) && mouseY > (double)trackY && mouseY < (double)trackEnd) {
            this.scrolling = true;
        }
        return super.func_231044_a_(mouseX, mouseY, p_231044_5_);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling && this.activeLayer > 0) {
            int trackStart = WindowBannerPicker.center(this.field_230709_l_, 4, 30, 0, 3);
            int trackLength = 132;
            double scrollRatio = MathHelper.func_151237_a((double)((mouseY - (double)trackStart) / (double)trackLength), (double)0.0, (double)1.0);
            this.scrollRow = (int)Math.round(scrollRatio * (Math.ceil(this.patterns.size() / 8) - 4.0 + 1.0));
            return true;
        }
        return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public class LayerButton
    extends Button {
        private final int layer;

        public LayerButton(int x, int y, int width, int height, int layer) {
            super(x - (layer == 0 ? width * 2 : 0), y, width * (layer == 0 ? 3 : 1), height, (ITextComponent)(layer == 0 ? new TranslationTextComponent("com.minecolonies.coremod.gui.flag.base_layer") : new StringTextComponent(String.valueOf(layer))), pressed -> {});
            this.layer = layer;
        }

        public void func_230930_b_() {
            WindowBannerPicker.this.activeLayer = this.layer;
            if (this.layer >= WindowBannerPicker.this.layers.size()) {
                WindowBannerPicker.this.colors.setSelected(((DyeColor)((Pair)WindowBannerPicker.this.layers.get(0)).getSecond()).equals((Object)DyeColor.BLACK) ? DyeColor.WHITE : DyeColor.BLACK);
            } else {
                WindowBannerPicker.this.colors.setSelected((DyeColor)((Pair)WindowBannerPicker.this.layers.get(WindowBannerPicker.this.activeLayer)).getSecond());
            }
        }

        public void func_230430_a_(MatrixStack stack, int p_render_1_, int p_render_2_, float p_render_3_) {
            this.field_230693_o_ = this.layer <= WindowBannerPicker.this.layers.size();
            super.func_230430_a_(stack, p_render_1_, p_render_2_, p_render_3_);
            if (WindowBannerPicker.this.activeLayer == this.layer) {
                LayerButton.func_238467_a_((MatrixStack)stack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)1725798911);
            }
        }
    }

    public class PatternButton
    extends Button {
        private final BannerPattern pattern;
        private final int index;

        public PatternButton(int x, int y, int height, BannerPattern pattern) {
            super(x, y, height / 2, height, (ITextComponent)new StringTextComponent(""), btn -> {});
            this.pattern = pattern;
            this.index = WindowBannerPicker.this.patterns.indexOf(pattern);
        }

        public void func_230930_b_() {
            WindowBannerPicker.this.setLayer(this.pattern, WindowBannerPicker.this.colors.getSelected());
        }

        public void func_230430_a_(MatrixStack stack, int p_render_1_, int p_render_2_, float p_render_3_) {
            this.field_230694_p_ = WindowBannerPicker.this.scrollRow * 8 <= this.index && this.index < 8 * (WindowBannerPicker.this.scrollRow + 4);
            boolean bl = this.field_230693_o_ = WindowBannerPicker.this.activeLayer != 0;
            if (!this.field_230693_o_ || !this.field_230694_p_) {
                return;
            }
            int position = Math.floorDiv(this.index - WindowBannerPicker.this.scrollRow * 8, 8);
            this.field_230691_m_ = WindowBannerPicker.center(WindowBannerPicker.this.field_230709_l_, 4, 30, position, 3);
            super.func_230430_a_(stack, p_render_1_, p_render_2_, p_render_3_);
            WindowBannerPicker.this.drawBannerPattern(this.pattern, this.field_230690_l_, this.field_230691_m_);
        }

        public void func_230431_b_(MatrixStack stack, int p_renderButton_1_, int p_renderButton_2_, float p_renderButton_3_) {
            if (this.field_230694_p_) {
                if (this.func_230449_g_() && this.field_230693_o_) {
                    PatternButton.func_238467_a_((MatrixStack)stack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)-570425345);
                }
                if (WindowBannerPicker.this.activeLayer < WindowBannerPicker.this.layers.size() && ((Pair)WindowBannerPicker.this.layers.get(WindowBannerPicker.this.activeLayer)).getFirst() == this.pattern) {
                    PatternButton.func_238467_a_((MatrixStack)stack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)-2258689);
                } else {
                    PatternButton.func_238467_a_((MatrixStack)stack, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(this.field_230690_l_ + this.field_230688_j_), (int)(this.field_230691_m_ + this.field_230689_k_), (int)0x33888888);
                }
            }
        }
    }
}

