/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.client.gui;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.controls.Image;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.views.ScrollingList;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Delivery;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.tileentities.TileEntityRack;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.client.gui.AbstractWindowSkeleton;
import com.minecolonies.coremod.client.gui.modules.WindowBuilderResModule;
import com.minecolonies.coremod.colony.buildings.moduleviews.BuildingResourcesModuleView;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.coremod.network.messages.server.ResourceScrollSaveWarehouseSnapshotMessage;
import com.minecolonies.coremod.network.messages.server.colony.building.MarkBuildingDirtyMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowResourceList
extends AbstractWindowSkeleton {
    @NotNull
    private final BlockPos buildingPos;
    @Nullable
    private final BuildingBuilder.View builder;
    @NotNull
    private final List<BuildingBuilderResource> resources = new ArrayList<BuildingBuilderResource>();
    @Nullable
    private final BlockPos warehousePos;
    @Nullable
    private final CompoundNBT compound;
    @NotNull
    private String workOrderHash;
    @NotNull
    private Map<String, Integer> warehouseSnapshot;

    public WindowResourceList(int colonyId, @NotNull BlockPos buildingPos, @Nullable BlockPos warehousePos, @Nullable CompoundNBT compound) {
        super("minecolonies:gui/windowresourcescroll.xml");
        IBuildingView buildingView;
        this.buildingPos = buildingPos;
        this.warehousePos = warehousePos;
        this.compound = compound;
        this.warehouseSnapshot = new HashMap<String, Integer>();
        this.workOrderHash = "";
        this.loadWarehouseSnapshotData(compound);
        IColonyView colonyView = IColonyManager.getInstance().getColonyView(colonyId, (RegistryKey<World>)Minecraft.func_71410_x().field_71441_e.func_234923_W_());
        if (colonyView != null && (buildingView = colonyView.getBuilding(buildingPos)) instanceof BuildingBuilder.View) {
            this.builder = (BuildingBuilder.View)buildingView;
            return;
        }
        this.builder = null;
    }

    private void pullResourcesFromWarehouse() {
        String currentWorkOrderHash = this.createWorkOrderHash();
        if (!currentWorkOrderHash.equals(this.workOrderHash)) {
            this.workOrderHash = currentWorkOrderHash;
            this.warehouseSnapshot = new HashMap<String, Integer>();
        }
        if (this.warehousePos != null) {
            this.warehouseSnapshot = new HashMap<String, Integer>();
            IBuildingView newView = this.builder.getColony().getBuilding(this.builder.getID());
            if (newView instanceof BuildingBuilder.View) {
                BuildingResourcesModuleView moduleView = newView.getModuleView(BuildingResourcesModuleView.class);
                List<BlockPos> containers = this.builder.getColony().getBuilding(this.warehousePos).getContainerList();
                for (BlockPos container : containers) {
                    TileEntity rack = Minecraft.func_71410_x().field_71441_e.func_175625_s(container);
                    if (!(rack instanceof TileEntityRack)) continue;
                    ((TileEntityRack)rack).getAllContent().forEach((item, amount) -> {
                        int hashCode = item.getItemStack().func_77942_o() ? item.getItemStack().func_77978_p().hashCode() : 0;
                        String key = item.getItemStack().func_77977_a() + "-" + hashCode;
                        if (!moduleView.getResources().containsKey(key)) {
                            return;
                        }
                        int oldAmount = this.warehouseSnapshot.getOrDefault(key, 0);
                        this.warehouseSnapshot.put(key, oldAmount + amount);
                    });
                }
            }
        }
        this.saveWarehouseSnapshotData();
    }

    private void pullResourcesFromHut() {
        IBuildingView newView = this.builder.getColony().getBuilding(this.builder.getID());
        if (newView instanceof BuildingBuilder.View) {
            BuildingResourcesModuleView moduleView = newView.getModuleView(BuildingResourcesModuleView.class);
            PlayerInventory inventory = this.mc.field_71439_g.field_71071_by;
            boolean isCreative = this.mc.field_71439_g.func_184812_l_();
            ArrayList<Delivery> deliveries = new ArrayList<Delivery>();
            for (Map.Entry<Integer, Collection<IToken<?>>> entry : this.builder.getOpenRequestsByCitizen().entrySet()) {
                this.addDeliveryRequestsToList((List<Delivery>)deliveries, (ImmutableCollection<IToken<?>>)ImmutableList.copyOf(entry.getValue()));
            }
            this.resources.clear();
            this.resources.addAll(moduleView.getResources().values());
            double supplied = 0.0;
            double total = 0.0;
            for (BuildingBuilderResource resource : this.resources) {
                int amountToSet = isCreative ? resource.getAmount() : InventoryUtils.getItemCountInItemHandler((IItemHandler)new InvWrapper((IInventory)inventory), stack -> ItemStackUtils.isEmpty(stack) == false && ItemStackUtils.compareItemStacksIgnoreStackSize(stack, resource.getItemStack()) != false);
                resource.setPlayerAmount(amountToSet);
                resource.setAmountInDelivery(0);
                for (Delivery delivery : deliveries) {
                    if (!ItemStackUtils.compareItemStacksIgnoreStackSize(resource.getItemStack(), delivery.getStack(), false, false)) continue;
                    resource.setAmountInDelivery(resource.getAmountInDelivery() + delivery.getStack().func_190916_E());
                }
                supplied += (double)Math.min(resource.getAvailable(), resource.getAmount());
                total += (double)resource.getAmount();
            }
            if (total > 0.0) {
                ((Text)this.findPaneOfTypeByID("progress", Text.class)).setText((IFormattableTextComponent)new TranslationTextComponent("com.minecolonies.coremod.gui.progress.res", new Object[]{(int)(supplied / total * 100.0) + "%", moduleView.getProgress() + "%"}));
            }
            this.resources.sort(new BuildingBuilderResource.ResourceComparator(BuildingBuilderResource.RessourceAvailability.NOT_NEEDED, BuildingBuilderResource.RessourceAvailability.HAVE_ENOUGH, BuildingBuilderResource.RessourceAvailability.IN_DELIVERY, BuildingBuilderResource.RessourceAvailability.NEED_MORE, BuildingBuilderResource.RessourceAvailability.DONT_HAVE));
        }
    }

    private void addDeliveryRequestsToList(List<Delivery> requestList, ImmutableCollection<IToken<?>> tokensToCheck) {
        for (IToken token : tokensToCheck) {
            IRequest<?> request = this.builder.getColony().getRequestManager().getRequestForToken(token);
            if (request == null) continue;
            if (request.getRequest() instanceof Delivery && ((Delivery)request.getRequest()).getTarget().getInDimensionLocation().equals((Object)this.builder.getID())) {
                requestList.add((Delivery)request.getRequest());
            }
            if (!request.hasChildren()) continue;
            this.addDeliveryRequestsToList(requestList, request.getChildren());
        }
    }

    private void loadWarehouseSnapshotData(@Nullable CompoundNBT compound) {
        if (compound != null) {
            CompoundNBT warehouseSnapshotCompound = compound.func_74775_l("version");
            this.warehouseSnapshot = warehouseSnapshotCompound.func_150296_c().stream().collect(Collectors.toMap(k -> k, arg_0 -> ((CompoundNBT)warehouseSnapshotCompound).func_74762_e(arg_0)));
            this.workOrderHash = compound.func_74779_i("wo_hash");
        }
    }

    private void saveWarehouseSnapshotData() {
        if (this.compound != null) {
            CompoundNBT newData = new CompoundNBT();
            this.warehouseSnapshot.keySet().forEach(f -> newData.func_74768_a(f, this.warehouseSnapshot.getOrDefault(f, 0).intValue()));
            this.compound.func_218657_a("version", (INBT)newData);
            this.compound.func_74778_a("wo_hash", this.workOrderHash);
            Network.getNetwork().sendToServer(new ResourceScrollSaveWarehouseSnapshotMessage(this.buildingPos, this.warehouseSnapshot, this.workOrderHash));
        }
    }

    @NotNull
    private String createWorkOrderHash() {
        Optional<IWorkOrderView> currentWorkOrder;
        if (this.builder != null && (currentWorkOrder = this.builder.getColony().getWorkOrders().stream().filter(o -> o.getClaimedBy().equals((Object)this.buildingPos)).max(Comparator.comparingInt(IWorkOrderView::getPriority))).isPresent()) {
            long location = currentWorkOrder.get().getLocation().func_218275_a();
            return location + "__" + currentWorkOrder.get().getStructureName();
        }
        return "";
    }

    public void onOpened() {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (this.builder == null) {
            MessageUtils.format("com.minecolonies.coremod.resourcescroll.nobuilder", new Object[0]).sendTo(new PlayerEntity[]{player});
            this.close();
            return;
        }
        super.onOpened();
        this.pullResourcesFromHut();
        this.pullResourcesFromWarehouse();
        ScrollingList resourceList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        if (resourceList == null) {
            MessageUtils.format("com.minecolonies.coremod.resourcescroll.null", new Object[0]).sendTo(new PlayerEntity[]{player});
            this.close();
            return;
        }
        resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowResourceList.this.resources.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                WindowResourceList.this.updateResourcePane(index, rowPane);
            }
        });
        BuildingResourcesModuleView moduleView = this.builder.getModuleView(BuildingResourcesModuleView.class);
        Network.getNetwork().sendToServer(new MarkBuildingDirtyMessage(this.builder));
        ((Text)this.findPaneOfTypeByID("workerName", Text.class)).setText(this.builder.getWorkerName());
        ((Text)this.findPaneOfTypeByID("constructionName", Text.class)).setText(moduleView.getConstructionName());
    }

    private void updateResourcePane(int index, @NotNull Pane rowPane) {
        BuildingBuilderResource resource = this.resources.get(index);
        Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
        Text resourceMissingLabel = (Text)rowPane.findPaneOfTypeByID("resourceMissing", Text.class);
        Text neededLabel = (Text)rowPane.findPaneOfTypeByID("resourceAvailableNeeded", Text.class);
        ((Image)rowPane.findPaneOfTypeByID("indeliveryicon", Image.class)).setVisible(false);
        ((Text)rowPane.findPaneOfTypeByID("indeliveryamount", Text.class)).clearText();
        ((Image)rowPane.findPaneOfTypeByID("inWarehouseIcon", Image.class)).setVisible(false);
        ((Text)rowPane.findPaneOfTypeByID("inWarehouseAmount", Text.class)).clearText();
        int resourceHashcode = resource.getItemStack().func_77942_o() ? resource.getItemStack().func_77978_p().hashCode() : 0;
        int warehouseAmount = this.warehouseSnapshot.getOrDefault(resource.getItem().func_77658_a() + "-" + resourceHashcode, 0);
        if (resource.getAmountInDelivery() > 0) {
            ((Image)rowPane.findPaneOfTypeByID("indeliveryicon", Image.class)).setVisible(true);
            ((Text)rowPane.findPaneOfTypeByID("indeliveryamount", Text.class)).setText((IFormattableTextComponent)new StringTextComponent(String.valueOf(resource.getAmountInDelivery())));
        } else if (warehouseAmount > 0) {
            ((Image)rowPane.findPaneOfTypeByID("inWarehouseIcon", Image.class)).setVisible(true);
            ((Text)rowPane.findPaneOfTypeByID("indeliveryamount", Text.class)).setText((IFormattableTextComponent)new StringTextComponent(String.valueOf(warehouseAmount)));
        }
        switch (resource.getAvailabilityStatus()) {
            case DONT_HAVE: {
                resourceLabel.setColors(WindowBuilderResModule.RED);
                resourceMissingLabel.setColors(WindowBuilderResModule.RED);
                neededLabel.setColors(WindowBuilderResModule.RED);
                break;
            }
            case NEED_MORE: {
                resourceLabel.setColors(WindowBuilderResModule.ORANGE);
                resourceMissingLabel.setColors(WindowBuilderResModule.ORANGE);
                neededLabel.setColors(WindowBuilderResModule.ORANGE);
                break;
            }
            case HAVE_ENOUGH: {
                resourceLabel.setColors(WindowBuilderResModule.DARKGREEN);
                resourceMissingLabel.setColors(WindowBuilderResModule.DARKGREEN);
                neededLabel.setColors(WindowBuilderResModule.DARKGREEN);
                break;
            }
            default: {
                resourceLabel.setColors(WindowBuilderResModule.BLACK);
                resourceMissingLabel.setColors(WindowBuilderResModule.BLACK);
                neededLabel.setColors(WindowBuilderResModule.BLACK);
            }
        }
        resourceLabel.setText(resource.getName());
        int missing = resource.getMissingFromPlayer();
        if (missing < 0) {
            resourceMissingLabel.setText(Integer.toString(missing));
        } else {
            resourceMissingLabel.clearText();
        }
        neededLabel.setText(resource.getAvailable() + " / " + resource.getAmount());
        ((Text)rowPane.findPaneOfTypeByID("resourceId", Text.class)).setText(Integer.toString(index));
        ((Text)rowPane.findPaneOfTypeByID("resourceQuantity", Text.class)).setText(Integer.toString(resource.getAmount() - resource.getAvailable()));
        ItemStack stack = new ItemStack((IItemProvider)resource.getItem(), 1);
        stack.func_77982_d(resource.getItemStack().func_77978_p());
        ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(stack);
    }

    public void onUpdate() {
        super.onUpdate();
        this.pullResourcesFromHut();
        ((ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class)).refreshElementPanes();
    }
}

