/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.coremod.colony.jobs.AbstractJobCrafter;
import com.minecolonies.coremod.entity.ai.citizen.netherworker.EntityAIWorkNether;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class JobNetherWorker
extends AbstractJobCrafter<EntityAIWorkNether, JobNetherWorker> {
    private boolean citizenInNether = false;
    private Queue<ItemStack> craftedResults = new LinkedList<ItemStack>();
    private Queue<ItemStack> processedResults = new LinkedList<ItemStack>();
    private final String TAG_IN_NETHER = "inNether";
    private final String TAG_CRAFTED = "craftedResults";
    private final String TAG_PROCESSED = "processedResults";

    public JobNetherWorker(ICitizenData entity) {
        super(entity);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        @NotNull ListNBT craftedList = new ListNBT();
        this.craftedResults.forEach(item -> {
            @NotNull CompoundNBT itemCompound = item.serializeNBT();
            craftedList.add((Object)itemCompound);
        });
        compound.func_218657_a("craftedResults", (INBT)craftedList);
        @NotNull ListNBT processedList = new ListNBT();
        this.processedResults.forEach(item -> {
            @NotNull CompoundNBT itemCompound = item.serializeNBT();
            processedList.add((Object)itemCompound);
        });
        compound.func_218657_a("processedResults", (INBT)processedList);
        compound.func_74757_a("inNether", this.citizenInNether);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        ListNBT craftedList = compound.func_150295_c("craftedResults", 10);
        for (int i = 0; i < craftedList.size(); ++i) {
            CompoundNBT itemCompound = craftedList.func_150305_b(i);
            this.craftedResults.add(ItemStack.func_199557_a((CompoundNBT)itemCompound));
        }
        ListNBT processedList = compound.func_150295_c("processedResults", 10);
        for (int i = 0; i < processedList.size(); ++i) {
            CompoundNBT itemCompound = processedList.func_150305_b(i);
            this.processedResults.add(ItemStack.func_199557_a((CompoundNBT)itemCompound));
        }
        if (compound.func_74764_b("inNether")) {
            this.citizenInNether = compound.func_74767_n("inNether");
        }
    }

    @Override
    public EntityAIWorkNether generateAI() {
        return new EntityAIWorkNether(this);
    }

    @Override
    @NotNull
    public ResourceLocation getModel() {
        return ModModelTypes.NETHERWORKER_ID;
    }

    @Override
    public int getDiseaseModifier() {
        if (this.getCitizen().getEntity().isPresent() && this.getCitizen().getEntity().get().func_82150_aj()) {
            return 0;
        }
        return super.getDiseaseModifier();
    }

    @Override
    public int getIdleSeverity(boolean isDemand) {
        if (isDemand) {
            return super.getIdleSeverity(isDemand);
        }
        return 4;
    }

    public void setInNether(boolean away) {
        this.citizenInNether = away;
    }

    public boolean isInNether() {
        return this.citizenInNether;
    }

    public Queue<ItemStack> getCraftedResults() {
        return this.craftedResults;
    }

    public boolean addCraftedResultsList(Collection<ItemStack> newResults) {
        return this.craftedResults.addAll(newResults);
    }

    public Queue<ItemStack> getProcessedResults() {
        return this.processedResults;
    }

    public boolean addProcessedResultsList(Collection<ItemStack> newResults) {
        return this.processedResults.addAll(newResults);
    }
}

