/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.herders;

import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingChickenHerder;
import com.minecolonies.coremod.colony.jobs.JobChickenHerder;
import com.minecolonies.coremod.entity.ai.citizen.herders.AbstractEntityAIHerder;
import com.minecolonies.coremod.util.NamedDamageSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIWorkChickenHerder
extends AbstractEntityAIHerder<JobChickenHerder, BuildingChickenHerder, ChickenEntity> {
    private static final int MAX_ANIMALS_PER_LEVEL = 2;
    private static final VisibleCitizenStatus FIND_CHICKEN = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/chickenherder.png"), "com.minecolonies.gui.visiblestatus.chickenherder");

    public EntityAIWorkChickenHerder(@NotNull JobChickenHerder job) {
        super(job);
    }

    @Override
    public Class<BuildingChickenHerder> getExpectedBuildingClass() {
        return BuildingChickenHerder.class;
    }

    @Override
    public ItemStack getBreedingItem() {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_151014_N);
        stack.func_190920_e(2);
        return stack;
    }

    @Override
    public int getMaxAnimalMultiplier() {
        return 2;
    }

    @Override
    public Class<ChickenEntity> getAnimalClass() {
        return ChickenEntity.class;
    }

    @Override
    protected IAIState breedAnimals() {
        this.worker.getCitizenData().setVisibleStatus(FIND_CHICKEN);
        return super.breedAnimals();
    }

    @Override
    protected IAIState butcherAnimals() {
        this.worker.getCitizenData().setVisibleStatus(FIND_CHICKEN);
        return super.butcherAnimals();
    }

    @Override
    protected void butcherAnimal(@Nullable AnimalEntity animal) {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.herder.butchering")});
        if (animal != null && !this.walkingToAnimal(animal) && !ItemStackUtils.isEmpty(this.worker.func_184614_ca()).booleanValue()) {
            this.worker.func_184609_a(Hand.MAIN_HAND);
            if (this.worker.func_70681_au().nextInt(1 + (100 - this.getSecondarySkillLevel()) / 5) <= 1) {
                animal.func_70097_a((DamageSource)new NamedDamageSource(this.worker.func_200200_C_().getString(), (Entity)this.worker), (float)this.getButcheringAttackDamage());
                this.worker.getCitizenItemHandler().damageItemInHand(Hand.MAIN_HAND, 1);
            }
        }
    }
}

