/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.entity.ai.citizen.miner;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.entity.pathfinding.SurfaceType;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Vec2i;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.coremod.colony.buildings.modules.MinerLevelManagementModule;
import com.minecolonies.coremod.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.coremod.colony.interactionhandling.StandardInteraction;
import com.minecolonies.coremod.colony.jobs.JobMiner;
import com.minecolonies.coremod.colony.workorders.WorkOrderMiner;
import com.minecolonies.coremod.entity.ai.basic.AbstractEntityAIStructureWithWorkOrder;
import com.minecolonies.coremod.entity.ai.citizen.miner.Level;
import com.minecolonies.coremod.entity.ai.citizen.miner.Node;
import com.minecolonies.coremod.entity.ai.util.BuildingStructureHandler;
import com.minecolonies.coremod.util.AdvancementUtils;
import com.minecolonies.coremod.util.WorkerUtil;
import java.util.List;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityAIStructureMiner
extends AbstractEntityAIStructureWithWorkOrder<JobMiner, BuildingMiner> {
    private static final int OTHER_SIDE_OF_SHAFT = 6;
    private static final int COBBLE_REQUEST_BATCHES = 32;
    private static final int LADDER_REQUEST_BATCHES = 10;
    private static final String RENDER_META_TORCH = "torch";
    private static final String RENDER_META_STONE = "stone";
    private static final int NODE_DISTANCE = 7;
    private static final int MAX_BLOCKS_MINED = 64;
    public static final int SHAFT_RADIUS = 3;
    private static final int SAFE_CHECK_RANGE = 5;
    private static final int SHAFT_BASE_DEPTH = 8;
    private static final int ROTATE_ONCE = 1;
    private static final int ROTATE_TWICE = 2;
    private static final int ROTATE_THREE_TIMES = 3;
    private static final int ROTATE_FOUR_TIMES = 4;
    private static final int LIQUID_CHECK_RANGE = 5;
    private static final VisibleCitizenStatus MINING = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/miner.png"), "com.minecolonies.gui.visiblestatus.miner");
    @Nullable
    private BlockPos minerWorkingLocation;
    @Nullable
    private BlockPos currentStandingPosition;
    @Nullable
    private Node workingNode = null;

    public EntityAIStructureMiner(@NotNull JobMiner job) {
        super(job);
        super.registerTargets(new AITarget((IAIState)AIWorkerState.IDLE, AIWorkerState.START_WORKING, 1), new AITarget((IAIState)AIWorkerState.START_WORKING, this::startWorkingAtOwnBuilding, 20), new AITarget((IAIState)AIWorkerState.PREPARING, AIWorkerState.MINER_CHECK_MINESHAFT, 1), new AITarget((IAIState)AIWorkerState.MINER_WALKING_TO_LADDER, this::goToLadder, 20), new AITarget((IAIState)AIWorkerState.MINER_REPAIRING_LADDER, this::repairLadder, 5), new AITarget((IAIState)AIWorkerState.MINER_CHECK_MINESHAFT, this::checkMineShaft, 20), new AITarget((IAIState)AIWorkerState.MINER_MINING_SHAFT, this::doShaftMining, 5), new AITarget((IAIState)AIWorkerState.MINER_BUILDING_SHAFT, this::doShaftBuilding, 5), new AITarget((IAIState)AIWorkerState.MINER_MINING_NODE, this::executeNodeMining, 5));
        this.worker.func_98053_h(true);
    }

    @Override
    public Class<BuildingMiner> getExpectedBuildingClass() {
        return BuildingMiner.class;
    }

    @NotNull
    private IAIState startWorkingAtOwnBuilding() {
        List<WorkOrderMiner> list;
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if ((((BuildingMiner)this.building).getLadderLocation() == null || this.worker.func_226278_cu_() >= (double)((BuildingMiner)this.building).getPosition().func_177956_o()) && this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((BuildingMiner)this.building).getLadderLocation() == null || ((BuildingMiner)this.building).getCobbleLocation() == null) {
            this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("entity.miner.invalidmineshaft"), ChatPriority.BLOCKING));
            return AIWorkerState.START_WORKING;
        }
        if (!((JobMiner)this.job).hasWorkOrder() && !(list = ((BuildingMiner)this.building).getColony().getWorkManager().getOrderedList(WorkOrderMiner.class, ((BuildingMiner)this.building).getPosition())).isEmpty()) {
            ((JobMiner)this.job).setWorkOrder(list.get(0));
            return AIWorkerState.LOAD_STRUCTURE;
        }
        return AIWorkerState.PREPARING;
    }

    @Override
    public int getBreakSpeedLevel() {
        return this.getPrimarySkillLevel();
    }

    @Override
    public int getPlaceSpeedLevel() {
        return this.getSecondarySkillLevel();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return ((BuildingMiner)this.building).getBuildingLevel() * 64;
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.getRenderMetaStone() + this.getRenderMetaTorch());
    }

    @NotNull
    private String getRenderMetaTorch() {
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(Items.field_221657_bQ)) {
            return RENDER_META_TORCH;
        }
        return "";
    }

    @NotNull
    private String getRenderMetaStone() {
        if (this.worker.getCitizenInventoryHandler().hasItemInInventory(this.getMainFillBlock())) {
            return RENDER_META_STONE;
        }
        return "";
    }

    @Override
    public IAIState doMining() {
        if (this.blockToMine == null) {
            return AIWorkerState.BUILDING_STEP;
        }
        for (Direction direction : Direction.values()) {
            BlockPos pos = this.blockToMine.func_177972_a(direction);
            BlockState surroundingState = this.world.func_180495_p(pos);
            FluidState fluid = this.world.func_204610_c(pos);
            if (surroundingState.func_177230_c() != Blocks.field_150353_l && (fluid == null || fluid.func_206888_e() || fluid.func_206886_c() != Fluids.field_204547_b && fluid.func_206886_c() != Fluids.field_207213_d) && !SurfaceType.isWater((IBlockReader)this.world, pos, surroundingState, fluid)) continue;
            this.setBlockFromInventory(pos, this.getMainFillBlock());
        }
        BlockState blockState = this.world.func_180495_p(this.blockToMine);
        if (!IColonyManager.getInstance().getCompatibilityManager().isOre(blockState)) {
            this.blockToMine = this.getSurroundingOreOrDefault(this.blockToMine);
        }
        if (this.world.func_180495_p(this.blockToMine).func_177230_c() instanceof AirBlock) {
            return AIWorkerState.BUILDING_STEP;
        }
        if (!this.mineBlock(this.blockToMine, this.getCurrentWorkingPosition())) {
            this.worker.func_184609_a(Hand.MAIN_HAND);
            return this.getState();
        }
        this.blockToMine = this.getSurroundingOreOrDefault(this.blockToMine);
        if (IColonyManager.getInstance().getCompatibilityManager().isOre(this.world.func_180495_p(this.blockToMine))) {
            return this.getState();
        }
        this.worker.decreaseSaturationForContinuousAction();
        return AIWorkerState.BUILDING_STEP;
    }

    private BlockPos getSurroundingOreOrDefault(BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockPos offset = pos.func_177972_a(direction);
            if (!IColonyManager.getInstance().getCompatibilityManager().isOre(this.world.func_180495_p(offset))) continue;
            return offset;
        }
        return pos;
    }

    @NotNull
    private IAIState goToLadder() {
        if (this.walkToLadder()) {
            return AIWorkerState.MINER_WALKING_TO_LADDER;
        }
        return AIWorkerState.MINER_REPAIRING_LADDER;
    }

    private boolean walkToLadder() {
        return this.walkToBlock(((BuildingMiner)this.building).getLadderLocation());
    }

    @NotNull
    private IAIState repairLadder() {
        @NotNull BlockPos nextCobble = new BlockPos(((BuildingMiner)this.building).getCobbleLocation().func_177958_n(), WorkerUtil.getLastLadder(((BuildingMiner)this.building).getLadderLocation(), this.world) - 1, ((BuildingMiner)this.building).getCobbleLocation().func_177952_p());
        @NotNull BlockPos nextLadder = new BlockPos(((BuildingMiner)this.building).getLadderLocation().func_177958_n(), WorkerUtil.getLastLadder(((BuildingMiner)this.building).getLadderLocation(), this.world) - 1, ((BuildingMiner)this.building).getLadderLocation().func_177952_p());
        @NotNull BlockPos safeStand = new BlockPos(((BuildingMiner)this.building).getLadderLocation().func_177958_n(), WorkerUtil.getLastLadder(((BuildingMiner)this.building).getLadderLocation(), this.world), ((BuildingMiner)this.building).getLadderLocation().func_177952_p());
        if (!this.world.func_180495_p(nextCobble).func_200132_m()) {
            if (!this.checkIfRequestForItemExistOrCreate(new ItemStack((IItemProvider)this.getSolidSubstitution(nextCobble).func_177230_c()), 32, 1)) {
                return this.getState();
            }
            if (!this.world.func_180495_p(nextCobble).isAir((IBlockReader)this.world, nextCobble) && !this.mineBlock(nextCobble, safeStand)) {
                return this.getState();
            }
            this.setBlockFromInventory(nextCobble, this.getLadderBackFillBlock());
            return this.getState();
        }
        if (!this.world.func_180495_p(nextLadder).isLadder((IWorldReader)this.world, nextLadder, (LivingEntity)this.worker) && !this.world.func_180495_p(nextLadder).func_200132_m()) {
            if (!this.checkIfRequestForItemExistOrCreate(new ItemStack((IItemProvider)Blocks.field_150468_ap), 10, 1)) {
                return this.getState();
            }
            if (!this.world.func_180495_p(nextLadder).isAir((IBlockReader)this.world, nextLadder) && !this.mineBlock(nextLadder, safeStand)) {
                return this.getState();
            }
            BlockState metadata = (BlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)Direction.func_176737_a((float)(nextLadder.func_177958_n() - nextCobble.func_177958_n()), (float)0.0f, (float)(nextLadder.func_177952_p() - nextCobble.func_177952_p())));
            this.setBlockFromInventory(nextLadder, Blocks.field_150468_ap, metadata);
            return this.getState();
        }
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    private Block getMainFillBlock() {
        return ((BuildingMiner)this.building).getSetting(BuildingMiner.FILL_BLOCK).getValue().func_179223_d();
    }

    private Block getLadderBackFillBlock() {
        if (WorldUtil.isNetherType(this.world)) {
            return Blocks.field_150424_aL;
        }
        return Blocks.field_150347_e;
    }

    @NotNull
    private IAIState checkMineShaft() {
        BuildingMiner buildingMiner = (BuildingMiner)this.building;
        if (WorkerUtil.getLastLadder(buildingMiner.getLadderLocation(), this.world) < 8) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(((JobMiner)this.job).getColony(), AdvancementTriggers.DEEP_MINE::trigger);
        }
        if (WorkerUtil.getLastLadder(buildingMiner.getLadderLocation(), this.world) < buildingMiner.getDepthLimit()) {
            if (buildingMiner.getFirstModuleOccurance(MinerLevelManagementModule.class).getNumberOfLevels() == 0) {
                this.worker.getCitizenData().triggerInteraction(new StandardInteraction((ITextComponent)new TranslationTextComponent("entity.miner.messagerequiresbetterhut"), ChatPriority.BLOCKING));
                return AIWorkerState.IDLE;
            }
            this.worker.getCitizenData().setVisibleStatus(MINING);
            return AIWorkerState.MINER_MINING_NODE;
        }
        this.worker.getCitizenData().setVisibleStatus(MINING);
        return AIWorkerState.MINER_MINING_SHAFT;
    }

    @Override
    public ItemStack getTotalAmount(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return null;
        }
        ItemStack copy = stack.func_77946_l();
        copy.func_190920_e(Math.max(super.getTotalAmount(stack).func_190916_E(), copy.func_77976_d() / 2));
        return copy;
    }

    private IAIState doShaftMining() {
        this.worker.getCitizenStatusHandler().setLatestStatus(new ITextComponent[]{new TranslationTextComponent("com.minecolonies.coremod.status.mining")});
        this.minerWorkingLocation = this.getNextBlockInShaftToMine();
        if (this.minerWorkingLocation == null) {
            return this.advanceLadder(AIWorkerState.MINER_MINING_SHAFT);
        }
        if (this.mineBlock(this.minerWorkingLocation, this.currentStandingPosition)) {
            this.worker.decreaseSaturationForContinuousAction();
        }
        return AIWorkerState.MINER_MINING_SHAFT;
    }

    private IAIState advanceLadder(IAIState state) {
        if (!this.checkIfRequestForItemExistOrCreate(new ItemStack((IItemProvider)this.getLadderBackFillBlock()), 32, 1) || !this.checkIfRequestForItemExistOrCreate(new ItemStack((IItemProvider)Blocks.field_150468_ap), 10, 1)) {
            return state;
        }
        if (this.ladderDamaged()) {
            return AIWorkerState.MINER_REPAIRING_LADDER;
        }
        BlockPos vector = ((BuildingMiner)this.building).getLadderLocation().func_177973_b((Vector3i)((BuildingMiner)this.building).getCobbleLocation());
        int xOffset = 3 * vector.func_177958_n();
        int zOffset = 3 * vector.func_177952_p();
        @NotNull BlockPos nextLadder = new BlockPos(((BuildingMiner)this.building).getLadderLocation().func_177958_n(), WorkerUtil.getLastLadder(((BuildingMiner)this.building).getLadderLocation(), this.world) - 1, ((BuildingMiner)this.building).getLadderLocation().func_177952_p());
        @NotNull BlockPos safeCobble = new BlockPos(((BuildingMiner)this.building).getLadderLocation().func_177958_n(), WorkerUtil.getLastLadder(((BuildingMiner)this.building).getLadderLocation(), this.world) - 2, ((BuildingMiner)this.building).getLadderLocation().func_177952_p());
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                @NotNull BlockPos curBlock = new BlockPos(safeCobble.func_177958_n() + x + xOffset, safeCobble.func_177956_o(), safeCobble.func_177952_p() + z + zOffset);
                if (this.secureBlock(curBlock, this.currentStandingPosition)) continue;
                return state;
            }
        }
        @NotNull BlockPos safeStand = new BlockPos(((BuildingMiner)this.building).getLadderLocation().func_177958_n(), WorkerUtil.getLastLadder(((BuildingMiner)this.building).getLadderLocation(), this.world), ((BuildingMiner)this.building).getLadderLocation().func_177952_p());
        @NotNull BlockPos nextCobble = new BlockPos(((BuildingMiner)this.building).getCobbleLocation().func_177958_n(), WorkerUtil.getLastLadder(((BuildingMiner)this.building).getLadderLocation(), this.world) - 1, ((BuildingMiner)this.building).getCobbleLocation().func_177952_p());
        MinerLevelManagementModule module = ((BuildingMiner)this.building).getFirstModuleOccurance(MinerLevelManagementModule.class);
        if (module.getStartingLevelShaft() == 0) {
            module.setStartingLevelShaft(nextCobble.func_177956_o() - 4);
        }
        if (nextCobble.func_177956_o() < module.getStartingLevelShaft()) {
            return AIWorkerState.MINER_BUILDING_SHAFT;
        }
        if (!this.mineBlock(nextCobble, safeStand) && !this.world.func_180495_p(nextCobble).func_185904_a().func_76222_j() || !this.mineBlock(nextLadder, safeStand) && !this.world.func_180495_p(nextLadder).func_185904_a().func_76222_j()) {
            return state;
        }
        BlockState metadata = this.getBlockState(safeStand);
        this.setBlockFromInventory(nextCobble, this.getLadderBackFillBlock());
        this.setBlockFromInventory(nextLadder, Blocks.field_150468_ap, metadata);
        this.incrementActionsDoneAndDecSaturation();
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    private BlockState getBlockState(@NotNull BlockPos pos) {
        return this.world.func_180495_p(pos);
    }

    @Nullable
    private BlockPos getNextBlockInShaftToMine() {
        double distance;
        BlockPos curBlock;
        int z;
        int x;
        Block block;
        BlockPos ladderPos = ((BuildingMiner)this.building).getLadderLocation();
        int lastLadder = WorkerUtil.getLastLadder(ladderPos, this.world);
        if (this.minerWorkingLocation == null) {
            this.minerWorkingLocation = new BlockPos(ladderPos.func_177958_n(), lastLadder + 1, ladderPos.func_177952_p());
        }
        if (!((block = this.getBlock(this.minerWorkingLocation)) instanceof AirBlock || block == Blocks.field_150468_ap || block.equals(Blocks.field_150355_j) || block.equals(Blocks.field_150353_l))) {
            if (this.currentStandingPosition == null) {
                this.currentStandingPosition = this.minerWorkingLocation;
            }
            return this.minerWorkingLocation;
        }
        this.currentStandingPosition = this.minerWorkingLocation;
        BlockPos nextBlockToMine = null;
        double bestDistance = Double.MAX_VALUE;
        BlockPos vector = ((BuildingMiner)this.building).getLadderLocation().func_177973_b((Vector3i)((BuildingMiner)this.building).getCobbleLocation());
        int xOffset = 3 * vector.func_177958_n();
        int zOffset = 3 * vector.func_177952_p();
        for (x = 3 + xOffset + 2; x >= -3 + xOffset - 2; --x) {
            for (z = -3 + zOffset - 2; z <= 3 + zOffset + 2; ++z) {
                if (x == 0 && 0 == z || !(block = this.getBlock(curBlock = new BlockPos(ladderPos.func_177958_n() + x, lastLadder, ladderPos.func_177952_p() + z))).equals(Blocks.field_150355_j) && !block.equals(Blocks.field_150353_l)) continue;
                this.setBlockFromInventory(curBlock, this.getMainFillBlock());
            }
        }
        for (x = 3 + xOffset; x >= -3 + xOffset; --x) {
            for (z = -3 + zOffset; z <= 3 + zOffset; ++z) {
                if (x == 0 && 0 == z) continue;
                curBlock = new BlockPos(ladderPos.func_177958_n() + x, lastLadder, ladderPos.func_177952_p() + z);
                distance = curBlock.func_177951_i((Vector3i)ladderPos) + Math.pow(curBlock.func_177951_i((Vector3i)this.minerWorkingLocation), 2.0);
                block = this.getBlock(curBlock);
                if (!(distance < bestDistance) || this.world.func_175623_d(curBlock)) continue;
                if (block.equals(Blocks.field_150355_j) || block.equals(Blocks.field_150353_l)) {
                    this.setBlockFromInventory(curBlock, this.getMainFillBlock());
                }
                nextBlockToMine = curBlock;
                bestDistance = distance;
            }
        }
        bestDistance = Double.MAX_VALUE;
        if (nextBlockToMine != null) {
            for (x = 1; x >= -1; --x) {
                for (z = -1; z <= 1; ++z) {
                    if (x == 0 && 0 == z || !((distance = (curBlock = new BlockPos(nextBlockToMine.func_177958_n() + x, lastLadder, nextBlockToMine.func_177952_p() + z)).func_177951_i((Vector3i)ladderPos)) < bestDistance) || !this.world.func_175623_d(curBlock)) continue;
                    this.currentStandingPosition = curBlock;
                    bestDistance = distance;
                }
            }
        }
        return nextBlockToMine;
    }

    @NotNull
    private IAIState doShaftBuilding() {
        if (this.walkToBuilding()) {
            return AIWorkerState.MINER_BUILDING_SHAFT;
        }
        BlockPos ladderPos = ((BuildingMiner)this.building).getLadderLocation();
        int lastLadder = WorkerUtil.getLastLadder(ladderPos, this.world) + 1;
        BlockPos vector = ladderPos.func_177973_b((Vector3i)((BuildingMiner)this.building).getCobbleLocation());
        int xOffset = 3 * vector.func_177958_n();
        int zOffset = 3 * vector.func_177952_p();
        BuildingMiner.initStructure(null, 0, new BlockPos(ladderPos.func_177958_n() + xOffset, lastLadder + 1, ladderPos.func_177952_p() + zOffset), (BuildingMiner)this.building, this.world, (JobMiner)this.job);
        return AIWorkerState.LOAD_STRUCTURE;
    }

    @NotNull
    private IAIState executeNodeMining() {
        MinerLevelManagementModule module = ((BuildingMiner)this.building).getFirstModuleOccurance(MinerLevelManagementModule.class);
        @Nullable Level currentLevel = module.getCurrentLevel();
        if (currentLevel == null) {
            Log.getLogger().warn("Current Level not set, resetting...");
            module.setCurrentLevel(module.getNumberOfLevels() - 1);
            return this.executeNodeMining();
        }
        return this.searchANodeToMine(currentLevel);
    }

    private IAIState searchANodeToMine(@NotNull Level currentLevel) {
        BlockPos standingPosition;
        Node parentNode;
        int vectorZ;
        BuildingMiner buildingMiner = (BuildingMiner)this.building;
        if (buildingMiner == null) {
            return AIWorkerState.IDLE;
        }
        MinerLevelManagementModule module = ((BuildingMiner)this.building).getFirstModuleOccurance(MinerLevelManagementModule.class);
        if (this.workingNode == null || this.workingNode.getStatus() == Node.NodeStatus.COMPLETED) {
            int levelId;
            this.workingNode = module.getActiveNode();
            module.setActiveNode(this.workingNode);
            if (this.workingNode == null && (levelId = module.getLevelId(currentLevel)) > 0) {
                module.setCurrentLevel(levelId - 1);
            }
            return AIWorkerState.MINER_CHECK_MINESHAFT;
        }
        int rotation = 0;
        int workingNodeX = this.workingNode.getX() > this.workingNode.getParent().getX() ? 1 : 0;
        int workingNodeZ = this.workingNode.getZ() > this.workingNode.getParent().getZ() ? 1 : 0;
        int vectorX = this.workingNode.getX() < this.workingNode.getParent().getX() ? -1 : workingNodeX;
        int n = vectorZ = this.workingNode.getZ() < this.workingNode.getParent().getZ() ? -1 : workingNodeZ;
        if (vectorX == -1) {
            rotation = 2;
        } else if (vectorZ == -1) {
            rotation = 3;
        } else if (vectorZ == 1) {
            rotation = 1;
        }
        if (this.workingNode.getRot().isPresent() && this.workingNode.getRot().get() != rotation) {
            Log.getLogger().warn("Calculated rotation doesn't match recorded: x:" + workingNodeX + " z:" + workingNodeZ);
        }
        if ((parentNode = currentLevel.getNode(this.workingNode.getParent())) != null && parentNode.getStyle() != Node.NodeType.SHAFT && parentNode.getStatus() != Node.NodeStatus.COMPLETED) {
            this.workingNode = parentNode;
            this.workingNode.setStatus(Node.NodeStatus.AVAILABLE);
            module.setActiveNode(parentNode);
            buildingMiner.markDirty();
            return AIWorkerState.MINER_CHECK_MINESHAFT;
        }
        this.currentStandingPosition = standingPosition = new BlockPos(this.workingNode.getParent().getX(), currentLevel.getDepth(), this.workingNode.getParent().getZ());
        if (this.workingNode != null && currentLevel.getNode(new Vec2i(this.workingNode.getX(), this.workingNode.getZ())) == null) {
            module.setActiveNode(null);
            module.setOldNode(null);
            return AIWorkerState.MINER_MINING_SHAFT;
        }
        if (!(this.workingNode.getStatus() != Node.NodeStatus.AVAILABLE && this.workingNode.getStatus() != Node.NodeStatus.IN_PROGRESS || this.walkToBlock(standingPosition))) {
            this.workingNode.setRot(rotation);
            return this.executeStructurePlacement(this.workingNode, standingPosition, rotation);
        }
        return AIWorkerState.MINER_CHECK_MINESHAFT;
    }

    private boolean secureBlock(@NotNull BlockPos curBlock, @NotNull BlockPos safeStand) {
        if (!this.getBlockState(curBlock).func_185904_a().func_76230_c() && this.getBlock(curBlock) != Blocks.field_150478_aa || IColonyManager.getInstance().getCompatibilityManager().isOre(this.world.func_180495_p(curBlock))) {
            if (!this.mineBlock(curBlock, safeStand)) {
                this.setDelay(1);
                return false;
            }
            if (!this.checkIfRequestForItemExistOrCreate(new ItemStack((IItemProvider)this.getMainFillBlock()), 32, 1)) {
                return false;
            }
            this.setBlockFromInventory(curBlock, this.getMainFillBlock());
            return false;
        }
        return true;
    }

    private IAIState executeStructurePlacement(@NotNull Node mineNode, @NotNull BlockPos standingPosition, int rotation) {
        mineNode.setStatus(Node.NodeStatus.IN_PROGRESS);
        ((BuildingMiner)this.building).markDirty();
        if (((JobMiner)this.job).getBlueprint() == null) {
            BuildingMiner.initStructure(mineNode, rotation, new BlockPos(mineNode.getX(), ((BuildingMiner)this.building).getFirstModuleOccurance(MinerLevelManagementModule.class).getCurrentLevel().getDepth(), mineNode.getZ()), (BuildingMiner)this.building, this.world, (JobMiner)this.job);
            return AIWorkerState.LOAD_STRUCTURE;
        }
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                for (int y = -1; y <= 5; ++y) {
                    @NotNull BlockPos curBlock = new BlockPos(mineNode.getX() + x, standingPosition.func_177956_o() + y, mineNode.getZ() + z);
                    Block block = this.getBlock(curBlock);
                    if (!block.equals(Blocks.field_150355_j) && !block.equals(Blocks.field_150353_l)) continue;
                    this.setBlockFromInventory(curBlock, this.getMainFillBlock());
                }
            }
        }
        this.workingNode = null;
        if (((JobMiner)this.job).getBlueprint() != null) {
            return AIWorkerState.LOAD_STRUCTURE;
        }
        return AIWorkerState.MINER_MINING_NODE;
    }

    @Override
    public IAIState afterStructureLoading() {
        return AIWorkerState.BUILDING_STEP;
    }

    private void setBlockFromInventory(@NotNull BlockPos location, @NotNull Block block) {
        this.worker.func_184609_a(this.worker.func_184600_cs());
        this.setBlockFromInventory(location, block, block.func_176223_P());
    }

    private void setBlockFromInventory(@NotNull BlockPos location, Block block, BlockState metadata) {
        int slot = block instanceof LadderBlock ? this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(block) : this.worker.getCitizenInventoryHandler().findFirstSlotInInventoryWith(block);
        if (slot != -1) {
            this.getInventory().extractItem(slot, 1, false);
            WorldUtil.setBlockState((IWorld)this.world, location, metadata);
        }
    }

    private Block getBlock(@NotNull BlockPos loc) {
        return this.world.func_180495_p(loc).func_177230_c();
    }

    private int getFirstLadder(@NotNull BlockPos pos) {
        while (this.world.func_180495_p(pos).isLadder((IWorldReader)this.world, pos, (LivingEntity)this.worker)) {
            pos = pos.func_177984_a();
        }
        return pos.func_177956_o() - 1;
    }

    @Override
    public void executeSpecificCompleteActions() {
        BuildingMiner minerBuilding = (BuildingMiner)this.building;
        MinerLevelManagementModule module = ((BuildingMiner)this.building).getFirstModuleOccurance(MinerLevelManagementModule.class);
        if (((JobMiner)this.job).getBlueprint() != null) {
            if (((JobMiner)this.job).getBlueprint().getName().contains("minermainshaft")) {
                int depth = ((JobMiner)this.job).getWorkOrder().getLocation().func_177956_o();
                boolean exists = false;
                for (Level level : module.getLevels()) {
                    if (level.getDepth() != depth) continue;
                    exists = true;
                    break;
                }
                @Nullable BlockPos levelSignPos = WorkerUtil.findFirstLevelSign(((JobMiner)this.job).getBlueprint(), ((JobMiner)this.job).getWorkOrder().getLocation());
                @NotNull Level currentLevel = new Level(minerBuilding, ((JobMiner)this.job).getWorkOrder().getLocation().func_177956_o(), levelSignPos);
                if (!exists) {
                    module.addLevel(currentLevel);
                    module.setCurrentLevel(module.getNumberOfLevels());
                }
                WorkerUtil.updateLevelSign(this.world, currentLevel, module.getLevelId(currentLevel));
            } else {
                Level currentLevel = module.getCurrentLevel();
                currentLevel.closeNextNode(((BuildingStructureHandler)((Object)this.structurePlacer.getB())).getSettings().rotation.ordinal(), module.getActiveNode(), this.world);
                module.setActiveNode(null);
                module.setOldNode(this.workingNode);
                WorkerUtil.updateLevelSign(this.world, currentLevel, module.getLevelId(currentLevel));
            }
        }
        super.executeSpecificCompleteActions();
        ((BuildingMiner)this.building).markDirty();
        ((JobMiner)this.job).setBlueprint(null);
    }

    @Override
    public BlockPos getWorkingPosition(BlockPos targetPosition) {
        return this.getNodeMiningPosition(targetPosition);
    }

    private BlockPos getNodeMiningPosition(BlockPos blockToMine) {
        BuildingMiner buildingMiner = (BuildingMiner)this.building;
        MinerLevelManagementModule module = buildingMiner.getFirstModuleOccurance(MinerLevelManagementModule.class);
        if (module.getCurrentLevel() == null || module.getActiveNode() == null) {
            return blockToMine;
        }
        Vec2i parentPos = module.getActiveNode().getParent();
        BlockPos vector = ((BuildingMiner)this.building).getLadderLocation().func_177973_b((Vector3i)((BuildingMiner)this.building).getCobbleLocation());
        if (parentPos != null && module.getCurrentLevel().getNode(parentPos) != null && module.getCurrentLevel().getNode(parentPos).getStyle() == Node.NodeType.SHAFT) {
            BlockPos ladderPos = buildingMiner.getLadderLocation();
            return new BlockPos(ladderPos.func_177958_n() + vector.func_177958_n() * 6, module.getCurrentLevel().getDepth(), ladderPos.func_177952_p() + vector.func_177952_p() * 6);
        }
        Vec2i pos = module.getActiveNode().getParent();
        return new BlockPos(pos.getX(), module.getCurrentLevel().getDepth(), pos.getZ());
    }

    @Override
    public boolean shallReplaceSolidSubstitutionBlock(Block worldBlock, BlockState worldMetadata) {
        return IColonyManager.getInstance().getCompatibilityManager().isOre(worldMetadata);
    }

    @Override
    protected void triggerMinedBlock(@NotNull BlockState blockToMine) {
        super.triggerMinedBlock(blockToMine);
        double chance = 1.0 + this.worker.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MORE_ORES);
        if (IColonyManager.getInstance().getCompatibilityManager().isLuckyBlock(blockToMine.func_177230_c())) {
            InventoryUtils.transferItemStackIntoNextBestSlotInItemHandler(IColonyManager.getInstance().getCompatibilityManager().getRandomLuckyOre(chance), (IItemHandler)this.worker.getInventoryCitizen());
        }
    }

    @Override
    public BlockState getSolidSubstitution(BlockPos ignored) {
        return this.getMainFillBlock().func_176223_P();
    }

    @Override
    protected boolean checkIfCanceled() {
        if (((JobMiner)this.job).getWorkOrder() == null && ((JobMiner)this.job).getBlueprint() != null || this.structurePlacer != null && !((BuildingStructureHandler)((Object)this.structurePlacer.getB())).hasBluePrint() || ((JobMiner)this.job).getWorkOrder() != null && ((JobMiner)this.job).getWorkOrder().getStructureName().contains("quarry")) {
            ((JobMiner)this.job).setBlueprint(null);
            if (((JobMiner)this.job).hasWorkOrder()) {
                ((JobMiner)this.job).getColony().getWorkManager().removeWorkOrder(((JobMiner)this.job).getWorkOrderId());
            }
            ((JobMiner)this.job).setWorkOrder(null);
            this.resetCurrentStructure();
            ((BuildingMiner)this.building).cancelAllRequestsOfCitizen(this.worker.getCitizenData());
            ((BuildingMiner)this.building).setProgressPos(null, BuildingStructureHandler.Stage.CLEAR);
            return true;
        }
        if (!this.isThereAStructureToBuild()) {
            switch ((AIWorkerState)this.getState()) {
                case BUILDING_STEP: {
                    return true;
                }
            }
            return false;
        }
        return ((JobMiner)this.job).getWorkOrder() != null && !WorldUtil.isBlockLoaded((IWorld)this.world, ((JobMiner)this.job).getWorkOrder().getLocation()) && this.getState() != AIWorkerState.PICK_UP_RESIDUALS;
    }

    private boolean ladderDamaged() {
        @NotNull BlockPos nextLadder = new BlockPos(((BuildingMiner)this.building).getLadderLocation().func_177958_n(), WorkerUtil.getLastLadder(((BuildingMiner)this.building).getLadderLocation(), this.world) - 1, ((BuildingMiner)this.building).getLadderLocation().func_177952_p());
        return !this.world.func_180495_p(nextLadder).isLadder((IWorldReader)this.world, nextLadder, (LivingEntity)this.worker) && !this.world.func_180495_p(nextLadder).func_200132_m();
    }
}

