/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.event;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.coremod.Network;
import com.minecolonies.coremod.datalistener.CrafterRecipeListener;
import com.minecolonies.coremod.datalistener.CustomVisitorListener;
import com.minecolonies.coremod.datalistener.ResearchListener;
import com.minecolonies.coremod.entity.pathfinding.Pathfinding;
import com.minecolonies.coremod.network.messages.client.ColonyStylesMessage;
import com.minecolonies.coremod.network.messages.client.ServerUUIDMessage;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.world.World;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import org.jetbrains.annotations.NotNull;

public class FMLEventHandler {
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        IColonyManager.getInstance().onServerTick(event);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        IColonyManager.getInstance().onClientTick(event);
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        IColonyManager.getInstance().onWorldTick(event);
    }

    @SubscribeEvent
    public static void onPlayerLogin(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            Network.getNetwork().sendToPlayer(new ServerUUIDMessage(), (ServerPlayerEntity)event.getPlayer());
            Network.getNetwork().sendToPlayer(new ColonyStylesMessage(), (ServerPlayerEntity)event.getPlayer());
            IColonyManager.getInstance().getIColonyByOwner((World)((ServerPlayerEntity)event.getPlayer()).func_71121_q(), event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onAddReloadListenerEvent(@NotNull AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new CrafterRecipeListener(event.getDataPackRegistries()));
        event.addListener((IFutureReloadListener)new ResearchListener());
        event.addListener((IFutureReloadListener)new CustomVisitorListener());
    }

    @SubscribeEvent
    public static void onServerAboutToStart(@NotNull FMLServerAboutToStartEvent event) {
        IColonyManager.getInstance().getRecipeManager().reset();
    }

    public static void onServerStopped(FMLServerStoppingEvent event) {
        Pathfinding.shutdown();
    }
}

