/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.coremod.colony.Colony;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewMessage
implements IMessage {
    private int colonyId;
    private boolean isNewSubscription;
    private PacketBuffer colonyBuffer;
    private RegistryKey<World> dim;

    public ColonyViewMessage() {
    }

    public ColonyViewMessage(@NotNull Colony colony, PacketBuffer buf, boolean isNewSubscription) {
        this.colonyId = colony.getID();
        this.isNewSubscription = isNewSubscription;
        this.dim = colony.getDimension();
        this.colonyBuffer = new PacketBuffer(buf.copy());
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        PacketBuffer newBuf = new PacketBuffer(buf.retain());
        this.colonyId = newBuf.readInt();
        this.isNewSubscription = newBuf.readBoolean();
        this.dim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(newBuf.func_150789_c(Short.MAX_VALUE)));
        this.colonyBuffer = newBuf;
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeInt(this.colonyId);
        buf.writeBoolean(this.isNewSubscription);
        buf.func_180714_a(this.dim.func_240901_a_().toString());
        buf.writeBytes((ByteBuf)this.colonyBuffer);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            IColonyManager.getInstance().handleColonyViewMessage(this.colonyId, this.colonyBuffer, (World)Minecraft.func_71410_x().field_71441_e, this.isNewSubscription, this.dim);
        }
        this.colonyBuffer.release();
    }
}

