/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.client.colony;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.util.Log;
import java.util.Set;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyVisitorViewDataMessage
implements IMessage {
    private int colonyId;
    private RegistryKey<World> dimension;
    private Set<IVisitorData> visitors;
    private PacketBuffer visitorBuf;
    private boolean refresh;

    public ColonyVisitorViewDataMessage() {
    }

    public ColonyVisitorViewDataMessage(@NotNull IColony colony, @NotNull Set<IVisitorData> visitors, boolean refresh) {
        this.colonyId = colony.getID();
        this.dimension = colony.getDimension();
        this.visitors = visitors;
        this.refresh = refresh;
    }

    @Override
    public void fromBytes(@NotNull PacketBuffer buf) {
        this.colonyId = buf.readInt();
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(buf.func_150789_c(Short.MAX_VALUE)));
        this.refresh = buf.readBoolean();
        IColonyView colony = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimension);
        if (colony == null) {
            Log.getLogger().warn("Received visitor data for nonexisting colony:" + this.colonyId + " dim:" + this.dimension);
            return;
        }
        this.visitorBuf = new PacketBuffer(buf.retain());
    }

    @Override
    public void toBytes(@NotNull PacketBuffer buf) {
        buf.writeInt(this.colonyId);
        buf.func_180714_a(this.dimension.func_240901_a_().toString());
        buf.writeBoolean(this.refresh);
        buf.writeInt(this.visitors.size());
        for (IVisitorData data : this.visitors) {
            buf.writeInt(data.getId());
            data.serializeViewNetworkData(buf);
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        IColonyView colony = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimension);
        if (colony == null) {
            Log.getLogger().warn("Received visitor data for nonexisting colony:" + this.colonyId + " dim:" + this.dimension);
            return;
        }
        colony.handleColonyViewVisitorMessage(this.visitorBuf, this.refresh);
        this.visitorBuf.release();
    }
}

