/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.network.IMessage;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class ClickGuiButtonTriggerMessage
implements IMessage {
    private String buttonId;
    private String resource;

    public ClickGuiButtonTriggerMessage() {
    }

    public ClickGuiButtonTriggerMessage(String buttonId, String resource) {
        this.resource = resource;
        this.buttonId = buttonId;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.resource);
        buf.func_180714_a(this.buttonId);
    }

    @Override
    public void fromBytes(PacketBuffer buf) {
        this.resource = buf.func_150789_c(Short.MAX_VALUE);
        this.buttonId = buf.func_150789_c(Short.MAX_VALUE);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        ServerPlayerEntity player = ctxIn.getSender();
        if (player != null) {
            AdvancementTriggers.CLICK_GUI_BUTTON.trigger(player, this.buttonId, this.resource);
        }
    }
}

