/*
 * Decompiled with CFR 0.152.
 */
package appeng.container;

import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.parts.IPart;
import appeng.container.ContainerLocator;
import appeng.container.SlotSemantic;
import appeng.container.guisync.DataSynchronization;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.CraftingMatrixSlot;
import appeng.container.slot.CraftingTermSlot;
import appeng.container.slot.DisabledSlot;
import appeng.container.slot.FakeSlot;
import appeng.container.slot.InaccessibleSlot;
import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.GuiDataSyncPacket;
import appeng.core.sync.packets.InventoryActionPacket;
import appeng.helpers.InventoryAction;
import appeng.me.helpers.PlayerSource;
import appeng.util.Platform;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public abstract class AEBaseContainer
extends Container {
    private final IActionSource mySrc;
    private final TileEntity tileEntity;
    private final IPart part;
    private final IGuiItemObject guiItem;
    private final DataSynchronization dataSync = new DataSynchronization((Object)this);
    private final PlayerInventory playerInventory;
    private final Set<Integer> lockedPlayerInventorySlots = new HashSet<Integer>();
    private final Map<Slot, SlotSemantic> semanticBySlot = new HashMap<Slot, SlotSemantic>();
    private final ArrayListMultimap<SlotSemantic, Slot> slotsBySemantic = ArrayListMultimap.create();
    private final Map<String, ClientAction<?>> clientActions = new HashMap();
    private boolean isContainerValid = true;
    private ContainerLocator locator;
    private int ticksSinceCheck = 900;

    public AEBaseContainer(ContainerType<?> containerType, int id, PlayerInventory playerInventory, Object host) {
        super(containerType, id);
        this.playerInventory = playerInventory;
        this.tileEntity = host instanceof TileEntity ? (TileEntity)host : null;
        this.part = host instanceof IPart ? (IPart)host : null;
        IGuiItemObject iGuiItemObject = this.guiItem = host instanceof IGuiItemObject ? (IGuiItemObject)host : null;
        if (host != null && this.tileEntity == null && this.part == null && this.guiItem == null) {
            throw new IllegalArgumentException("Must have a valid host, instead " + host + " in " + playerInventory);
        }
        this.mySrc = new PlayerSource(playerInventory.field_70458_d, this.getActionHost());
    }

    protected IActionHost getActionHost() {
        if (this.guiItem instanceof IActionHost) {
            return (IActionHost)((Object)this.guiItem);
        }
        if (this.tileEntity instanceof IActionHost) {
            return (IActionHost)this.tileEntity;
        }
        if (this.part instanceof IActionHost) {
            return (IActionHost)((Object)this.part);
        }
        return null;
    }

    public boolean isRemote() {
        return this.playerInventory.field_70458_d.func_130014_f_().func_201670_d();
    }

    public IActionSource getActionSource() {
        return this.mySrc;
    }

    public void verifyPermissions(SecurityPermissions security, boolean requirePower) {
        if (this.isRemote()) {
            return;
        }
        ++this.ticksSinceCheck;
        if (this.ticksSinceCheck < 20) {
            return;
        }
        this.ticksSinceCheck = 0;
        this.setValidContainer(this.isValidContainer() && this.hasAccess(security, requirePower));
    }

    protected boolean hasAccess(SecurityPermissions perm, boolean requirePower) {
        IGrid g;
        IGridNode gn;
        IActionHost host = this.getActionHost();
        if (host != null && (gn = host.getActionableNode()) != null && (g = gn.getGrid()) != null) {
            IEnergyGrid eg;
            if (requirePower && !(eg = (IEnergyGrid)g.getCache(IEnergyGrid.class)).isNetworkPowered()) {
                return false;
            }
            ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
            if (sg.hasPermission(this.getPlayerInventory().field_70458_d, perm)) {
                return true;
            }
        }
        return false;
    }

    public PlayerInventory getPlayerInventory() {
        return this.playerInventory;
    }

    public void lockPlayerInventorySlot(int invSlot) {
        Preconditions.checkArgument((invSlot >= 0 && invSlot < this.playerInventory.field_70462_a.size() ? 1 : 0) != 0, (String)"cannot lock player inventory slot: %s", (int)invSlot);
        this.lockedPlayerInventorySlots.add(invSlot);
    }

    public Object getTarget() {
        if (this.tileEntity != null) {
            return this.tileEntity;
        }
        if (this.part != null) {
            return this.part;
        }
        return this.guiItem;
    }

    public TileEntity getTileEntity() {
        return this.tileEntity;
    }

    protected final void createPlayerInventorySlots(PlayerInventory playerInventory) {
        Preconditions.checkState((boolean)this.getSlots(SlotSemantic.PLAYER_INVENTORY).isEmpty(), (Object)"Player inventory was already created");
        PlayerInvWrapper ih = new PlayerInvWrapper(playerInventory);
        for (int i = 0; i < playerInventory.field_70462_a.size(); ++i) {
            DisabledSlot slot = this.lockedPlayerInventorySlots.contains(i) ? new DisabledSlot((IItemHandler)ih, i) : new Slot((IInventory)playerInventory, i, 0, 0);
            SlotSemantic s = i < PlayerInventory.func_70451_h() ? SlotSemantic.PLAYER_HOTBAR : SlotSemantic.PLAYER_INVENTORY;
            this.addSlot(slot, s);
        }
    }

    protected Slot addSlot(Slot slot, SlotSemantic semantic) {
        Preconditions.checkState((!this.semanticBySlot.containsKey(slot = this.func_75146_a(slot)) ? 1 : 0) != 0);
        this.semanticBySlot.put(slot, semantic);
        this.slotsBySemantic.put((Object)semantic, (Object)slot);
        return slot;
    }

    public List<Slot> getSlots(SlotSemantic semantic) {
        return this.slotsBySemantic.get((Object)semantic);
    }

    protected Slot func_75146_a(Slot newSlot) {
        if (newSlot instanceof AppEngSlot) {
            AppEngSlot s = (AppEngSlot)newSlot;
            s.setContainer(this);
        }
        return super.func_75146_a(newSlot);
    }

    public void func_75142_b() {
        if (this.isServer()) {
            if (this.tileEntity != null && this.tileEntity.func_145831_w().func_175625_s(this.tileEntity.func_174877_v()) != this.tileEntity) {
                this.setValidContainer(false);
            }
            if (this.dataSync.hasChanges()) {
                this.sendPacketToClient(new GuiDataSyncPacket(this.field_75152_c, this.dataSync::writeUpdate));
            }
        }
        super.func_75142_b();
    }

    private boolean isPlayerSideSlot(Slot slot) {
        if (slot.field_75224_c == this.playerInventory) {
            return true;
        }
        SlotSemantic slotSemantic = this.semanticBySlot.get(slot);
        return slotSemantic == SlotSemantic.PLAYER_INVENTORY || slotSemantic == SlotSemantic.PLAYER_HOTBAR || slotSemantic == SlotSemantic.CRAFTING_GRID;
    }

    public ItemStack func_82846_b(PlayerEntity p, int idx) {
        if (this.isRemote()) {
            return ItemStack.field_190927_a;
        }
        Slot clickSlot = (Slot)this.field_75151_b.get(idx);
        boolean playerSide = this.isPlayerSideSlot(clickSlot);
        if (clickSlot instanceof DisabledSlot || clickSlot instanceof InaccessibleSlot) {
            return ItemStack.field_190927_a;
        }
        if (clickSlot.func_75216_d()) {
            ItemStack tis = clickSlot.func_75211_c();
            if (tis.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ArrayList<Slot> selectedSlots = new ArrayList<Slot>();
            if (playerSide) {
                if (!(tis = this.transferStackToContainer(tis)).func_190926_b()) {
                    for (Slot cs : this.field_75151_b) {
                        if (this.isPlayerSideSlot(cs) || cs instanceof FakeSlot || cs instanceof CraftingMatrixSlot || !cs.func_75214_a(tis)) continue;
                        selectedSlots.add(cs);
                    }
                }
            } else {
                tis = tis.func_77946_l();
                for (Slot cs : this.field_75151_b) {
                    if (!this.isPlayerSideSlot(cs) || cs instanceof FakeSlot || cs instanceof CraftingMatrixSlot || !cs.func_75214_a(tis)) continue;
                    selectedSlots.add(cs);
                }
            }
            if (selectedSlots.isEmpty() && playerSide && !tis.func_190926_b()) {
                for (Slot cs : this.field_75151_b) {
                    ItemStack destination = cs.func_75211_c();
                    if (this.isPlayerSideSlot(cs) || !(cs instanceof FakeSlot)) continue;
                    if (Platform.itemComparisons().isSameItem(destination, tis)) break;
                    if (!destination.func_190926_b()) continue;
                    cs.func_75215_d(tis.func_77946_l());
                    this.func_75142_b();
                    break;
                }
            }
            if (!tis.func_190926_b()) {
                for (Slot d : selectedSlots) {
                    if (!d.func_75214_a(tis) || !d.func_75216_d() || !this.x(clickSlot, tis, d)) continue;
                    return ItemStack.field_190927_a;
                }
                for (Slot d : selectedSlots) {
                    ItemStack tmp;
                    if (!d.func_75214_a(tis)) continue;
                    if (d.func_75216_d()) {
                        if (!this.x(clickSlot, tis, d)) continue;
                        return ItemStack.field_190927_a;
                    }
                    int maxSize = tis.func_77976_d();
                    if (maxSize > d.func_75219_a()) {
                        maxSize = d.func_75219_a();
                    }
                    if ((tmp = tis.func_77946_l()).func_190916_E() > maxSize) {
                        tmp.func_190920_e(maxSize);
                    }
                    tis.func_190920_e(tis.func_190916_E() - tmp.func_190916_E());
                    d.func_75215_d(tmp);
                    if (tis.func_190916_E() <= 0) {
                        clickSlot.func_75215_d(ItemStack.field_190927_a);
                        d.func_75218_e();
                        this.func_75142_b();
                        return ItemStack.field_190927_a;
                    }
                    this.func_75142_b();
                }
            }
            clickSlot.func_75215_d(!tis.func_190926_b() ? tis : ItemStack.field_190927_a);
        }
        this.func_75142_b();
        return ItemStack.field_190927_a;
    }

    private boolean x(Slot clickSlot, ItemStack tis, Slot d) {
        ItemStack t = d.func_75211_c().func_77946_l();
        if (Platform.itemComparisons().isSameItem(t, tis)) {
            int placeable;
            int maxSize = t.func_77976_d();
            if (maxSize > d.func_75219_a()) {
                maxSize = d.func_75219_a();
            }
            if ((placeable = maxSize - t.func_190916_E()) > 0) {
                if (tis.func_190916_E() < placeable) {
                    placeable = tis.func_190916_E();
                }
                t.func_190920_e(t.func_190916_E() + placeable);
                tis.func_190920_e(tis.func_190916_E() - placeable);
                d.func_75215_d(t);
                if (tis.func_190916_E() <= 0) {
                    clickSlot.func_75215_d(ItemStack.field_190927_a);
                    d.func_75218_e();
                    this.func_75142_b();
                    this.func_75142_b();
                    return true;
                }
                this.func_75142_b();
            }
        }
        return false;
    }

    public boolean func_75145_c(PlayerEntity PlayerEntity2) {
        if (this.isValidContainer()) {
            if (this.tileEntity instanceof IInventory) {
                return ((IInventory)this.tileEntity).func_70300_a(PlayerEntity2);
            }
            return true;
        }
        return false;
    }

    public boolean func_94531_b(Slot s) {
        if (s instanceof AppEngSlot) {
            return ((AppEngSlot)s).isDraggable();
        }
        return super.func_94531_b(s);
    }

    public void setFilter(int slotIndex, ItemStack item) {
        if (slotIndex < 0 || slotIndex >= this.field_75151_b.size()) {
            return;
        }
        Slot s = this.func_75139_a(slotIndex);
        if (!(s instanceof AppEngSlot)) {
            return;
        }
        AppEngSlot appEngSlot = (AppEngSlot)s;
        if (!appEngSlot.isSlotEnabled()) {
            return;
        }
        if (s instanceof FakeSlot) {
            s.func_75215_d(item);
        }
    }

    public void doAction(ServerPlayerEntity player, InventoryAction action, int slot, long id) {
        if (slot < 0 || slot >= this.field_75151_b.size()) {
            return;
        }
        Slot s = this.func_75139_a(slot);
        if (s instanceof CraftingTermSlot) {
            switch (action) {
                case CRAFT_SHIFT: 
                case CRAFT_ITEM: 
                case CRAFT_STACK: {
                    ((CraftingTermSlot)s).doClick(action, (PlayerEntity)player);
                    this.updateHeld(player);
                }
            }
        }
        if (s instanceof FakeSlot) {
            ItemStack hand = player.field_71071_by.func_70445_o();
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    if (hand.func_190926_b()) {
                        s.func_75215_d(ItemStack.field_190927_a);
                        break;
                    }
                    s.func_75215_d(hand.func_77946_l());
                    break;
                }
                case PLACE_SINGLE: {
                    if (hand.func_190926_b()) break;
                    ItemStack is = hand.func_77946_l();
                    is.func_190920_e(1);
                    s.func_75215_d(is);
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    ItemStack is = s.func_75211_c();
                    if (!is.func_190926_b()) {
                        if (hand.func_190926_b()) {
                            is.func_190920_e(Math.max(1, is.func_190916_E() - 1));
                        } else if (hand.func_77969_a(is)) {
                            is.func_190920_e(Math.min(is.func_77976_d(), is.func_190916_E() + 1));
                        } else {
                            is = hand.func_77946_l();
                            is.func_190920_e(1);
                        }
                        s.func_75215_d(is);
                        break;
                    }
                    if (hand.func_190926_b()) break;
                    is = hand.func_77946_l();
                    is.func_190920_e(1);
                    s.func_75215_d(is);
                    break;
                }
            }
        }
        if (action == InventoryAction.MOVE_REGION) {
            ArrayList<Slot> from = new ArrayList<Slot>();
            for (Slot j : this.field_75151_b) {
                if (j == null || j.getClass() != s.getClass() || j instanceof CraftingTermSlot) continue;
                from.add(j);
            }
            for (Slot fr : from) {
                this.func_82846_b((PlayerEntity)player, fr.field_75222_d);
            }
        }
    }

    protected void updateHeld(ServerPlayerEntity p) {
        NetworkHandler.instance().sendTo(new InventoryActionPacket(InventoryAction.UPDATE_HAND, 0, p.field_71071_by.func_70445_o()), p);
    }

    protected ItemStack transferStackToContainer(ItemStack input) {
        return input;
    }

    public void swapSlotContents(int slotA, int slotB) {
        ItemStack testB;
        Slot a = this.func_75139_a(slotA);
        Slot b = this.func_75139_a(slotB);
        if (a == null || b == null) {
            return;
        }
        ItemStack isA = a.func_75211_c();
        ItemStack isB = b.func_75211_c();
        if (isA.func_190926_b() && isB.func_190926_b()) {
            return;
        }
        if (!isA.func_190926_b() && !a.func_82869_a(this.getPlayerInventory().field_70458_d)) {
            return;
        }
        if (!isB.func_190926_b() && !b.func_82869_a(this.getPlayerInventory().field_70458_d)) {
            return;
        }
        if (!isB.func_190926_b() && !a.func_75214_a(isB)) {
            return;
        }
        if (!isA.func_190926_b() && !b.func_75214_a(isA)) {
            return;
        }
        ItemStack testA = isB.func_190926_b() ? ItemStack.field_190927_a : isB.func_77946_l();
        ItemStack itemStack = testB = isA.func_190926_b() ? ItemStack.field_190927_a : isA.func_77946_l();
        if (!testA.func_190926_b() && testA.func_190916_E() > a.func_75219_a()) {
            if (!testB.func_190926_b()) {
                return;
            }
            int totalA = testA.func_190916_E();
            testA.func_190920_e(a.func_75219_a());
            testB = testA.func_77946_l();
            testB.func_190920_e(totalA - testA.func_190916_E());
        }
        if (!testB.func_190926_b() && testB.func_190916_E() > b.func_75219_a()) {
            if (!testA.func_190926_b()) {
                return;
            }
            int totalB = testB.func_190916_E();
            testB.func_190920_e(b.func_75219_a());
            testA = testB.func_77946_l();
            testA.func_190920_e(totalB - testA.func_190916_E());
        }
        a.func_75215_d(testA);
        b.func_75215_d(testB);
    }

    @OverridingMethodsMustInvokeSuper
    public void onServerDataSync() {
    }

    public void onSlotChange(Slot s) {
    }

    public boolean isValidForSlot(Slot s, ItemStack i) {
        return true;
    }

    public boolean isValidContainer() {
        return this.isContainerValid;
    }

    public void setValidContainer(boolean isContainerValid) {
        this.isContainerValid = isContainerValid;
    }

    public ContainerLocator getLocator() {
        return this.locator;
    }

    public void setLocator(ContainerLocator locator) {
        this.locator = locator;
    }

    protected boolean isClient() {
        return this.playerInventory.field_70458_d.func_130014_f_().func_201670_d();
    }

    protected boolean isServer() {
        return !this.isClient();
    }

    protected final void sendPacketToClient(BasePacket packet) {
        for (IContainerListener c : this.field_75149_d) {
            if (!(c instanceof ServerPlayerEntity)) continue;
            NetworkHandler.instance().sendTo(packet, (ServerPlayerEntity)c);
        }
    }

    protected final boolean ensureGuiItemIsInSlot(IGuiItemObject guiObject, int slot) {
        ItemStack expectedItem = guiObject.getItemStack();
        ItemStack currentItem = this.getPlayerInventory().func_70301_a(slot);
        if (!currentItem.func_190926_b() && !expectedItem.func_190926_b()) {
            if (currentItem == expectedItem) {
                return true;
            }
            if (ItemStack.func_179545_c((ItemStack)expectedItem, (ItemStack)currentItem)) {
                this.getPlayerInventory().func_70299_a(slot, expectedItem);
                return true;
            }
        }
        return false;
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        if (listener instanceof ServerPlayerEntity && this.dataSync.hasFields()) {
            this.sendPacketToClient(new GuiDataSyncPacket(this.field_75152_c, this.dataSync::writeFull));
        }
    }

    public final void receiveServerSyncData(GuiDataSyncPacket packet) {
        this.dataSync.readUpdate(packet.getData());
        this.onServerDataSync();
    }

    public final void receiveClientAction(GuiDataSyncPacket packet) {
        PacketBuffer data = packet.getData();
        String name = data.func_150789_c(256);
        ClientAction<?> action = this.clientActions.get(name);
        if (action == null) {
            throw new IllegalArgumentException("Unknown client action: '" + name + "'");
        }
        action.handle(data);
    }

    protected final <T> void registerClientAction(String name, Class<T> argClass, Consumer<T> handler) {
        if (this.clientActions.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate client action registered: " + name);
        }
        this.clientActions.put(name, new ClientAction<T>(name, argClass, handler));
    }

    protected final void registerClientAction(String name, Runnable callback) {
        this.registerClientAction(name, Void.class, arg -> callback.run());
    }

    protected final <T> void sendClientAction(String action, T arg) {
        String jsonPayload;
        ClientAction<?> clientAction = this.clientActions.get(action);
        if (clientAction == null) {
            throw new IllegalArgumentException("Trying to send unregistered client action: " + action);
        }
        if (((ClientAction)clientAction).argClass == Void.class) {
            if (arg != null) {
                throw new IllegalArgumentException("Client action " + action + " requires no argument, but it was given");
            }
            jsonPayload = null;
        } else {
            if (arg == null) {
                throw new IllegalArgumentException("Client action " + action + " requires an argument, but none was given");
            }
            if (((ClientAction)clientAction).argClass != arg.getClass()) {
                throw new IllegalArgumentException("Trying to send client action " + action + " with wrong argument type " + arg.getClass() + ", expected: " + ((ClientAction)clientAction).argClass);
            }
            jsonPayload = ((ClientAction)clientAction).gson.toJson(arg);
        }
        if (jsonPayload != null && jsonPayload.length() > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot send client action " + action + " because serialized argument is longer than " + Short.MAX_VALUE + " (" + jsonPayload.length() + ")");
        }
        NetworkHandler.instance().sendToServer(new GuiDataSyncPacket(this.field_75152_c, writer -> {
            writer.func_180714_a(((ClientAction)clientAction).name);
            if (jsonPayload != null) {
                writer.func_180714_a(jsonPayload);
            }
        }));
    }

    protected final void sendClientAction(String action) {
        this.sendClientAction(action, null);
    }

    private static class ClientAction<T> {
        private final Gson gson = new GsonBuilder().create();
        private final String name;
        private final Class<T> argClass;
        private final Consumer<T> handler;

        public ClientAction(String name, Class<T> argClass, Consumer<T> handler) {
            this.name = name;
            this.argClass = argClass;
            this.handler = handler;
        }

        public void handle(PacketBuffer buffer) {
            Object arg = null;
            if (this.argClass != Void.class) {
                String payload = buffer.func_150789_c(Short.MAX_VALUE);
                AELog.debug("Handling client action '%s' with payload %s", this.name, payload);
                arg = this.gson.fromJson(payload, this.argClass);
            } else {
                AELog.debug("Handling client action '%s'", this.name);
            }
            this.handler.accept(arg);
        }
    }
}

