/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.client.screen;

import com.direwolf20.buildinggadgets.client.KeyBindings;
import com.direwolf20.buildinggadgets.client.OurSounds;
import com.direwolf20.buildinggadgets.client.screen.CopyGUI;
import com.direwolf20.buildinggadgets.client.screen.MaterialListGUI;
import com.direwolf20.buildinggadgets.client.screen.PasteGUI;
import com.direwolf20.buildinggadgets.client.screen.components.GuiIconActionable;
import com.direwolf20.buildinggadgets.client.screen.components.GuiSliderInt;
import com.direwolf20.buildinggadgets.common.config.Config;
import com.direwolf20.buildinggadgets.common.items.AbstractGadget;
import com.direwolf20.buildinggadgets.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets.common.items.GadgetDestruction;
import com.direwolf20.buildinggadgets.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets.common.items.modes.BuildingModes;
import com.direwolf20.buildinggadgets.common.items.modes.ExchangingModes;
import com.direwolf20.buildinggadgets.common.network.PacketHandler;
import com.direwolf20.buildinggadgets.common.network.packets.PacketAnchor;
import com.direwolf20.buildinggadgets.common.network.packets.PacketChangeRange;
import com.direwolf20.buildinggadgets.common.network.packets.PacketRotateMirror;
import com.direwolf20.buildinggadgets.common.network.packets.PacketToggleBlockPlacement;
import com.direwolf20.buildinggadgets.common.network.packets.PacketToggleConnectedArea;
import com.direwolf20.buildinggadgets.common.network.packets.PacketToggleFluidOnly;
import com.direwolf20.buildinggadgets.common.network.packets.PacketToggleFuzzy;
import com.direwolf20.buildinggadgets.common.network.packets.PacketToggleMode;
import com.direwolf20.buildinggadgets.common.network.packets.PacketToggleRayTraceFluid;
import com.direwolf20.buildinggadgets.common.network.packets.PacketUndo;
import com.direwolf20.buildinggadgets.common.util.GadgetUtils;
import com.direwolf20.buildinggadgets.common.util.lang.GuiTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.MessageTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.RadialTranslation;
import com.direwolf20.buildinggadgets.common.util.lang.Styles;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.ForgeI18n;
import org.lwjgl.opengl.GL11;

public class ModeRadialMenu
extends Screen {
    private static final ImmutableList<ResourceLocation> signsCopyPaste = ImmutableList.of((Object)new ResourceLocation("buildinggadgets", "textures/gui/mode/copy.png"), (Object)new ResourceLocation("buildinggadgets", "textures/gui/mode/paste.png"));
    private final List<Button> conditionalButtons = new ArrayList<Button>();
    private int timeIn = 0;
    private int slotSelected = -1;
    private int segments;

    public ModeRadialMenu(ItemStack stack) {
        super((ITextComponent)new StringTextComponent(""));
        if (stack.func_77973_b() instanceof AbstractGadget) {
            this.setSocketable(stack);
        }
    }

    private static float mouseAngle(int x, int y, int mx, int my) {
        Vector2f baseVec = new Vector2f(1.0f, 0.0f);
        Vector2f mouseVec = new Vector2f(mx - x, my - y);
        float ang = (float)(Math.acos(baseVec.dot(mouseVec) / (baseVec.length() * mouseVec.length())) * 57.29577951308232);
        return my < y ? 360.0f - ang : ang;
    }

    public void setSocketable(ItemStack stack) {
        if (stack.func_77973_b() instanceof GadgetBuilding) {
            this.segments = BuildingModes.values().length;
        } else if (stack.func_77973_b() instanceof GadgetExchanger) {
            this.segments = ExchangingModes.values().length;
        } else if (stack.func_77973_b() instanceof GadgetCopyPaste) {
            this.segments = GadgetCopyPaste.ToolMode.values().length;
        }
    }

    public void func_231160_c_() {
        ScreenPosition left;
        this.conditionalButtons.clear();
        ItemStack tool = this.getGadget();
        boolean isDestruction = tool.func_77973_b() instanceof GadgetDestruction;
        ScreenPosition right = isDestruction ? ScreenPosition.TOP : ScreenPosition.RIGHT;
        ScreenPosition screenPosition = left = isDestruction ? ScreenPosition.BOTTOM : ScreenPosition.LEFT;
        if (isDestruction) {
            this.func_230480_a_((Widget)new PositionedIconActionable(RadialTranslation.DESTRUCTION_OVERLAY, "destroy_overlay", right, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketChangeRange());
                }
                return GadgetDestruction.getOverlay(this.getGadget());
            }));
            this.func_230480_a_((Widget)new PositionedIconActionable(RadialTranslation.FLUID_ONLY, "fluid_only", right, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketToggleFluidOnly());
                }
                return GadgetDestruction.getIsFluidOnly(this.getGadget());
            }));
        } else {
            this.func_230480_a_((Widget)new PositionedIconActionable(RadialTranslation.ROTATE, "rotate", left, false, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketRotateMirror(PacketRotateMirror.Operation.ROTATE));
                }
                return false;
            }));
            this.func_230480_a_((Widget)new PositionedIconActionable(RadialTranslation.MIRROR, "mirror", left, false, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketRotateMirror(PacketRotateMirror.Operation.MIRROR));
                }
                return false;
            }));
        }
        if (!(tool.func_77973_b() instanceof GadgetCopyPaste)) {
            PositionedIconActionable button;
            if (!isDestruction || ((Boolean)Config.GADGETS.GADGET_DESTRUCTION.nonFuzzyEnabled.get()).booleanValue()) {
                button = new PositionedIconActionable(RadialTranslation.FUZZY, "fuzzy", right, send -> {
                    if (send.booleanValue()) {
                        PacketHandler.sendToServer(new PacketToggleFuzzy());
                    }
                    return AbstractGadget.getFuzzy(this.getGadget());
                });
                this.func_230480_a_((Widget)button);
                this.conditionalButtons.add(button);
            }
            if (!isDestruction) {
                button = new PositionedIconActionable(RadialTranslation.CONNECTED_SURFACE, "connected_area", right, send -> {
                    if (send.booleanValue()) {
                        PacketHandler.sendToServer(new PacketToggleConnectedArea());
                    }
                    return AbstractGadget.getConnectedArea(this.getGadget());
                });
                this.func_230480_a_((Widget)button);
                this.conditionalButtons.add(button);
            }
            if (!isDestruction) {
                int widthSlider = 82;
                GuiSliderInt sliderRange = new GuiSliderInt(this.field_230708_k_ / 2 - widthSlider / 2, this.field_230709_l_ / 2 + 72, widthSlider, 14, (ITextComponent)GuiTranslation.SINGLE_RANGE.componentTranslation(new Object[0]).func_230529_a_((ITextComponent)new StringTextComponent(": ")), (ITextComponent)new StringTextComponent(""), 1.0, ((Integer)Config.GADGETS.maxRange.get()).intValue(), GadgetUtils.getToolRange(tool), false, true, Color.DARK_GRAY, slider -> {
                    GuiSliderInt sliderI = (GuiSliderInt)slider;
                    this.sendRangeUpdate(sliderI.getValueInt());
                }, (slider, amount) -> {
                    int value = slider.getValueInt();
                    int valueNew = MathHelper.func_76125_a((int)(value + amount), (int)1, (int)((Integer)Config.GADGETS.maxRange.get()));
                    this.sendRangeUpdate(valueNew);
                    slider.setValue(valueNew);
                    slider.updateSlider();
                });
                sliderRange.precision = 1;
                sliderRange.getComponents().forEach(arg_0 -> ((ModeRadialMenu)this).func_230480_a_(arg_0));
            }
        } else {
            this.func_230480_a_((Widget)new PositionedIconActionable(RadialTranslation.OPEN_GUI, "copypaste_opengui", right, send -> {
                if (!send.booleanValue()) {
                    return false;
                }
                assert (this.getMinecraft().field_71439_g != null);
                this.getMinecraft().field_71439_g.func_71053_j();
                if (GadgetCopyPaste.getToolMode(tool) == GadgetCopyPaste.ToolMode.COPY) {
                    this.getMinecraft().func_147108_a((Screen)new CopyGUI(tool));
                } else {
                    this.getMinecraft().func_147108_a((Screen)new PasteGUI(tool));
                }
                return true;
            }));
            this.func_230480_a_((Widget)new PositionedIconActionable(RadialTranslation.OPEN_MATERIAL_LIST, "copypaste_materiallist", right, send -> {
                if (!send.booleanValue()) {
                    return false;
                }
                assert (this.getMinecraft().field_71439_g != null);
                this.getMinecraft().field_71439_g.func_71053_j();
                this.getMinecraft().func_147108_a((Screen)new MaterialListGUI(tool));
                return true;
            }));
        }
        this.func_230480_a_((Widget)new PositionedIconActionable(RadialTranslation.RAYTRACE_FLUID, "raytrace_fluid", right, send -> {
            if (send.booleanValue()) {
                PacketHandler.sendToServer(new PacketToggleRayTraceFluid());
            }
            return AbstractGadget.shouldRayTraceFluid(this.getGadget());
        }));
        if (tool.func_77973_b() instanceof GadgetBuilding) {
            this.func_230480_a_((Widget)new PositionedIconActionable(RadialTranslation.PLACE_ON_TOP, "building_place_atop", right, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketToggleBlockPlacement());
                }
                return GadgetBuilding.shouldPlaceAtop(this.getGadget());
            }));
        }
        this.func_230480_a_((Widget)new PositionedIconActionable(RadialTranslation.ANCHOR, "anchor", left, send -> {
            ItemStack stack;
            if (send.booleanValue()) {
                PacketHandler.sendToServer(new PacketAnchor());
            }
            if ((stack = this.getGadget()).func_77973_b() instanceof GadgetCopyPaste || stack.func_77973_b() instanceof GadgetDestruction) {
                return ((AbstractGadget)stack.func_77973_b()).getAnchor(stack) != null;
            }
            return GadgetUtils.getAnchor(stack).isPresent();
        }));
        if (!(tool.func_77973_b() instanceof GadgetExchanger)) {
            this.func_230480_a_((Widget)new PositionedIconActionable(RadialTranslation.UNDO, "undo", left, false, send -> {
                if (send.booleanValue()) {
                    PacketHandler.sendToServer(new PacketUndo());
                }
                return false;
            }));
        }
        this.updateButtons(tool);
    }

    private void updateButtons(ItemStack tool) {
        PositionedIconActionable button;
        int posRight = 0;
        int posLeft = 0;
        int dim = 24;
        int padding = 10;
        boolean isDestruction = tool.func_77973_b() instanceof GadgetDestruction;
        ScreenPosition right = isDestruction ? ScreenPosition.BOTTOM : ScreenPosition.RIGHT;
        for (Widget widget : this.field_230710_m_) {
            int offset;
            boolean isRight;
            if (!(widget instanceof PositionedIconActionable)) continue;
            button = (PositionedIconActionable)widget;
            if (!button.field_230694_p_) continue;
            boolean bl = isRight = button.position == right;
            if (isRight) {
                posRight += dim + padding;
                offset = 70;
            } else {
                posLeft += dim + padding;
                offset = -70 - dim;
            }
            button.func_230991_b_(dim);
            button.setHeight(dim);
            if (isDestruction) {
                button.field_230691_m_ = this.field_230709_l_ / 2 + (isRight ? 10 : -button.func_238483_d_() - 10);
                continue;
            }
            button.field_230690_l_ = this.field_230708_k_ / 2 + offset;
        }
        posRight = this.resetPos(tool, padding, posRight);
        posLeft = this.resetPos(tool, padding, posLeft);
        for (Widget widget : this.field_230710_m_) {
            int pos;
            if (!(widget instanceof PositionedIconActionable)) continue;
            button = (PositionedIconActionable)widget;
            if (!button.field_230694_p_) continue;
            boolean isRight = button.position == right;
            int n = pos = isRight ? posRight : posLeft;
            if (isDestruction) {
                button.field_230690_l_ = pos;
            } else {
                button.field_230691_m_ = pos;
            }
            if (isRight) {
                posRight += dim + padding;
                continue;
            }
            posLeft += dim + padding;
        }
    }

    private int resetPos(ItemStack tool, int padding, int pos) {
        return tool.func_77973_b() instanceof GadgetDestruction ? this.field_230708_k_ / 2 - (pos - padding) / 2 : this.field_230709_l_ / 2 - (pos - padding) / 2;
    }

    private ItemStack getGadget() {
        assert (this.getMinecraft().field_71439_g != null);
        return AbstractGadget.getGadget((PlayerEntity)this.getMinecraft().field_71439_g);
    }

    public void func_230430_a_(MatrixStack matrices, int mx, int my, float partialTicks) {
        Object signs;
        int modeIndex;
        float stime = 5.0f;
        float fract = Math.min(stime, (float)this.timeIn + partialTicks) / stime;
        int x = this.field_230708_k_ / 2;
        int y = this.field_230709_l_ / 2;
        int radiusMin = 26;
        int radiusMax = 60;
        double dist = new Vector3d((double)x, (double)y, 0.0).func_72438_d(new Vector3d((double)mx, (double)my, 0.0));
        boolean inRange = false;
        if (this.segments != 0) {
            inRange = dist > (double)radiusMin && dist < (double)radiusMax;
            for (Widget button : this.field_230710_m_) {
                if (!(button instanceof PositionedIconActionable)) continue;
                ((PositionedIconActionable)button).setFaded(inRange);
            }
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((1.0f - fract) * (float)x), (float)((1.0f - fract) * (float)y), (float)0.0f);
        RenderSystem.scalef((float)fract, (float)fract, (float)fract);
        super.func_230430_a_(matrices, mx, my, partialTicks);
        RenderSystem.popMatrix();
        if (this.segments == 0) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.disableTexture();
        float angle = ModeRadialMenu.mouseAngle(x, y, mx, my);
        RenderSystem.enableBlend();
        RenderSystem.shadeModel((int)7425);
        float totalDeg = 0.0f;
        float degPer = 360.0f / (float)this.segments;
        ArrayList<NameDisplayData> nameData = new ArrayList<NameDisplayData>();
        ItemStack tool = this.getGadget();
        if (tool.func_190926_b()) {
            return;
        }
        this.slotSelected = -1;
        if (tool.func_77973_b() instanceof GadgetBuilding) {
            modeIndex = GadgetBuilding.getToolMode(tool).ordinal();
            signs = Arrays.stream(BuildingModes.values()).map(e -> new ResourceLocation("buildinggadgets", e.getIcon())).collect(Collectors.toList());
        } else if (tool.func_77973_b() instanceof GadgetExchanger) {
            modeIndex = GadgetExchanger.getToolMode(tool).ordinal();
            signs = Arrays.stream(ExchangingModes.values()).map(e -> new ResourceLocation("buildinggadgets", e.getIcon())).collect(Collectors.toList());
        } else {
            modeIndex = GadgetCopyPaste.getToolMode(tool).ordinal();
            signs = signsCopyPaste;
        }
        boolean shouldCenter = (this.segments + 2) % 4 == 0;
        int indexBottom = this.segments / 4;
        int indexTop = indexBottom + this.segments / 2;
        for (int seg = 0; seg < this.segments; ++seg) {
            boolean mouseInSector = this.isCursorInSlice(angle, totalDeg, degPer, inRange);
            float radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)this.segments) * 40.0f, (float)radiusMax));
            GL11.glBegin((int)5);
            float gs = 0.25f;
            if (seg % 2 == 0) {
                gs += 0.1f;
            }
            float r = gs;
            float g = gs + (seg == modeIndex ? 1.0f : 0.0f);
            float b = gs;
            float a = 0.4f;
            if (mouseInSector) {
                this.slotSelected = seg;
                b = 1.0f;
                g = 1.0f;
                r = 1.0f;
            }
            RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
            for (float i = degPer; i >= 0.0f; i -= 1.0f) {
                float rad = (float)((double)((i + totalDeg) / 180.0f) * Math.PI);
                double xp = (double)x + Math.cos(rad) * (double)radius;
                double yp = (double)y + Math.sin(rad) * (double)radius;
                if ((int)i == (int)(degPer / 2.0f)) {
                    nameData.add(new NameDisplayData((int)xp, (int)yp, mouseInSector, shouldCenter && (seg == indexBottom || seg == indexTop)));
                }
                GL11.glVertex2d((double)((double)x + Math.cos(rad) * (double)radius / (double)2.3f), (double)((double)y + Math.sin(rad) * (double)radius / (double)2.3f));
                GL11.glVertex2d((double)xp, (double)yp);
            }
            totalDeg += degPer;
            GL11.glEnd();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableTexture();
        for (int i = 0; i < nameData.size(); ++i) {
            Color color;
            NameDisplayData data = (NameDisplayData)nameData.get(i);
            int xp = data.getX();
            int yp = data.getY();
            String name = tool.func_77973_b() instanceof GadgetBuilding ? ForgeI18n.getPattern((String)BuildingModes.values()[i].getTranslationKey()) : (tool.func_77973_b() instanceof GadgetExchanger ? ForgeI18n.getPattern((String)ExchangingModes.values()[i].getTranslationKey()) : GadgetCopyPaste.ToolMode.values()[i].getTranslation().format(new Object[0]));
            int xsp = xp - 4;
            int ysp = yp;
            int width = this.field_230712_o_.func_78256_a(name);
            if (xsp < x) {
                xsp -= width - 8;
            }
            if (ysp < y) {
                ysp -= 9;
            }
            Color color2 = color = i == modeIndex ? Color.GREEN : Color.WHITE;
            if (data.isSelected()) {
                this.field_230712_o_.func_238405_a_(matrices, name, (float)xsp + (data.isCentralized() ? (float)width / 2.0f - 4.0f : 0.0f), (float)ysp, color.getRGB());
            }
            double mod = 0.7;
            int xdp = (int)((double)(xp - x) * mod + (double)x);
            int ydp = (int)((double)(yp - y) * mod + (double)y);
            this.getMinecraft().func_110434_K().func_110577_a((ResourceLocation)signs.get(i));
            RenderSystem.color4f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
            this.getMinecraft().func_110434_K().func_110577_a((ResourceLocation)signs.get(i));
            ModeRadialMenu.func_238463_a_((MatrixStack)matrices, (int)(xdp - 8), (int)(ydp - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_227780_a_();
        float s = 2.25f * fract;
        RenderSystem.scalef((float)s, (float)s, (float)s);
        RenderSystem.translatef((float)((float)x / s - (tool.func_77973_b() instanceof GadgetCopyPaste ? 8.0f : 8.5f)), (float)((float)y / s - 8.0f), (float)0.0f);
        this.field_230707_j_.func_180450_b(tool, 0, 0);
        RenderHelper.func_74518_a();
        RenderSystem.disableBlend();
        RenderSystem.disableRescaleNormal();
        RenderSystem.popMatrix();
    }

    private boolean isCursorInSlice(float angle, float totalDeg, float degPer, boolean inRange) {
        return inRange && angle > totalDeg && angle < totalDeg + degPer;
    }

    private void changeMode() {
        if (this.slotSelected >= 0) {
            Item gadget = this.getGadget().func_77973_b();
            String mode = gadget instanceof GadgetBuilding ? ForgeI18n.getPattern((String)BuildingModes.values()[this.slotSelected].getTranslationKey()) : (gadget instanceof GadgetExchanger ? ForgeI18n.getPattern((String)ExchangingModes.values()[this.slotSelected].getTranslationKey()) : GadgetCopyPaste.ToolMode.values()[this.slotSelected].getTranslation().format(new Object[0]));
            assert (this.getMinecraft().field_71439_g != null);
            this.getMinecraft().field_71439_g.func_146105_b((ITextComponent)MessageTranslation.MODE_SET.componentTranslation(mode).func_230530_a_(Styles.AQUA), true);
            PacketHandler.sendToServer(new PacketToggleMode(this.slotSelected));
            OurSounds.BEEP.playSound();
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        this.changeMode();
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public void func_231023_e_() {
        if (!InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)KeyBindings.menuSettings.getKey().func_197937_c())) {
            this.func_231175_as__();
            this.changeMode();
        }
        ImmutableSet set = ImmutableSet.of((Object)this.getMinecraft().field_71474_y.field_74351_w, (Object)this.getMinecraft().field_71474_y.field_74370_x, (Object)this.getMinecraft().field_71474_y.field_74368_y, (Object)this.getMinecraft().field_71474_y.field_74366_z, (Object)this.getMinecraft().field_71474_y.field_228046_af_, (Object)this.getMinecraft().field_71474_y.field_151444_V, (Object[])new KeyBinding[]{this.getMinecraft().field_71474_y.field_74314_A});
        for (KeyBinding k : set) {
            KeyBinding.func_197980_a((InputMappings.Input)k.getKey(), (boolean)k.func_151470_d());
        }
        ++this.timeIn;
        ItemStack tool = this.getGadget();
        boolean builder = tool.func_77973_b() instanceof GadgetBuilding;
        if (!builder && !(tool.func_77973_b() instanceof GadgetExchanger)) {
            return;
        }
        boolean changed = false;
        for (int i = 0; i < this.conditionalButtons.size(); ++i) {
            boolean curent;
            Button button = this.conditionalButtons.get(i);
            if (builder) {
                curent = GadgetBuilding.getToolMode(tool) == BuildingModes.SURFACE;
            } else {
                boolean bl = curent = i == 0 || GadgetExchanger.getToolMode(tool) == ExchangingModes.SURFACE;
            }
            if (button.field_230694_p_ == curent) continue;
            button.field_230694_p_ = curent;
            changed = true;
        }
        if (changed) {
            this.updateButtons(tool);
        }
    }

    public boolean func_231177_au__() {
        return false;
    }

    private void sendRangeUpdate(int valueNew) {
        if (valueNew != GadgetUtils.getToolRange(this.getGadget())) {
            PacketHandler.sendToServer(new PacketChangeRange(valueNew));
        }
    }

    private static class Vector2f {
        public float x;
        public float y;

        public Vector2f(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public final float dot(Vector2f v1) {
            return this.x * v1.x + this.y * v1.y;
        }

        public final float length() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y);
        }
    }

    private static class PositionedIconActionable
    extends GuiIconActionable {
        private ScreenPosition position;

        PositionedIconActionable(RadialTranslation message, String icon, ScreenPosition position, boolean isSelectable, Predicate<Boolean> action) {
            super(0, 0, icon, (ITextComponent)message.componentTranslation(new Object[0]), isSelectable, action);
            this.position = position;
        }

        PositionedIconActionable(RadialTranslation message, String icon, ScreenPosition position, Predicate<Boolean> action) {
            this(message, icon, position, true, action);
        }
    }

    private static final class NameDisplayData {
        private final int x;
        private final int y;
        private final boolean selected;
        private final boolean centralize;

        private NameDisplayData(int x, int y, boolean selected, boolean centralize) {
            this.x = x;
            this.y = y;
            this.selected = selected;
            this.centralize = centralize;
        }

        private int getX() {
            return this.x;
        }

        private int getY() {
            return this.y;
        }

        private boolean isSelected() {
            return this.selected;
        }

        private boolean isCentralized() {
            return this.centralize;
        }
    }

    public static enum ScreenPosition {
        RIGHT,
        LEFT,
        BOTTOM,
        TOP;

    }
}

