/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.api.capability;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public interface ISoulConsumer {
    public static final ITextComponent MESSAGE_ENCHANT_ITEM_SUCCESS = new TranslationTextComponent("tombstone.message.enchant_item.success");
    public static final ITextComponent MESSAGE_ENCHANT_ITEM_FAILED = new TranslationTextComponent("tombstone.message.enchant_item.failed");

    public boolean isEnchanted(ItemStack var1);

    public ConsumeResult setEnchant(World var1, BlockPos var2, ServerPlayerEntity var3, ItemStack var4, int var5);

    default public boolean isUsingOffhandToEnchant() {
        return false;
    }

    default public void onSneakGrave(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
    }

    default public boolean canEnchant(World world, BlockPos gravePos, PlayerEntity player, ItemStack stack) {
        return true;
    }

    default public int getKnowledge() {
        return 1;
    }

    public static final class ConsumeResult {
        private final Result result;
        private final ITextComponent message;
        private final int soulStrength;

        public ConsumeResult(Result result, ITextComponent message, int soulStrength) {
            this.result = result;
            this.message = message;
            this.soulStrength = soulStrength;
        }

        public static ConsumeResult success(int soulStrength) {
            return new ConsumeResult(Result.SUCCESS, MESSAGE_ENCHANT_ITEM_SUCCESS, soulStrength);
        }

        public static ConsumeResult success(ITextComponent message, int soulStrength) {
            return new ConsumeResult(Result.SUCCESS, message, soulStrength);
        }

        public static ConsumeResult fail() {
            return new ConsumeResult(Result.FAIL, MESSAGE_ENCHANT_ITEM_FAILED, 0);
        }

        public static ConsumeResult fail(ITextComponent message) {
            return new ConsumeResult(Result.FAIL, message, 0);
        }

        public Result result() {
            return this.result;
        }

        public ITextComponent message() {
            return this.message;
        }

        public int soulStrength() {
            return this.soulStrength;
        }

        public static enum Result {
            SUCCESS,
            FAIL;


            public boolean success() {
                return this == SUCCESS;
            }

            public boolean fail() {
                return this == FAIL;
            }
        }
    }
}

