/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

public abstract class TombstoneEnchantment
extends Enchantment {
    final String customName;
    private final ITextComponent info;

    TombstoneEnchantment(String name, Enchantment.Rarity rarity, EnchantmentType type, EquipmentSlotType ... slots) {
        super(rarity, type, slots);
        this.customName = name;
        this.info = new TranslationTextComponent(this.func_77320_a() + ".desc").func_230530_a_(StyleType.TOOLTIP_ENCHANT);
    }

    public abstract boolean isEnabled();

    public boolean isInBeta() {
        return false;
    }

    public int func_77319_d() {
        return 1;
    }

    public int func_77325_b() {
        return 10;
    }

    public int func_77321_a(int amplifier) {
        return (Math.max(1, amplifier) - 1) * this.getScaledEnchantability() + this.getMinEnchantability();
    }

    public int func_223551_b(int amplifier) {
        return this.func_77321_a(amplifier + 1) - 1;
    }

    protected int getMinEnchantability() {
        return 1;
    }

    protected int getScaledEnchantability() {
        return 10;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && this.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    public boolean func_92089_a(ItemStack stack) {
        return this.isEnabled() && this.field_77351_y.func_77557_a(stack.func_77973_b());
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<ITextComponent> getTooltipInfos(boolean isEnchantedBook) {
        ArrayList<ITextComponent> infos = new ArrayList<ITextComponent>();
        if (isEnchantedBook) {
            infos.add(this.info);
        }
        if (this.isInBeta()) {
            infos.add((ITextComponent)LangKey.TOOLTIP_BETA.getText(StyleType.MESSAGE_SPELL, new Object[0]));
        }
        if (!this.isEnabled()) {
            infos.add((ITextComponent)LangKey.MESSAGE_DISABLED.getText(StyleType.COLOR_OFF, new Object[0]));
        }
        return infos;
    }

    public String func_77320_a() {
        return "enchantment.tombstone." + this.customName;
    }

    public ITextComponent func_200305_d(int amplifier) {
        IFormattableTextComponent fullname = new TranslationTextComponent(this.func_77320_a()).func_240699_a_(TextFormatting.GRAY);
        return amplifier > 1 ? fullname.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(EffectHelper.getPotency(amplifier))) : fullname;
    }
}

