/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import ovh.corail.tombstone.api.capability.ISoulConsumer;
import ovh.corail.tombstone.capability.SoulConsumerProvider;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModTabs;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemFishingRodOfMisadventure
extends FishingRodItem
implements ISoulConsumer,
IDelayedNBTLoot {
    private final String name = "fishing_rod_of_misadventure";

    public ItemFishingRodOfMisadventure() {
        super(new Item.Properties().func_200916_a(ModTabs.mainTab).func_200915_b(32).func_234689_a_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World level, List<ITextComponent> tooltip, ITooltipFlag flag) {
        int speed;
        boolean isEnchanted = this.isEnchanted(stack);
        boolean isAncient = this.isAncient(stack);
        if (Helper.canShowTooltip(level, stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77667_c(stack) + ".desc" + (isEnchanted ? 2 : 1)).func_230530_a_(StyleType.TOOLTIP_DESC));
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77667_c(stack) + ".use" + (isEnchanted ? 2 : 1)).func_230530_a_(StyleType.TOOLTIP_USE));
        } else {
            tooltip.add((ITextComponent)LangKey.TOOLTIP_MORE_INFO.getText(StyleType.TOOLTIP_DESC, new Object[0]));
        }
        super.func_77624_a(stack, level, tooltip, flag);
        tooltip.add((ITextComponent)new TranslationTextComponent("enchantment.tombstone.fishing_bad_luck").func_240702_b_(" ").func_240702_b_(isAncient ? "X" : (isEnchanted ? "V" : "I")).func_230532_e_().func_240699_a_(TextFormatting.GRAY));
        int n = isAncient ? 5 : (speed = isEnchanted ? 2 : 0);
        if (speed > 0) {
            tooltip.add(Enchantments.field_151369_A.func_200305_d(speed));
        }
        if (isAncient) {
            tooltip.add(ModEnchantments.soulbound.func_200305_d(1));
        }
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((IItemProvider)this));
            ItemStack enchantedStack = NBTStackHelper.setBoolean(new ItemStack((IItemProvider)this), "enchant", true);
            items.add((Object)enchantedStack);
            items.add((Object)NBTStackHelper.setBoolean(enchantedStack.func_77946_l(), "ancient", true));
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        ITextComponent name = super.func_200295_i(stack);
        return (this.isAncient(stack) ? LangKey.MESSAGE_ANCIENT_ITEM.getText(name) : (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getText(name) : name.func_230531_f_())).func_230530_a_(StyleType.MESSAGE_SPECIAL);
    }

    public boolean isAncient(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "ancient");
    }

    public String getSimpleName() {
        return this.name;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean isEnchanted = this.isEnchanted(stack);
        if (player.field_71104_cf != null) {
            if (!world.func_201670_d()) {
                int damage = player.field_71104_cf.func_146034_e(stack);
                if (!isEnchanted) {
                    Helper.damageItem(stack, damage, (ServerPlayerEntity)player, hand);
                }
            }
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_193780_J, SoundCategory.NEUTRAL, 1.0f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
        } else {
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187612_G, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!world.func_201670_d()) {
                boolean isAncient = this.isAncient(stack);
                FishingBobberEntity fishingBobber = new FishingBobberEntity(player, world, 0, isAncient ? 5 : (isEnchanted ? 2 : 0));
                fishingBobber.field_191518_aw = -(isAncient ? 100 : (isEnchanted ? 50 : 10));
                world.func_217376_c((Entity)fishingBobber);
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.isEnchanted(stack) && super.showDurabilityBar(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        if (!this.isEnchanted(stack)) {
            super.setDamage(stack, damage);
        }
    }

    public int getItemEnchantability(ItemStack stack) {
        return 0;
    }

    public int func_77619_b() {
        return 0;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(World world, BlockPos gravePos, ServerPlayerEntity player, ItemStack stack, int soulStrength) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            stack.func_196085_b(0);
            if (!this.isAncient(stack) && soulStrength > 1) {
                NBTStackHelper.setBoolean(stack, "ancient", true);
                ModTriggers.CREATE_ANCIENT_FISHING_ROD.trigger(player);
                return ISoulConsumer.ConsumeResult.success((ITextComponent)LangKey.MESSAGE_ENCHANT_FISHING_ROD_SUCCESS.getText(new Object[0]), 2);
            }
            return ISoulConsumer.ConsumeResult.success((ITextComponent)LangKey.MESSAGE_ENCHANT_FISHING_ROD_SUCCESS.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    public String func_77658_a() {
        return "tombstone.item.fishing_rod_of_misadventure";
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new SoulConsumerProvider(this);
    }

    public String getCreatorModId(ItemStack itemStack) {
        return "tombstone";
    }

    @Override
    public ItemStack onDelayedLoot(ItemStack stack, CompoundNBT tag, LootContext context) {
        return NBTStackHelper.setBoolean(NBTStackHelper.setBoolean(stack, "enchant", true), "ancient", true);
    }
}

