/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.network.NetworkEvent;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.helper.Helper;

public class CMessageEffect {
    private final int entityId;
    private final EffectInstance effectInstance;

    public CMessageEffect(int entityId, EffectInstance effectInstance) {
        this.entityId = entityId;
        this.effectInstance = effectInstance;
    }

    static CMessageEffect fromBytes(PacketBuffer buf) {
        int id = buf.func_150792_a();
        Effect effect = (Effect)Optional.ofNullable(Registry.field_212631_t.func_148745_a(buf.func_150792_a())).orElse(Effects.field_76443_y);
        int duration = buf.func_150792_a();
        byte amplifier = buf.readByte();
        byte flags = buf.readByte();
        return new CMessageEffect(id, new EffectInstance(effect, duration, (int)amplifier, (flags & 1) == 1, (flags & 2) == 2, (flags & 4) == 4, null));
    }

    static void toBytes(CMessageEffect msg, PacketBuffer buf) {
        buf.func_150787_b(msg.entityId);
        Optional.of(Registry.field_212631_t.func_148757_b((Object)msg.effectInstance.func_188419_a())).filter(i -> i != -1).ifPresent(arg_0 -> ((PacketBuffer)buf).func_150787_b(arg_0));
        buf.func_150787_b(msg.effectInstance.func_76459_b());
        buf.writeByte(msg.effectInstance.func_76458_c());
        buf.writeByte((int)((byte)((msg.effectInstance.func_82720_e() ? 1 : 0) + (msg.effectInstance.func_188418_e() ? 2 : 0) + (msg.effectInstance.func_205348_f() ? 4 : 0))));
    }

    public static class Handler {
        static void handle(final CMessageEffect msg, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToClient(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        ModTombstone.PROXY.getClientWorld().map(level -> level.func_73045_a(msg.entityId)).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).ifPresent(entity -> {
                            EffectInstance effectInstance;
                            effectInstance.func_100012_b((effectInstance = new EffectInstance(msg.effectInstance)).func_76459_b() >= Short.MAX_VALUE);
                            entity.func_233646_e_(effectInstance);
                        });
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

