/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.model.SkeletonModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.entity.GraveGuardian;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemAdvancement;
import ovh.corail.tombstone.registry.ModItems;

@OnlyIn(value=Dist.CLIENT)
public class GraveGuardianItemInHandLayer
extends HeldItemLayer<GraveGuardian, SkeletonModel<GraveGuardian>> {
    private final ItemStack mainHand = new ItemStack((IItemProvider)Items.field_234754_kI_);
    private final ItemStack halloweenMainHand = new ItemStack((IItemProvider)Items.field_151011_C);
    private final ItemStack offHand = new ItemStack((IItemProvider)ModItems.advancement.get((Object)ItemAdvancement.IconType.SOUL_LANTERN));
    private final ItemStack halloweenOffHand = new ItemStack((IItemProvider)ModItems.advancement.get((Object)ItemAdvancement.IconType.LANTERN));
    private final ItemStack christmasMainHand = new ItemStack((IItemProvider)ModItems.villager_gift);
    private final ItemStack christmasOffHand = new ItemStack((IItemProvider)ModItems.christmas_gift);

    public GraveGuardianItemInHandLayer(IEntityRenderer<GraveGuardian, SkeletonModel<GraveGuardian>> parent) {
        super(parent);
    }

    public void render(MatrixStack poseStack, IRenderTypeBuffer bufferSource, int light, GraveGuardian graveGuardian, float p_117208_, float p_117209_, float p_117210_, float p_117211_, float p_117212_, float p_117213_) {
        poseStack.func_227860_a_();
        this.renderArmWithItem((LivingEntity)graveGuardian, this.getMainHand(), ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HandSide.RIGHT, poseStack, bufferSource, 0xF000F0);
        this.renderArmWithItem((LivingEntity)graveGuardian, this.getOffHand(), ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HandSide.LEFT, poseStack, bufferSource, 0xF000F0);
        poseStack.func_227865_b_();
    }

    private void renderArmWithItem(LivingEntity entity, ItemStack stack, ItemCameraTransforms.TransformType transformType, HandSide hand, MatrixStack poseStack, IRenderTypeBuffer iRenderTypeBuffer, int light) {
        if (!stack.func_190926_b()) {
            poseStack.func_227860_a_();
            ((SkeletonModel)this.func_215332_c()).func_225599_a_(hand, poseStack);
            poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
            boolean flag = hand == HandSide.LEFT;
            poseStack.func_227861_a_((double)((float)(flag ? -1 : 1) / 16.0f), 0.125, -0.625);
            Minecraft.func_71410_x().func_175597_ag().func_228397_a_(entity, stack, transformType, flag, poseStack, iRenderTypeBuffer, light);
            poseStack.func_227865_b_();
        }
    }

    private ItemStack getMainHand() {
        switch (TimeHelper.getSpecialEvent()) {
            case HALLOWEEN: {
                return this.halloweenMainHand;
            }
            case CHRISTMAS: {
                return this.christmasMainHand;
            }
        }
        return this.mainHand;
    }

    private ItemStack getOffHand() {
        switch (TimeHelper.getSpecialEvent()) {
            case HALLOWEEN: {
                return this.halloweenOffHand;
            }
            case CHRISTMAS: {
                return this.christmasOffHand;
            }
        }
        return this.offHand;
    }
}

