/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SkullBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.SkullTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.BlockGraveMarble;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.tileentity.TileEntityPlayerGrave;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

@OnlyIn(value=Dist.CLIENT)
public class RenderWritableGrave<T extends TileEntityWritableGrave>
extends TileEntityRenderer<T> {
    private static final ResourceLocation TEXTURE_SKELETON_HEAD = new ResourceLocation("minecraft", "textures/entity/skeleton/skeleton.png");

    public RenderWritableGrave(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(T te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int light, int destroyStage) {
        boolean renderHalloween;
        if (te == null || te.func_145831_w() == null) {
            return;
        }
        if (te instanceof TileEntityPlayerGrave && !((TileEntityPlayerGrave)((Object)te)).getNeedAccess()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            BlockState web = Blocks.field_196553_aF.func_176223_P();
            BlockRendererDispatcher rendererDispatcher = Minecraft.func_71410_x().func_175602_ab();
            rendererDispatcher.func_228791_a_(web, matrixStack, iRenderTypeBuffer, 0xF000F0, OverlayTexture.field_229196_a_);
            matrixStack.func_227861_a_(1.0, 0.0, 1.0);
            rendererDispatcher.func_228791_a_(web, matrixStack, iRenderTypeBuffer, 0xF000F0, OverlayTexture.field_229196_a_);
            matrixStack.func_227865_b_();
        }
        boolean bl = renderHalloween = ConfigTombstone.client.graveSkinRule.get() == ConfigTombstone.Client.GraveSkinRule.FORCE_HALLOWEEN || TimeHelper.isDateAroundHalloween() && ConfigTombstone.client.graveSkinRule.get() != ConfigTombstone.Client.GraveSkinRule.FORCE_NORMAL;
        if (!((TileEntityWritableGrave)((Object)te)).hasOwner() && !renderHalloween) {
            return;
        }
        BlockState knownState = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (!ModBlocks.isAnyGrave(knownState.func_177230_c())) {
            return;
        }
        Direction facing = (Direction)knownState.func_177229_b((Property)BlockStateProperties.field_208157_J);
        GraveModel graveModel = ((BlockGraveBase)knownState.func_177230_c()).getGraveType();
        BlockGraveMarble.MarbleType marbleType = BlockGraveMarble.MarbleType.byId((Integer)knownState.func_177229_b((Property)BlockGraveBase.MODEL_TEXTURE));
        if (renderHalloween) {
            this.renderHalloween(matrixStack, iRenderTypeBuffer, graveModel, marbleType, facing, light, Helper.isNight(te.func_145831_w()));
        }
        if (!((TileEntityWritableGrave)((Object)te)).hasOwner()) {
            return;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f * (float)(this.getRotationIndex(facing) - 2)));
        if (graveModel == GraveModel.GRAVE_CROSS) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            matrixStack.func_227861_a_(0.0, (double)0.26f, (double)-0.06f);
        } else {
            matrixStack.func_227863_a_(Vector3f.field_229178_a_.func_229187_a_(180.0f));
            switch (graveModel) {
                case GRAVE_SIMPLE: {
                    matrixStack.func_227861_a_(0.0, (double)-0.4f, (double)0.29f);
                    break;
                }
                case GRAVE_NORMAL: {
                    matrixStack.func_227861_a_(0.0, -0.5, (double)0.36f);
                    break;
                }
                case TOMBSTONE: {
                    matrixStack.func_227861_a_(0.0, (double)-0.23f, (double)-0.08f);
                    break;
                }
                case SUBARAKI_GRAVE: {
                    matrixStack.func_227861_a_(0.0, (double)-0.62f, (double)-0.14f);
                    break;
                }
                case GRAVE_ORIGINAL: {
                    matrixStack.func_227861_a_(0.0, (double)-0.2f, (double)-0.51f);
                    break;
                }
            }
        }
        FontRenderer fontRender = this.field_228858_b_.field_147557_n;
        boolean is_original = graveModel == GraveModel.GRAVE_ORIGINAL;
        this.showString((ITextComponent)LangKey.MESSAGE_RIP.getText(TextFormatting.BOLD, new Object[0]), matrixStack, fontRender, is_original ? 8 : 0, (Integer)ConfigTombstone.client.textColorRIP.get() + -16777216, 0.007f);
        this.showString((ITextComponent)new StringTextComponent(((TileEntityWritableGrave)((Object)te)).getOwnerName()).func_240699_a_(TextFormatting.BOLD), matrixStack, fontRender, is_original ? 14 : 11, (Integer)ConfigTombstone.client.textColorOwner.get() + -16777216, 0.005f);
        float scaleForDate = (Boolean)ConfigTombstone.client.dateInMCTime.get() != false ? 0.005f : 0.004f;
        this.showString((ITextComponent)LangKey.MESSAGE_DIED_ON.getText(TextFormatting.BOLD, new Object[0]), matrixStack, fontRender, 26, (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216, scaleForDate);
        if (((Boolean)ConfigTombstone.client.dateInMCTime.get()).booleanValue()) {
            long days = ((TileEntityWritableGrave)((Object)te)).getDeathMCTime() / 24000L;
            IFormattableTextComponent dateString = LangKey.MESSAGE_DAY.getText(TextFormatting.BOLD, new Object[]{days});
            this.showString((ITextComponent)dateString, matrixStack, fontRender, 36, (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216, scaleForDate);
        } else {
            Date date = new Date(((TileEntityWritableGrave)((Object)te)).getOwnerDeathTime());
            IFormattableTextComponent dateString = new StringTextComponent(new SimpleDateFormat("dd/MM/yyyy").format(date)).func_240699_a_(TextFormatting.BOLD);
            IFormattableTextComponent timeString = LangKey.MESSAGE_DEATH_TIME.getText(TextFormatting.BOLD, new Object[]{new SimpleDateFormat("HH:mm:ss").format(date)});
            this.showString((ITextComponent)dateString, matrixStack, fontRender, 36, (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216, scaleForDate);
            this.showString((ITextComponent)timeString, matrixStack, fontRender, 46, (Integer)ConfigTombstone.client.textColorDeathDate.get() + -16777216, scaleForDate);
        }
        matrixStack.func_227865_b_();
    }

    private void showString(ITextComponent content, MatrixStack matrixStack, FontRenderer fontRenderer, int posY, int color, float scale) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(scale, scale, scale);
        IReorderingProcessor ireorderingprocessor = content.func_241878_f();
        fontRenderer.func_238407_a_(matrixStack, ireorderingprocessor, (float)(-fontRenderer.func_243245_a(ireorderingprocessor)) / 2.0f, (float)(posY - 30), color);
        matrixStack.func_227865_b_();
    }

    private void renderHalloween(MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, GraveModel graveModel, BlockGraveMarble.MarbleType marbleType, Direction facing, int light, boolean isNight) {
        RenderSystem.enableRescaleNormal();
        RenderSystem.pushMatrix();
        RenderSystem.disableCull();
        RenderSystem.enableAlphaTest();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.0, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(90.0f * (float)this.getRotationIndex(facing)));
        if (graveModel == GraveModel.GRAVE_NORMAL || graveModel == GraveModel.GRAVE_SIMPLE) {
            if (graveModel == GraveModel.GRAVE_SIMPLE) {
                matrixStack.func_227861_a_(0.0, (double)0.21f, 0.0);
            } else {
                matrixStack.func_227861_a_(0.0, (double)0.41f, 0.0);
            }
            matrixStack.func_227862_a_(0.2f, 0.2f, 0.2f);
            ItemStack stack = new ItemStack((IItemProvider)(isNight ? Blocks.field_196628_cT : Blocks.field_150423_aK));
            Minecraft.func_71410_x().func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.NONE, false, matrixStack, iRenderTypeBuffer, 0xF000F0, OverlayTexture.field_229196_a_, Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, null, null));
        } else if (graveModel == GraveModel.TOMBSTONE) {
            Block block = marbleType == BlockGraveMarble.MarbleType.DARK ? Blocks.field_222432_lU : Blocks.field_235366_md_;
            matrixStack.func_227861_a_((double)-0.2f, (double)0.65f, (double)-0.2f);
            matrixStack.func_227862_a_(0.4f, 0.4f, 0.4f);
            Minecraft.func_71410_x().func_175602_ab().func_228791_a_(block.func_176223_P(), matrixStack, iRenderTypeBuffer, 0xF000F0, OverlayTexture.field_229196_a_);
        } else {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_SKELETON_HEAD);
            if (graveModel == GraveModel.SUBARAKI_GRAVE) {
                matrixStack.func_227861_a_((double)-0.35f, (double)0.44f, (double)-0.35f);
            } else if (graveModel == GraveModel.GRAVE_CROSS) {
                matrixStack.func_227861_a_((double)0.2f, (double)0.07f, 0.0);
            } else {
                matrixStack.func_227861_a_((double)-0.575f, (double)0.07f, (double)-0.35f);
            }
            matrixStack.func_227862_a_(0.3f, 0.3f, 0.3f);
            SkullTileEntityRenderer.func_228879_a_(null, (float)1.0f, (SkullBlock.ISkullType)SkullBlock.Types.SKELETON, null, (float)0.0f, (MatrixStack)matrixStack, (IRenderTypeBuffer)iRenderTypeBuffer, (int)(isNight ? 0xF000F0 : light));
        }
        matrixStack.func_227865_b_();
        RenderSystem.popMatrix();
    }

    private int getRotationIndex(Direction facing) {
        switch (facing) {
            case SOUTH: {
                return 2;
            }
            case WEST: {
                return 1;
            }
            case EAST: {
                return 3;
            }
        }
        return 0;
    }
}

