/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.multipart;

import mcjty.lib.multipart.MultipartBlock;
import mcjty.lib.multipart.MultipartTE;
import mcjty.lib.multipart.PartPos;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class MultipartHelper {
    public static TileEntity getTileEntity(IBlockReader access, BlockPos pos, PartSlot slot) {
        MultipartTE.Part part;
        TileEntity te = access.func_175625_s(pos);
        if (te instanceof MultipartTE && (part = ((MultipartTE)te).getParts().get((Object)slot)) != null) {
            return part.getTileEntity();
        }
        return null;
    }

    public static TileEntity getTileEntity(IBlockReader access, PartPos pos) {
        MultipartTE.Part part;
        TileEntity te = access.func_175625_s(pos.getPos());
        if (te instanceof MultipartTE && (part = ((MultipartTE)te).getParts().get((Object)pos.getSlot())) != null) {
            return part.getTileEntity();
        }
        return null;
    }

    public static BlockState getBlockState(IBlockReader access, BlockPos pos, PartSlot slot) {
        MultipartTE.Part part;
        TileEntity te = access.func_175625_s(pos);
        if (te instanceof MultipartTE && (part = ((MultipartTE)te).getParts().get((Object)slot)) != null) {
            return part.getState();
        }
        return null;
    }

    public static boolean removePart(MultipartTE multipartTE, BlockState state, PlayerEntity player, Vector3d hitVec) {
        BlockPos pos = multipartTE.func_174877_v();
        MultipartTE.Part hitPart = MultipartBlock.getHitPart(state, (IBlockReader)multipartTE.func_145831_w(), pos, MultipartHelper.getPlayerEyes(player), hitVec);
        if (hitPart == null) {
            return false;
        }
        BlockState hitState = hitPart.getState();
        TileEntity hitTile = hitPart.getTileEntity();
        ItemStack stack = new ItemStack((IItemProvider)hitState.func_177230_c().func_199767_j());
        if (hitTile instanceof GenericTileEntity) {
            CompoundNBT tagCompound = new CompoundNBT();
            ((GenericTileEntity)hitTile).onReplaced(multipartTE.func_145831_w(), multipartTE.func_174877_v(), hitState, hitState);
            stack.func_77982_d(tagCompound);
        }
        InventoryHelper.func_180173_a((World)multipartTE.func_145831_w(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
        multipartTE.removePart(hitState);
        return multipartTE.getParts().isEmpty();
    }

    private static RayTraceResult getMovingObjectPositionFromPlayer(World worldIn, PlayerEntity playerIn, boolean useLiquids) {
        float pitch = playerIn.field_70125_A;
        float yaw = playerIn.field_70177_z;
        Vector3d vec3 = MultipartHelper.getPlayerEyes(playerIn);
        float f2 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double reach = 5.0;
        if (playerIn instanceof ServerPlayerEntity) {
            // empty if block
        }
        Vector3d vec31 = vec3.func_72441_c((double)f6 * reach, (double)f5 * reach, (double)f7 * reach);
        RayTraceContext context = new RayTraceContext(vec3, vec31, RayTraceContext.BlockMode.COLLIDER, useLiquids ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE, (Entity)playerIn);
        return worldIn.func_217299_a(context);
    }

    public static Vector3d getPlayerEyes(PlayerEntity playerIn) {
        double x = playerIn.func_226277_ct_();
        double y = playerIn.func_226278_cu_() + (double)playerIn.func_70047_e();
        double z = playerIn.func_226281_cx_();
        return new Vector3d(x, y, z);
    }
}

