/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.client.model.PartTextures;
import net.silentchaos512.utils.Color;

public class MaterialLayer {
    protected final ResourceLocation texture;
    protected final PartType partType;
    protected final int color;
    protected final boolean animated;

    public MaterialLayer(PartTextures texture, int color) {
        this(texture.getTexture(), texture.getPartType(), color, texture.isAnimated());
    }

    public MaterialLayer(ResourceLocation texture, int color) {
        this(texture, color, true);
    }

    public MaterialLayer(ResourceLocation texture, int color, boolean animated) {
        this(texture, PartType.NONE, color, animated);
    }

    public MaterialLayer(ResourceLocation texture, PartType partType, int color, boolean animated) {
        this.texture = texture;
        this.partType = partType;
        this.color = color;
        this.animated = animated;
    }

    public MaterialLayer withColor(int color) {
        return new MaterialLayer(this.texture, this.partType, color, this.animated);
    }

    public ResourceLocation getTexture(GearType gearType, int animationFrame) {
        return this.getTexture(gearType.getName(), animationFrame);
    }

    public ResourceLocation getTexture(String texturePath, int animationFrame) {
        String path = "item/" + texturePath + "/" + this.texture.func_110623_a();
        String suffix = this.animated && animationFrame > 0 ? "_" + animationFrame : "";
        return new ResourceLocation(this.texture.func_110624_b(), path + suffix);
    }

    public ResourceLocation getTextureId() {
        return this.texture;
    }

    public PartType getPartType() {
        return this.partType;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isAnimated() {
        return this.animated;
    }

    public static MaterialLayer deserialize(PartGearKey key, JsonElement json) {
        if (json.isJsonObject()) {
            JsonObject jo = json.getAsJsonObject();
            ResourceLocation texture = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jo, (String)"texture"));
            int color = Color.from((JsonObject)jo, (String)"color", (int)0xFFFFFF).getColor();
            return new MaterialLayer(texture, key.getPartType(), color, true);
        }
        ResourceLocation texture = new ResourceLocation(json.getAsString());
        return new MaterialLayer(texture, key.getPartType(), 0xFFFFFF, false);
    }

    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("texture", this.texture.toString());
        if ((this.color & 0xFFFFFF) != 0xFFFFFF) {
            json.addProperty("color", Color.format((int)this.color));
        }
        return json;
    }

    public static MaterialLayer read(PacketBuffer buffer) {
        ResourceLocation texture = buffer.func_192575_l();
        int color = buffer.func_150792_a();
        PartType partType = PartType.getNonNull(buffer.func_192575_l());
        return new MaterialLayer(texture, partType, color, true);
    }

    public void write(PacketBuffer buffer) {
        buffer.func_192572_a(this.texture);
        buffer.func_150787_b(this.color);
        buffer.func_192572_a(this.partType.getName());
    }

    public String toString() {
        return "MaterialLayer{texture=" + this.texture + "partType=" + this.partType.getName() + ", color=" + Color.format((int)this.color) + '}';
    }
}

