/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.common.ToolType;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.client.util.ModelPropertiesHelper;
import net.silentchaos512.gear.event.GearEvents;
import net.silentchaos512.gear.item.gear.CoreCrossbow;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.client.gui.DebugRenderOverlay;

public class DebugOverlay
extends DebugRenderOverlay {
    private static final int SPLIT_WIDTH = 160;
    private static final float TEXT_SCALE = 0.7f;

    @Nonnull
    public List<String> getDebugText() {
        EntityRayTraceResult ert;
        Entity entity;
        ArrayList<String> list = new ArrayList<String>();
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            return list;
        }
        ItemStack heldItem = player.func_184586_b(Hand.MAIN_HAND);
        if (heldItem.func_190926_b()) {
            return list;
        }
        Item item = heldItem.func_77973_b();
        if (item instanceof CoreCrossbow) {
            float pull = ModelPropertiesHelper.getValue(heldItem, new ResourceLocation("pull"), mc.field_71441_e, (LivingEntity)player);
            float pulling = ModelPropertiesHelper.getValue(heldItem, new ResourceLocation("pulling"), mc.field_71441_e, (LivingEntity)player);
            float charged = ModelPropertiesHelper.getValue(heldItem, new ResourceLocation("charged"), mc.field_71441_e, (LivingEntity)player);
            float firework = ModelPropertiesHelper.getValue(heldItem, new ResourceLocation("firework"), mc.field_71441_e, (LivingEntity)player);
            list.add(String.format("pull=%.1f", Float.valueOf(pull)));
            list.add(String.format("pulling=%.1f", Float.valueOf(pulling)));
            list.add(String.format("charged=%.1f", Float.valueOf(charged)));
            list.add(String.format("firework=%.1f", Float.valueOf(firework)));
            list.add(String.format("chargeTime=%d", CoreCrossbow.getChargeTime(heldItem)));
            return list;
        }
        RayTraceResult rt = mc.field_71476_x;
        if (rt != null && rt.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult brt = (BlockRayTraceResult)rt;
            Entity renderViewEntity = mc.func_175606_aa();
            if (renderViewEntity != null) {
                BlockPos pos = brt.func_216350_a();
                BlockState state = renderViewEntity.field_70170_p.func_180495_p(pos);
                if (item instanceof ICoreTool) {
                    ToolType toolClass = state.func_177230_c().getHarvestTool(state);
                    int blockLevel = state.func_177230_c().getHarvestLevel(state);
                    int toolLevel = item.getHarvestLevel(heldItem, toolClass, (PlayerEntity)player, state);
                    boolean canHarvest = toolLevel >= blockLevel;
                    TextFormatting format = canHarvest ? TextFormatting.GREEN : TextFormatting.RED;
                    String name = toolClass == null ? "null" : toolClass.getName();
                    list.add(format + String.format("%s=%d (%d)", name, blockLevel, toolLevel));
                    float destroySpeed = heldItem.func_150997_a(state);
                    if (canHarvest) {
                        int level = TraitHelper.getTraitLevel(heldItem, Const.Traits.LUSTROUS);
                        int light = GearEvents.getLightForLustrousTrait((IBlockDisplayReader)player.field_70170_p, player.func_233580_cy_());
                        float newSpeed = destroySpeed + (float)GearEvents.getLustrousSpeedBonus(level, light);
                        list.add(String.format("speed = %.1f", Float.valueOf(newSpeed)));
                    } else {
                        list.add(String.format("speed = %.1f", Float.valueOf(destroySpeed)));
                    }
                }
            }
        } else if (rt != null && rt.func_216346_c() == RayTraceResult.Type.ENTITY && (entity = (ert = (EntityRayTraceResult)rt).func_216348_a()) instanceof LivingEntity) {
            list.add(String.format("%s", entity.func_195047_I_()));
            list.add(String.format("health = %.3f", Float.valueOf(((LivingEntity)entity).func_110143_aJ())));
        }
        return list;
    }

    private static void addAttributeInfo(List<String> list, PlayerEntity player, Attribute attribute) {
        ModifiableAttributeInstance attribute1 = player.func_110148_a(attribute);
        list.add(String.format("%s=%.1f (%dx mods)", attribute, attribute1.func_111126_e(), attribute1.func_225505_c_().size()));
    }

    public float getTextScale() {
        return 0.7f;
    }

    public int getSplitWidth() {
        return 160;
    }

    public boolean isHidden() {
        return !SilentGear.isDevBuild();
    }
}

