/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonParseException;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.util.Lazy;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.crafting.recipe.IGearRecipe;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapedRecipe;

public final class ShapedGearRecipe
extends ExtendedShapedRecipe
implements IGearRecipe {
    private final ICoreItem item;
    private final Lazy<ItemStack> exampleOutput;

    public ShapedGearRecipe(ShapedRecipe recipe) {
        super(recipe);
        ItemStack output = recipe.func_77571_b();
        if (!(output.func_77973_b() instanceof ICoreItem)) {
            throw new JsonParseException("result is not a gear item: " + output);
        }
        this.item = (ICoreItem)output.func_77973_b();
        this.exampleOutput = Lazy.of(() -> {
            ItemStack result = this.item.construct(GearHelper.getExamplePartsFromRecipe(this.item.getGearType(), (Iterable<Ingredient>)this.func_192400_c()));
            GearData.setExampleTag(result, true);
            return result;
        });
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.SHAPED_GEAR.get();
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        if (!this.getBaseRecipe().func_77569_a(inv, worldIn)) {
            return false;
        }
        GearType gearType = this.item.getGearType();
        for (PartData part : this.getParts((IInventory)inv)) {
            if (part.isCraftingAllowed(gearType, inv)) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        return this.item.construct(this.getParts((IInventory)inv));
    }

    @Override
    public ICoreItem getOutputItem() {
        return this.item;
    }

    public ItemStack func_77571_b() {
        return (ItemStack)this.exampleOutput.get();
    }

    public boolean func_192399_d() {
        return true;
    }
}

