/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.world;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Blocks;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.FeatureSpreadConfig;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.MultipleRandomFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ReplaceBlockConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.feature.template.TagMatchRuleTest;
import net.minecraft.world.gen.foliageplacer.AcaciaFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.placement.TopSolidRangeConfig;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.ForkyTrunkPlacer;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.util.ModResourceLocation;
import net.silentchaos512.gear.world.feature.NetherwoodTreeFeature;

@Mod.EventBusSubscriber(modid="silentgear")
public final class ModWorldFeatures {
    public static final RuleTest END_STONE_RULE_TEST = new TagMatchRuleTest((ITag)Tags.Blocks.END_STONES);
    public static final Lazy<BaseTreeFeatureConfig> NETHERWOOD_TREE_CONFIG = Lazy.of(() -> new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ModBlocks.NETHERWOOD_LOG.asBlockState()), (BlockStateProvider)new SimpleBlockStateProvider(ModBlocks.NETHERWOOD_LEAVES.asBlockState()), (FoliagePlacer)new AcaciaFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0)), (AbstractTrunkPlacer)new ForkyTrunkPlacer(5, 2, 2), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 2)).func_236700_a_().func_225568_b_());
    public static final Lazy<NetherwoodTreeFeature> NETHERWOOD_TREE_FEATURE = Lazy.of(() -> new NetherwoodTreeFeature((Codec<BaseTreeFeatureConfig>)BaseTreeFeatureConfig.field_236676_a_));
    private static boolean configuredFeaturesRegistered = false;

    private ModWorldFeatures() {
    }

    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().register(((NetherwoodTreeFeature)((Object)NETHERWOOD_TREE_FEATURE.get())).setRegistryName(SilentGear.getId("netherwood_tree")));
    }

    private static void registerConfiguredFeatures() {
        if (configuredFeaturesRegistered) {
            return;
        }
        configuredFeaturesRegistered = true;
        Configured.TO_REGISTER.forEach((name, cf) -> ModWorldFeatures.registerConfiguredFeature(name, (ConfiguredFeature)cf.get()));
    }

    private static void registerConfiguredFeature(String name, ConfiguredFeature<?, ?> configuredFeature) {
        ModResourceLocation id = SilentGear.getId(name);
        ModWorldFeatures.debugLog("Register configured feature " + (Object)((Object)id));
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)id, configuredFeature);
    }

    public static void registerPlacements(RegistryEvent.Register<Placement<?>> event) {
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent biome) {
        ModWorldFeatures.registerConfiguredFeatures();
        if (biome.getCategory() == Biome.Category.NETHER) {
            ModWorldFeatures.addNetherwoodTrees(biome);
            ModWorldFeatures.addCrimsonIronOre(biome);
        } else if (biome.getCategory() == Biome.Category.THEEND) {
            ModWorldFeatures.addAzureSilverOre(biome);
        } else {
            ModWorldFeatures.addBortOre(biome);
            if (biome.getCategory() == Biome.Category.EXTREME_HILLS || biome.getCategory() == Biome.Category.PLAINS) {
                ModWorldFeatures.addWildFlax(biome);
            }
            if (biome.getClimate().field_242463_e > 0.4f) {
                ModWorldFeatures.addWildFluffyPlants(biome);
            }
        }
    }

    private static void addWildFlax(BiomeLoadingEvent biome) {
        ModWorldFeatures.debugLog("Add wild flax to " + biome.getName());
        biome.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Configured.WILD_FLAX_PATCHES.get());
    }

    private static void addWildFluffyPlants(BiomeLoadingEvent biome) {
        ModWorldFeatures.debugLog("Add wild fluffy plants to " + biome.getName());
        biome.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Configured.WILD_FLUFFY_PATCHES.get());
    }

    private static void addNetherwoodTrees(BiomeLoadingEvent biome) {
        biome.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Configured.NETHERWOOD_TREES.get());
    }

    private static void addBortOre(BiomeLoadingEvent biome) {
        biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)Configured.BORT_ORE_VEINS.get());
    }

    private static void addCrimsonIronOre(BiomeLoadingEvent biome) {
        if (Biomes.field_235251_aB_.func_240901_a_().equals((Object)biome.getName()) || Biomes.field_235252_ay_.func_240901_a_().equals((Object)biome.getName())) {
            ModWorldFeatures.debugLog("Add double crimson iron ores to " + biome.getName());
            biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)Configured.DOUBLE_CRIMSON_IRON_ORE_VEINS.get());
        } else {
            ModWorldFeatures.debugLog("Add crimson iron ores to " + biome.getName());
            biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)Configured.CRIMSON_IRON_ORE_VEINS.get());
        }
    }

    private static void addAzureSilverOre(BiomeLoadingEvent biome) {
        ModWorldFeatures.debugLog("Add azure silver ores to " + biome.getName());
        biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)Configured.AZURE_SILVER_ORE_VEINS.get());
    }

    private static void debugLog(String msg) {
        if (((Boolean)Config.Common.worldGenLogging.get()).booleanValue()) {
            SilentGear.LOGGER.debug(msg);
        }
    }

    public static final class Configured {
        static final Map<String, Lazy<ConfiguredFeature<?, ?>>> TO_REGISTER = new LinkedHashMap();
        public static final Lazy<ConfiguredFeature<?, ?>> BORT_ORE_VEINS = Configured.createLazy("bort_ore_veins", () -> (ConfiguredFeature)((ConfiguredFeature)Feature.field_202294_an.func_225566_b_((IFeatureConfig)new ReplaceBlockConfig(Blocks.field_150348_b.func_176223_P(), ModBlocks.BORT_ORE.asBlockState())).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)Configured.topSolidRange(4, 20))).func_242728_a()).func_242731_b(((Integer)Config.Common.bortCount.get()).intValue()));
        public static final Lazy<ConfiguredFeature<?, ?>> CRIMSON_IRON_ORE_VEINS = Configured.createLazy("crimson_iron_ore_veins", () -> (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241884_c, ModBlocks.CRIMSON_IRON_ORE.asBlockState(), 8)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)Configured.topSolidRange(24, 120))).func_242728_a()).func_242731_b(((Integer)Config.Common.crimsonIronCount.get()).intValue()));
        public static final Lazy<ConfiguredFeature<?, ?>> DOUBLE_CRIMSON_IRON_ORE_VEINS = Configured.createLazy("double_crimson_iron_ore_veins", () -> (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241884_c, ModBlocks.CRIMSON_IRON_ORE.asBlockState(), 8)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)Configured.topSolidRange(24, 120))).func_242728_a()).func_242731_b(2 * (Integer)Config.Common.crimsonIronCount.get()));
        public static final Lazy<ConfiguredFeature<?, ?>> AZURE_SILVER_ORE_VEINS = Configured.createLazy("azure_silver_ore_veins", () -> (ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(END_STONE_RULE_TEST, ModBlocks.AZURE_SILVER_ORE.asBlockState(), 6)).func_227228_a_(Placement.field_242907_l.func_227446_a_((IPlacementConfig)Configured.topSolidRange(16, 92))).func_242728_a()).func_242731_b(((Integer)Config.Common.azureSilverCount.get()).intValue()));
        public static final Lazy<ConfiguredFeature<?, ?>> WILD_FLAX_PATCHES = Configured.createLazy("wild_flax_patches", () -> (ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ModBlocks.WILD_FLAX_PLANT.asBlockState()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(((Integer)Config.Common.wildFlaxTryCount.get()).intValue()).func_227322_d_()).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(((Integer)Config.Common.wildFlaxPatchCount.get()).intValue()));
        public static final Lazy<ConfiguredFeature<?, ?>> WILD_FLUFFY_PATCHES = Configured.createLazy("wild_fluffy_plant_patches", () -> (ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(ModBlocks.WILD_FLUFFY_PLANT.asBlockState()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(((Integer)Config.Common.wildFluffyTryCount.get()).intValue()).func_227322_d_()).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(((Integer)Config.Common.wildFluffyPatchCount.get()).intValue()));
        public static final Lazy<ConfiguredFeature<?, ?>> NETHERWOOD_TREES = Configured.createLazy("netherwood_trees", () -> (ConfiguredFeature)((ConfiguredFeature)Feature.field_202292_al.func_225566_b_((IFeatureConfig)new MultipleRandomFeatureConfig((List)ImmutableList.of((Object)((NetherwoodTreeFeature)((Object)((Object)NETHERWOOD_TREE_FEATURE.get()))).func_225566_b_((IFeatureConfig)NETHERWOOD_TREE_CONFIG.get()).func_227227_a_(0.8f)), ((NetherwoodTreeFeature)((Object)((Object)NETHERWOOD_TREE_FEATURE.get()))).func_225566_b_((IFeatureConfig)NETHERWOOD_TREE_CONFIG.get()))).func_227228_a_(Placement.field_242897_C.func_227446_a_((IPlacementConfig)new FeatureSpreadConfig(8))).func_242733_d(128)).func_242729_a(2));

        private static Lazy<ConfiguredFeature<?, ?>> createLazy(String name, Supplier<ConfiguredFeature<?, ?>> supplier) {
            if (TO_REGISTER.containsKey(name)) {
                throw new IllegalArgumentException("Configured feature lazy with name '" + name + "' already created");
            }
            Lazy lazy = Lazy.of(supplier);
            TO_REGISTER.put(name, lazy);
            return lazy;
        }

        @Nonnull
        private static TopSolidRangeConfig topSolidRange(int bottom, int top) {
            return new TopSolidRangeConfig(bottom, 0, top - bottom);
        }

        private Configured() {
        }
    }
}

