/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.randomium;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.mehvahdjukaar.randomium.block.RandomiumOreBlock;
import net.mehvahdjukaar.randomium.client.DuplicateItemRenderer;
import net.mehvahdjukaar.randomium.client.MovingBlockEntityRenderer;
import net.mehvahdjukaar.randomium.configs.CommonConfigs;
import net.mehvahdjukaar.randomium.entity.MovingBlockEntity;
import net.mehvahdjukaar.randomium.items.AnyItem;
import net.mehvahdjukaar.randomium.items.RandomiumItem;
import net.mehvahdjukaar.randomium.recipes.RandomiumRecipe;
import net.mehvahdjukaar.randomium.world.FeatureRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="randomium")
public class Randomium {
    public static final String MOD_ID = "randomium";
    private static final Logger LOGGER = LogManager.getLogger();
    private static Random RAND = new Random();
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"randomium");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"randomium");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"randomium");
    public static final DeferredRegister<IRecipeSerializer<?>> RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"randomium");
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"randomium");
    public static final RegistryObject<Block> RANDOMIUM_ORE = BLOCKS.register("randomium_ore", () -> new RandomiumOreBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().func_200948_a(4.0f, 3.0f).harvestTool(ToolType.PICKAXE).harvestLevel(2)));
    public static final RegistryObject<Item> RANDOMIUM_ORE_ITEM = ITEMS.register("randomium_ore", () -> new BlockItem((Block)RANDOMIUM_ORE.get(), new Item.Properties().func_200916_a(ItemGroup.field_78030_b)));
    public static final RegistryObject<Block> RANDOMIUM_END_ORE = BLOCKS.register("randomium_ore_end", () -> new RandomiumOreBlock(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150377_bs).func_235861_h_().func_200948_a(4.0f, 3.0f).harvestTool(ToolType.PICKAXE).harvestLevel(2)));
    public static final RegistryObject<Item> RANDOMIUM_END_ORE_ITEM = ITEMS.register("randomium_ore_end", () -> new BlockItem((Block)RANDOMIUM_END_ORE.get(), new Item.Properties().func_200916_a(ItemGroup.field_78030_b)));
    public static final RegistryObject<Item> RANDOMIUM_ITEM = ITEMS.register("randomium", () -> new RandomiumItem(new Item.Properties().func_200916_a(ItemGroup.field_78026_f).func_208103_a(Rarity.EPIC)));
    public static final RegistryObject<Item> DUPLICATE_ITEM = ITEMS.register("any_item", () -> new AnyItem(new Item.Properties().func_200916_a(null).setISTER(() -> DuplicateItemRenderer::new)));
    public static final RegistryObject<EntityType<MovingBlockEntity>> MOVING_BLOCK_ENTITY = ENTITIES.register("moving_block", () -> EntityType.Builder.func_220322_a(MovingBlockEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.98f, 0.98f).func_233606_a_(10).func_233608_b_(20).setCustomClientFactory(MovingBlockEntity::new).func_206830_a("moving_block"));
    public static final RegistryObject<IRecipeSerializer<?>> RANDOMIUM_CLONE_RECIPE = RECIPES.register("randomium_clone", () -> new SpecialRecipeSerializer(RandomiumRecipe::new));
    public static final RegistryObject<Feature<OreFeatureConfig>> RANDOMIUM_ORE_FEATURE = FEATURES.register("randomium_ore", () -> new FeatureRegistry.RandomiumFeature((Codec<OreFeatureConfig>)OreFeatureConfig.field_236566_a_));
    public static final List<List<ItemStack>> LOOT = new ArrayList<List<ItemStack>>();
    public static final List<ItemStack> SHUFFLED_ANY_ITEM = new ArrayList<ItemStack>();
    public static final List<SoundType> SOUNDS = new ArrayList<SoundType>();
    public static Tags.IOptionalNamedTag<Item> BLACKLIST = ItemTags.createOptional((ResourceLocation)Randomium.res("blacklist"));
    public static Tags.IOptionalNamedTag<Item> WHITELIST = ItemTags.createOptional((ResourceLocation)Randomium.res("whitelist"));
    private static final Predicate<Item> VALID_DROP = i -> {
        if (i == Items.field_190931_a) {
            return false;
        }
        if (i.func_206844_a(BLACKLIST)) {
            return false;
        }
        if (i instanceof SpawnEggItem) {
            return false;
        }
        String name = i.getRegistryName().func_110623_a();
        return !name.contains("creative") && !name.contains("debug") && !name.contains("developer") && !name.contains("dev_") && !name.contains("_dev");
    };

    public static ResourceLocation res(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public Randomium() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(bus);
        ITEMS.register(bus);
        ENTITIES.register(bus);
        RECIPES.register(bus);
        FEATURES.register(bus);
        CommonConfigs.registerSpec();
        bus.addListener(EventPriority.LOWEST, this::setup);
        bus.addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void addFeatureToBiomes(BiomeLoadingEvent event) {
        FeatureRegistry.addFeatureToBiomes(event);
    }

    @SubscribeEvent
    public void onTagLoad(TagsUpdatedEvent event) {
        if (LOOT.isEmpty()) {
            if (CommonConfigs.LOOT_MODE.get() == ListMode.BLACKLIST) {
                ForgeRegistries.ITEMS.getValues().stream().filter(VALID_DROP).forEach(i -> {
                    NonNullList temp = NonNullList.func_191196_a();
                    try {
                        Arrays.stream(ItemGroup.field_78032_a).forEach(t -> i.func_150895_a(t, temp));
                        if (!temp.isEmpty()) {
                            LOOT.add((List<ItemStack>)temp);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
                LOOT.add(Collections.singletonList(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)Potions.field_222126_O)));
            } else {
                WHITELIST.func_230236_b_().stream().map(Item::func_190903_i).forEach(i -> LOOT.add(Collections.singletonList(i)));
            }
        }
        SHUFFLED_ANY_ITEM.clear();
        SHUFFLED_ANY_ITEM.addAll(LOOT.stream().map(l -> (ItemStack)l.get(0)).collect(Collectors.toList()));
        Collections.shuffle(SHUFFLED_ANY_ITEM);
    }

    private void setup(FMLCommonSetupEvent event) {
        FeatureRegistry.init();
        ForgeRegistries.BLOCKS.getValues().stream().map(b -> b.func_220072_p(b.func_176223_P())).filter(s -> !SOUNDS.contains(s)).forEach(SOUNDS::add);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)MOVING_BLOCK_ENTITY.get()), MovingBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void onModelRegistry(ModelRegistryEvent event) {
    }

    public static enum ListMode {
        BLACKLIST,
        WHITELIST;

    }
}

