/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.randomium.recipes;

import net.mehvahdjukaar.randomium.Randomium;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;

public class RandomiumRecipe
extends SpecialRecipe {
    public RandomiumRecipe(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    private boolean isRandomium(ItemStack stack) {
        return stack.func_77973_b() == Randomium.RANDOMIUM_ITEM.get();
    }

    private boolean canBeDuplicated(ItemStack stack) {
        CompoundNBT tag = stack.func_77978_p();
        if (tag != null) {
            if (stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                return false;
            }
            String s = tag.toString();
            if (s.contains("Items:[") || s.contains("BlockEntityTag") || s.contains("Inventory:[") || s.contains("Drawers:[") || s.contains(((Item)Randomium.RANDOMIUM_ORE_ITEM.get()).getRegistryName().toString()) || s.contains(((Item)Randomium.RANDOMIUM_END_ORE_ITEM.get()).getRegistryName().toString()) || s.contains(((Item)Randomium.RANDOMIUM_ITEM.get()).getRegistryName().toString())) {
                return false;
            }
        }
        return !stack.func_77973_b().func_206844_a(Randomium.BLACKLIST);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ItemStack toDuplicate = null;
        ItemStack randomium = null;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (this.isRandomium(stack)) {
                if (randomium != null) {
                    return false;
                }
                randomium = stack;
                continue;
            }
            if (this.canBeDuplicated(stack)) {
                if (toDuplicate != null) {
                    return false;
                }
                toDuplicate = stack;
                continue;
            }
            return false;
        }
        return toDuplicate != null && randomium != null;
    }

    public ItemStack assemble(CraftingInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || this.isRandomium(stack) || !this.canBeDuplicated(stack)) continue;
            ItemStack s = stack.func_77946_l();
            s.func_190920_e(1);
            return s;
        }
        return ItemStack.field_190927_a;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i).func_77946_l();
            if (this.isRandomium(itemstack)) continue;
            itemstack.func_190920_e(1);
            nonnulllist.set(i, (Object)itemstack);
        }
        return nonnulllist;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)Randomium.RANDOMIUM_CLONE_RECIPE.get();
    }
}

